/*
 * Decompiled with CFR 0.152.
 */
package com.epam.jdi.light.logger;

import com.epam.jdi.light.driver.WebDriverFactory;
import com.epam.jdi.light.logger.ILogger;
import com.epam.jdi.light.logger.LogLevels;
import com.epam.jdi.tools.Safe;
import com.epam.jdi.tools.StringUtils;
import com.epam.jdi.tools.func.JAction;
import com.epam.jdi.tools.func.JFunc;
import com.epam.jdi.tools.map.MapArray;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.apache.logging.log4j.core.config.Configurator;

public class JDILogger
implements ILogger {
    private static MapArray<String, JDILogger> loggers = new MapArray();
    private static Marker jdiMarker = MarkerManager.getMarker((String)"JDI");
    private Safe<LogLevels> logLevel = new Safe((Object)LogLevels.INFO);
    private Safe<Integer> logOffDeepness = new Safe((Object)0);
    private String name;
    private Logger logger;
    private List<Long> multiThread = new ArrayList<Long>();

    public static JDILogger instance(String name) {
        if (!loggers.has((Object)name)) {
            loggers.add((Object)name, (Object)new JDILogger(name));
        }
        return (JDILogger)loggers.get((Object)name);
    }

    public JDILogger() {
        this("JDI");
    }

    public JDILogger(String name) {
        this.logger = LogManager.getLogger((String)name);
        this.name = name;
        this.setLogLevel(LogLevels.INFO);
    }

    public JDILogger(Class clazz) {
        this(clazz.getSimpleName());
    }

    @Override
    public LogLevels getLogLevel() {
        return (LogLevels)((Object)this.logLevel.get());
    }

    @Override
    public void setLogLevel(LogLevels level) {
        this.logLevel = new Safe((Object)level);
        Configurator.setRootLevel((Level)LogLevels.getLog4j2Level(level));
        Configurator.setLevel((String)this.name, (Level)LogLevels.getLog4j2Level(level));
    }

    @Override
    public void logOff() {
        this.logLevel.set((Object)LogLevels.OFF);
        this.logOffDeepness.update(v -> v + 1);
    }

    @Override
    public void logOn() {
        this.logOffDeepness.update(v -> v - 1);
        if ((Integer)this.logOffDeepness.get() > 0) {
            return;
        }
        if ((Integer)this.logOffDeepness.get() == 0) {
            this.logLevel.reset();
        }
        if ((Integer)this.logOffDeepness.get() < 0) {
            throw new RuntimeException("Log Off Deepness to high. Please check that each logOff has appropriate logOn");
        }
    }

    @Override
    public void dropLogOff() {
        this.logOffDeepness.set((Object)0);
        this.logLevel.reset();
    }

    @Override
    public void logOff(JAction action) {
        this.logOff(() -> {
            action.invoke();
            return null;
        });
    }

    @Override
    public <T> T logOff(JFunc<T> func) {
        Object result;
        LogLevels tempLevel = (LogLevels)((Object)this.logLevel.get());
        if (this.logLevel.get() == LogLevels.OFF) {
            try {
                return (T)func.invoke();
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        this.logLevel.set((Object)LogLevels.OFF);
        try {
            result = func.invoke();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        this.logLevel.set((Object)tempLevel);
        return (T)result;
    }

    private String getRecord(String record, Object ... args) {
        long currentThreadId = Thread.currentThread().getId();
        if (currentThreadId != WebDriverFactory.INIT_THREAD_ID && !this.multiThread.contains(currentThreadId)) {
            this.multiThread.add(currentThreadId);
        }
        return StringUtils.format((String)(this.multiThread.size() > 1 ? "[" + Thread.currentThread().getId() + "]" + record : record), (Object[])args);
    }

    public String getName() {
        return this.name;
    }

    @Override
    public void step(String s, Object ... args) {
        if (((LogLevels)((Object)this.logLevel.get())).equalOrLessThan(LogLevels.STEP)) {
            this.logger.log(Level.forName((String)"STEP", (int)350), jdiMarker, this.getRecord(s, args));
        }
    }

    public void trace(String s, Object ... args) {
        if (((LogLevels)((Object)this.logLevel.get())).equalOrLessThan(LogLevels.TRACE)) {
            this.logger.trace(jdiMarker, this.getRecord(s, args));
        }
    }

    @Override
    public void debug(String s, Object ... args) {
        if (((LogLevels)((Object)this.logLevel.get())).equalOrLessThan(LogLevels.DEBUG)) {
            this.logger.debug(jdiMarker, this.getRecord(s, args));
        }
    }

    @Override
    public void info(String s, Object ... args) {
        if (((LogLevels)((Object)this.logLevel.get())).equalOrLessThan(LogLevels.INFO)) {
            this.logger.info(jdiMarker, this.getRecord(s, args));
        }
    }

    @Override
    public void error(String s, Object ... args) {
        this.logger.error(jdiMarker, this.getRecord(s, args));
    }

    @Override
    public void toLog(String msg) {
        this.toLog(msg, (LogLevels)((Object)this.logLevel.getDefault()));
    }

    @Override
    public void toLog(String msg, LogLevels level) {
        if (((LogLevels)((Object)this.logLevel.get())).equalOrLessThan(level)) {
            switch (level) {
                case ERROR: {
                    this.error(msg, new Object[0]);
                    break;
                }
                case STEP: {
                    this.step(msg, new Object[0]);
                    break;
                }
                case INFO: {
                    this.info(msg, new Object[0]);
                    break;
                }
                case DEBUG: {
                    this.debug(msg, new Object[0]);
                    break;
                }
                case OFF: {
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown log level: " + (Object)((Object)level));
                }
            }
        }
    }
}

