/*
 * Decompiled with CFR 0.152.
 */
package com.epam.jdi.light.logger;

import com.epam.jdi.light.common.Exceptions;
import com.epam.jdi.light.driver.ScreenshotMaker;
import com.epam.jdi.light.elements.composite.WebPage;
import com.epam.jdi.light.settings.JDISettings;
import com.epam.jdi.tools.Timer;
import io.qameta.allure.Allure;
import io.qameta.allure.aspects.StepsAspects;
import io.qameta.allure.model.Status;
import io.qameta.allure.model.StepResult;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;

public class AllureLogger {
    public static AttachmentStrategy HTML_CODE_LOGGING = AttachmentStrategy.ON_FAIL;

    public static void screenshotStep(String screenName, boolean isNativeAlert) {
        String detailsUUID = AllureLogger.startStep(screenName);
        AllureLogger.createAttachment(screenName, isNativeAlert);
        StepsAspects.getLifecycle().stopStep(detailsUUID);
    }

    public static void createAttachment(String screenName, boolean isNativeAlert) {
        String screenPath;
        if (JDISettings.SCREEN.allowRobot || isNativeAlert) {
            Timer.sleep((long)200L);
            screenPath = ScreenshotMaker.takeRobotScreenshot(screenName);
        } else {
            screenPath = ScreenshotMaker.takeScreen(screenName);
        }
        if (StringUtils.isNotBlank((CharSequence)screenPath)) {
            try {
                AllureLogger.attachScreenshot(screenPath);
            }
            catch (IOException ex) {
                throw Exceptions.exception(ex, "", new Object[0]);
            }
        }
    }

    public static String startStep(String message) {
        if (!JDISettings.LOGS.writeToAllure) {
            return "";
        }
        try {
            StepResult step = new StepResult().withName(message);
            if (StepsAspects.getLifecycle().getCurrentTestCase().isPresent()) {
                String uuid = UUID.randomUUID().toString();
                StepsAspects.getLifecycle().startStep(uuid, step);
                return uuid;
            }
        }
        catch (Exception exception) {}
        return "";
    }

    public static void failStep(String uuid, String screenPath, String htmlSnapshot, String requests) {
        if (!JDISettings.LOGS.writeToAllure || StringUtils.isBlank((CharSequence)uuid)) {
            return;
        }
        if (StringUtils.isNotBlank((CharSequence)screenPath) || StringUtils.isNotBlank((CharSequence)htmlSnapshot) || StringUtils.isNotBlank((CharSequence)requests)) {
            String detailsUUID = AllureLogger.startStep("Failure details");
            try {
                try {
                    if (StringUtils.isNotBlank((CharSequence)screenPath)) {
                        AllureLogger.attachScreenshot(screenPath);
                    }
                    if (StringUtils.isNotBlank((CharSequence)htmlSnapshot)) {
                        AllureLogger.attachText("HTML Code Snapshot", "text/html", htmlSnapshot);
                    }
                    if (StringUtils.isNotBlank((CharSequence)requests)) {
                        AllureLogger.attachText("HTTP Requests", "text/plain", requests);
                    }
                }
                catch (Exception ex) {
                    throw Exceptions.exception(ex, "Failed to add attachments to Allure step", new Object[0]);
                }
            }
            finally {
                StepsAspects.getLifecycle().stopStep(detailsUUID);
            }
        }
    }

    public static void passStep(String uuid) {
        if (!JDISettings.LOGS.writeToAllure || StringUtils.isBlank((CharSequence)uuid)) {
            return;
        }
        StepsAspects.getLifecycle().updateStep(uuid, s -> {
            StepResult stepResult = s.setStatus(Status.PASSED);
        });
        StepsAspects.getLifecycle().stopStep(uuid);
    }

    public static void attachText(String name, String type, String htmlSnapshot) {
        Allure.addAttachment((String)name, (String)type, (String)htmlSnapshot, (String)"html");
    }

    public static void attachScreenshot(String screenName) throws IOException {
        Allure.addAttachment((String)"Page screenshot", (InputStream)new ByteArrayInputStream(Files.readAllBytes(Paths.get(screenName, new String[0]))));
    }

    public static String takeHtmlCodeOnFailure() {
        if (HTML_CODE_LOGGING == AttachmentStrategy.OFF) {
            return null;
        }
        return WebPage.getHtml();
    }

    public static enum AttachmentStrategy {
        ON_FAIL,
        OFF;

    }
}

