/*
 * Decompiled with CFR 0.152.
 */
package com.epam.jdi.light.elements.common;

import com.epam.jdi.light.actions.ActionProcessor;
import com.epam.jdi.light.common.Exceptions;
import com.epam.jdi.light.common.JDIAction;
import com.epam.jdi.light.driver.WebDriverFactory;
import com.epam.jdi.light.elements.common.WindowsManager$AjcClosure1;
import com.epam.jdi.light.elements.common.WindowsManager$AjcClosure11;
import com.epam.jdi.light.elements.common.WindowsManager$AjcClosure13;
import com.epam.jdi.light.elements.common.WindowsManager$AjcClosure15;
import com.epam.jdi.light.elements.common.WindowsManager$AjcClosure17;
import com.epam.jdi.light.elements.common.WindowsManager$AjcClosure19;
import com.epam.jdi.light.elements.common.WindowsManager$AjcClosure3;
import com.epam.jdi.light.elements.common.WindowsManager$AjcClosure5;
import com.epam.jdi.light.elements.common.WindowsManager$AjcClosure7;
import com.epam.jdi.light.elements.common.WindowsManager$AjcClosure9;
import com.epam.jdi.tools.map.MapArray;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.openqa.selenium.Dimension;

public class WindowsManager {
    private static Set<String> windowHandles;
    private static MapArray<String, String> windowHandlesMap;
    private static boolean newWindow;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;

    static {
        WindowsManager.ajc$preClinit();
        windowHandlesMap = new MapArray();
        newWindow = false;
    }

    public static Set<String> getWindows() {
        Set wHandles = WebDriverFactory.getDriver().getWindowHandles();
        if (windowHandles != null && windowHandles.size() < wHandles.size()) {
            newWindow = true;
        }
        windowHandles = wHandles;
        return windowHandles;
    }

    public static boolean newWindowIsOpened() {
        WindowsManager.getWindows();
        if (newWindow) {
            newWindow = false;
            return true;
        }
        return false;
    }

    @JDIAction(value="Check that new window is opened")
    public static void checkNewWindowIsOpened() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, null, null);
        Object[] objectArray = new Object[]{joinPoint};
        WindowsManager$AjcClosure1 windowsManager$AjcClosure1 = new WindowsManager$AjcClosure1(objectArray);
        ActionProcessor.aspectOf().jdiAround(windowsManager$AjcClosure1.linkClosureAndJoinPoint(65536));
    }

    public static void setWindowName(String value) {
        windowHandlesMap.update((Object)value, (Object)WebDriverFactory.getDriver().getWindowHandle());
    }

    @JDIAction(value="Get windows count")
    public static int windowsCount() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, null, null);
        Object[] objectArray = new Object[]{joinPoint};
        WindowsManager$AjcClosure3 windowsManager$AjcClosure3 = new WindowsManager$AjcClosure3(objectArray);
        return Conversions.intValue((Object)ActionProcessor.aspectOf().jdiAround(windowsManager$AjcClosure3.linkClosureAndJoinPoint(65536)));
    }

    @JDIAction(value="Switch to new window")
    public static void switchToNewWindow() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, null, null);
        Object[] objectArray = new Object[]{joinPoint};
        WindowsManager$AjcClosure5 windowsManager$AjcClosure5 = new WindowsManager$AjcClosure5(objectArray);
        ActionProcessor.aspectOf().jdiAround(windowsManager$AjcClosure5.linkClosureAndJoinPoint(65536));
    }

    @JDIAction(value="Open new tab")
    public static void openNewTab() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, null, null);
        Object[] objectArray = new Object[]{joinPoint};
        WindowsManager$AjcClosure7 windowsManager$AjcClosure7 = new WindowsManager$AjcClosure7(objectArray);
        ActionProcessor.aspectOf().jdiAround(windowsManager$AjcClosure7.linkClosureAndJoinPoint(65536));
    }

    @JDIAction(value="Go back to original window")
    public static void originalWindow() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, null, null);
        Object[] objectArray = new Object[]{joinPoint};
        WindowsManager$AjcClosure9 windowsManager$AjcClosure9 = new WindowsManager$AjcClosure9(objectArray);
        ActionProcessor.aspectOf().jdiAround(windowsManager$AjcClosure9.linkClosureAndJoinPoint(65536));
    }

    @JDIAction(value="Switch to window '{index}'")
    public static void switchToWindow(int index) {
        int n = index;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, null, null, (Object)Conversions.intObject((int)n));
        Object[] objectArray = new Object[]{Conversions.intObject((int)n), joinPoint};
        WindowsManager$AjcClosure11 windowsManager$AjcClosure11 = new WindowsManager$AjcClosure11(objectArray);
        ActionProcessor.aspectOf().jdiAround(windowsManager$AjcClosure11.linkClosureAndJoinPoint(65536));
    }

    @JDIAction(value="Switch to window '{0}'")
    public static void switchToWindow(String value) {
        String string = value;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, null, null, (Object)string);
        Object[] objectArray = new Object[]{string, joinPoint};
        WindowsManager$AjcClosure13 windowsManager$AjcClosure13 = new WindowsManager$AjcClosure13(objectArray);
        ActionProcessor.aspectOf().jdiAround(windowsManager$AjcClosure13.linkClosureAndJoinPoint(65536));
    }

    @JDIAction(value="Close current window")
    public static void closeWindow() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, null, null);
        Object[] objectArray = new Object[]{joinPoint};
        WindowsManager$AjcClosure15 windowsManager$AjcClosure15 = new WindowsManager$AjcClosure15(objectArray);
        ActionProcessor.aspectOf().jdiAround(windowsManager$AjcClosure15.linkClosureAndJoinPoint(65536));
    }

    @JDIAction(value="Close window '{0}'")
    public static void closeWindow(String value) {
        String string = value;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, null, null, (Object)string);
        Object[] objectArray = new Object[]{string, joinPoint};
        WindowsManager$AjcClosure17 windowsManager$AjcClosure17 = new WindowsManager$AjcClosure17(objectArray);
        ActionProcessor.aspectOf().jdiAround(windowsManager$AjcClosure17.linkClosureAndJoinPoint(65536));
    }

    @JDIAction(value="Resize window '{0}'")
    public static void resizeWindow(int width, int height) {
        int n = width;
        int n2 = height;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, null, null, (Object)Conversions.intObject((int)n), (Object)Conversions.intObject((int)n2));
        Object[] objectArray = new Object[]{Conversions.intObject((int)n), Conversions.intObject((int)n2), joinPoint};
        WindowsManager$AjcClosure19 windowsManager$AjcClosure19 = new WindowsManager$AjcClosure19(objectArray);
        ActionProcessor.aspectOf().jdiAround(windowsManager$AjcClosure19.linkClosureAndJoinPoint(65536));
    }

    static final /* synthetic */ void checkNewWindowIsOpened_aroundBody0(JoinPoint joinPoint) {
        boolean isNewWindow = WindowsManager.newWindowIsOpened();
        if (!isNewWindow) {
            throw Exceptions.exception("New window is not opened", new Object[0]);
        }
        WindowsManager.switchToNewWindow();
    }

    static final /* synthetic */ int windowsCount_aroundBody2(JoinPoint joinPoint) {
        return WindowsManager.getWindows().size();
    }

    static final /* synthetic */ void switchToNewWindow_aroundBody4(JoinPoint joinPoint) {
        String last = "";
        Iterator<String> iterator = WindowsManager.getWindows().iterator();
        while (iterator.hasNext()) {
            String window;
            last = window = iterator.next();
        }
        if (StringUtils.isBlank((CharSequence)last)) {
            throw Exceptions.exception("No windows found", new Object[0]);
        }
        WebDriverFactory.getDriver().switchTo().window(last);
    }

    static final /* synthetic */ void openNewTab_aroundBody6(JoinPoint joinPoint) {
        WebDriverFactory.jsExecute("window.open()", new Object[0]);
    }

    static final /* synthetic */ void originalWindow_aroundBody8(JoinPoint joinPoint) {
        WebDriverFactory.getDriver().switchTo().window(WindowsManager.getWindows().iterator().next());
    }

    static final /* synthetic */ void switchToWindow_aroundBody10(int index, JoinPoint joinPoint) {
        if (index < 1) {
            throw Exceptions.exception("Window's index starts from 1. You try to use '%s' that less than 1.", index);
        }
        int counter = 0;
        if (WindowsManager.getWindows().size() < index) {
            throw Exceptions.exception(String.valueOf(index) + " is too much. Only " + WindowsManager.getWindows().size() + " windows found", new Object[0]);
        }
        for (String window : WindowsManager.getWindows()) {
            if (++counter != index) continue;
            WebDriverFactory.getDriver().switchTo().window(window);
            return;
        }
    }

    static final /* synthetic */ void switchToWindow_aroundBody12(String value, JoinPoint joinPoint) {
        if (!windowHandlesMap.has((Object)value)) {
            throw Exceptions.exception("Window %s not registered. Use setWindowName method to setup window name for current windowHandle", value);
        }
        WebDriverFactory.getDriver().switchTo().window((String)windowHandlesMap.get((Object)value));
    }

    static final /* synthetic */ void closeWindow_aroundBody14(JoinPoint joinPoint) {
        WebDriverFactory.getDriver().close();
        WindowsManager.originalWindow();
    }

    static final /* synthetic */ void closeWindow_aroundBody16(String value, JoinPoint joinPoint) {
        WindowsManager.switchToWindow(value);
        WindowsManager.closeWindow();
    }

    static final /* synthetic */ void resizeWindow_aroundBody18(int width, int height, JoinPoint joinPoint) {
        WebDriverFactory.getDriver().manage().window().setSize(new Dimension(width, height));
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("WindowsManager.java", WindowsManager.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "checkNewWindowIsOpened", "com.epam.jdi.light.elements.common.WindowsManager", "", "", "", "void"), 43);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "windowsCount", "com.epam.jdi.light.elements.common.WindowsManager", "", "", "", "int"), 58);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "switchToNewWindow", "com.epam.jdi.light.elements.common.WindowsManager", "", "", "", "void"), 66);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "openNewTab", "com.epam.jdi.light.elements.common.WindowsManager", "", "", "", "void"), 79);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "originalWindow", "com.epam.jdi.light.elements.common.WindowsManager", "", "", "", "void"), 87);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "switchToWindow", "com.epam.jdi.light.elements.common.WindowsManager", "int", "index", "", "void"), 96);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "switchToWindow", "com.epam.jdi.light.elements.common.WindowsManager", "java.lang.String", "value", "", "void"), 116);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "closeWindow", "com.epam.jdi.light.elements.common.WindowsManager", "", "", "", "void"), 126);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "closeWindow", "com.epam.jdi.light.elements.common.WindowsManager", "java.lang.String", "value", "", "void"), 136);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "resizeWindow", "com.epam.jdi.light.elements.common.WindowsManager", "int:int", "width:height", "", "void"), 146);
    }
}

