/*
 * Decompiled with CFR 0.152.
 */
package com.epam.jdi.light.driver.get;

import com.epam.jdi.light.common.Exceptions;

public enum DriverTypes {
    CHROME("chrome"),
    FIREFOX("firefox"),
    IE("ie"),
    EDGE("edge"),
    OPERA("opera"),
    SAFARI("safari");

    public final String name;

    public static DriverTypes getByName(String name) {
        switch (name.toLowerCase()) {
            case "chrome": {
                return CHROME;
            }
            case "firefox": {
                return FIREFOX;
            }
            case "ie": 
            case "internetexplorer": {
                return IE;
            }
            case "edge": {
                return EDGE;
            }
            case "phantom": 
            case "opera": {
                return OPERA;
            }
            case "safari": {
                return SAFARI;
            }
        }
        throw Exceptions.exception("Unknown driver: " + name, new Object[0]);
    }

    private DriverTypes(String name) {
        this.name = name;
    }
}

