/*
 * Decompiled with CFR 0.152.
 */
package com.epam.jdi.light.driver;

import com.epam.jdi.light.common.Exceptions;
import com.epam.jdi.light.driver.get.DownloadDriverManager;
import com.epam.jdi.light.driver.get.DriverInfo;
import com.epam.jdi.light.driver.get.DriverTypes;
import com.epam.jdi.light.settings.JDISettings;
import com.epam.jdi.light.settings.WebSettings;
import com.epam.jdi.tools.Safe;
import com.epam.jdi.tools.StringUtils;
import com.epam.jdi.tools.func.JFunc;
import com.epam.jdi.tools.map.MapArray;
import com.epam.jdi.tools.pairs.Pair;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebDriver;

public class WebDriverFactory {
    public static MapArray<String, JFunc<WebDriver>> DRIVERS = new MapArray((Object)"chrome", () -> WebDriverFactory.initDriver(DriverTypes.CHROME));
    public static boolean SINGLE_THREAD = false;
    private static MapArray<String, WebDriver> RUN_DRIVERS = new MapArray();
    private static Safe<MapArray<String, WebDriver>> THREAD_RUN_DRIVERS = new Safe(MapArray::new);
    public static long INIT_THREAD_ID = -1L;
    public static boolean SWITCH_THREAD = false;
    public static WebDriver INIT_DRIVER;

    private WebDriverFactory() {
    }

    public static boolean noRunDrivers() {
        return !WebDriverFactory.getRunDrivers().any();
    }

    private static MapArray<String, WebDriver> getRunDrivers() {
        WebSettings.logger.debug("SINGLE_THREAD=" + SINGLE_THREAD, new Object[0]);
        return SINGLE_THREAD ? RUN_DRIVERS : (MapArray)THREAD_RUN_DRIVERS.get();
    }

    private static void setRunDrivers(MapArray<String, WebDriver> map) {
        if (SINGLE_THREAD) {
            RUN_DRIVERS = map;
        } else {
            THREAD_RUN_DRIVERS.set(map);
        }
    }

    public static WebDriver getDriverByName(String driverName) {
        WebSettings.logger.debug("getDriverByName(%s)", driverName);
        ReentrantLock lock = new ReentrantLock();
        if (!SWITCH_THREAD && INIT_DRIVER != null && INIT_THREAD_ID != Thread.currentThread().getId()) {
            WebSettings.logger.debug("SWITCH_THREAD = true", new Object[0]);
            WebDriverFactory.setRunDrivers((MapArray<String, WebDriver>)MapArray.map((Pair[])new Pair[]{Pair.$((Object)driverName, (Object)INIT_DRIVER)}));
            SWITCH_THREAD = true;
            return INIT_DRIVER;
        }
        if (!DRIVERS.has((Object)driverName)) {
            WebSettings.logger.debug("Has no driver", new Object[0]);
            WebDriverFactory.useDriver(driverName);
        }
        try {
            lock.lock();
            WebSettings.logger.debug("Lock", new Object[0]);
            MapArray rDrivers = WebDriverFactory.getRunDrivers();
            if (rDrivers == null) {
                WebSettings.logger.debug("rDrivers == null", new Object[0]);
                rDrivers = new MapArray();
            }
            if (!rDrivers.has((Object)driverName)) {
                WebSettings.logger.debug("rDrivers has no " + driverName, new Object[0]);
                WebDriver resultDriver = (WebDriver)((JFunc)DRIVERS.get((Object)driverName)).invoke();
                rDrivers.add((Object)driverName, (Object)resultDriver);
                WebDriverFactory.setRunDrivers((MapArray<String, WebDriver>)rDrivers);
                WebSettings.logger.debug("setRunDrivers", new Object[0]);
            }
            WebSettings.logger.debug("Get '%s' driver", driverName);
            WebDriver driver = null;
            try {
                driver = (WebDriver)rDrivers.get((Object)driverName);
            }
            catch (Throwable ex) {
                if (DownloadDriverManager.driverDownloaded) {
                    throw Exceptions.exception(ex, "Failed to run downloaded driver. Please check that your browser and driver are compatible or use local driver with 'drivers.folder' property in test.properties'." + StringUtils.LINE_BREAK + "Driver: " + DownloadDriverManager.downloadedDriverInfo + StringUtils.LINE_BREAK + "DriverPath: " + DownloadDriverManager.driverPath, new Object[0]);
                }
                throw Exceptions.exception(ex, "Failed to run driver", new Object[0]);
            }
            WebSettings.logger.debug("Success: " + driver, new Object[0]);
            if (driver.toString().contains("(null)")) {
                WebSettings.logger.debug("driver contains (null)", new Object[0]);
                driver = (WebDriver)((JFunc)DRIVERS.get((Object)driverName)).invoke();
                rDrivers.update((Object)driverName, (Object)driver);
                WebSettings.logger.debug("update rDrivers", new Object[0]);
            }
            if (!SWITCH_THREAD && INIT_THREAD_ID == Thread.currentThread().getId()) {
                WebSettings.logger.debug("INIT_DRIVER = driver", new Object[0]);
                INIT_DRIVER = driver;
            }
            WebSettings.logger.debug("driver.manage().timeouts()", new Object[0]);
            driver.manage().timeouts().implicitlyWait(0L, TimeUnit.SECONDS);
            WebDriver webDriver = driver;
            return webDriver;
        }
        catch (Throwable ex) {
            throw Exceptions.exception(ex, "Can't get driver; Thread: " + Thread.currentThread().getId() + StringUtils.LINE_BREAK + String.format("Drivers: %s; Run: %s", DRIVERS, WebDriverFactory.getRunDrivers()), new Object[0]);
        }
        finally {
            lock.unlock();
        }
    }

    public static String useDriver(JFunc<WebDriver> driver) {
        return WebDriverFactory.useDriver("Driver" + (DRIVERS.size() + 1), driver);
    }

    public static String useDriver(String driverName) {
        return WebDriverFactory.useDriver(driverName, (JFunc<WebDriver>)((JFunc)() -> ((DriverInfo)((Object)((Object)JDISettings.DRIVER.types.get((Object)driverName)))).getDriver()));
    }

    public static String useDriver(DriverTypes driverType) {
        return WebDriverFactory.useDriver(driverType.name);
    }

    private static WebDriver initDriver(DriverTypes type) {
        if (!JDISettings.DRIVER.types.has((Object)type.name)) {
            throw Exceptions.exception("Unknown driver: " + (Object)((Object)type), new Object[0]);
        }
        WebDriver driver = ((DriverInfo)((Object)JDISettings.DRIVER.types.get((Object)type.name))).getDriver();
        return (WebDriver)JDISettings.DRIVER.setup.execute((Object)driver);
    }

    public static String useDriver(DriverTypes driverType, JFunc<WebDriver> driver) {
        return WebDriverFactory.useDriver(driverType.name, driver);
    }

    public static String useDriver(String driverName, JFunc<WebDriver> driver) {
        if (DRIVERS.has((Object)driverName)) {
            throw Exceptions.exception("Can't register WebDriver '%s'. Driver with same name already registered", driverName);
        }
        DRIVERS.add((Object)driverName, driver);
        JDISettings.DRIVER.name = driverName;
        return driverName;
    }

    public static <T> T jsExecute(String script, Object ... args) {
        return (T)((JavascriptExecutor)WebDriverFactory.getDriver()).executeScript(script, args);
    }

    public static WebDriver getDriver() {
        try {
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)JDISettings.DRIVER.name)) {
                return WebDriverFactory.getDriver(JDISettings.DRIVER.name);
            }
            WebDriverFactory.useDriver(DriverTypes.CHROME);
            return WebDriverFactory.getDriver(DriverTypes.CHROME.name);
        }
        catch (Exception ex) {
            throw Exceptions.exception(ex, "Can't get WebDriver", new Object[0]);
        }
    }

    public static WebDriver getDriver(String driverName) {
        return (WebDriver)JDISettings.DRIVER.getFunc.execute((Object)driverName);
    }

    public static JavascriptExecutor getJSExecutor() {
        if (WebDriverFactory.getDriver() instanceof JavascriptExecutor) {
            return (JavascriptExecutor)WebDriverFactory.getDriver();
        }
        throw new ClassCastException("JavaScript Executor doesn't support");
    }

    public static void reopenDriver() {
        WebDriverFactory.reopenDriver(JDISettings.DRIVER.name);
    }

    public static void reopenDriver(String driverName) {
        MapArray<String, WebDriver> rDriver = WebDriverFactory.getRunDrivers();
        if (rDriver.has((Object)driverName)) {
            WebDriverFactory.closeDriver((WebDriver)rDriver.get((Object)driverName));
            rDriver.removeByKey((Object)driverName);
            WebDriverFactory.setRunDrivers(rDriver);
        }
        if (DRIVERS.has((Object)driverName)) {
            WebDriverFactory.getDriver();
        }
    }

    public static void switchToDriver(String driverName) {
        if (!DRIVERS.has((Object)driverName)) {
            throw Exceptions.exception("Can't switch to WebDriver '%s'. This Driver name not registered", driverName);
        }
        JDISettings.DRIVER.name = driverName;
    }

    public static void close() {
        for (Pair pair : WebDriverFactory.getRunDrivers()) {
            WebDriverFactory.closeDriver((WebDriver)pair.value);
        }
        WebDriverFactory.getRunDrivers().clear();
    }

    private static void closeDriver(WebDriver driver) {
        try {
            driver.close();
            driver.quit();
        }
        catch (Exception exception) {}
    }

    public static void quit() {
        WebDriverFactory.close();
    }
}

