/*
 * Decompiled with CFR 0.152.
 */
package com.epam.jdi.light.actions;

import com.epam.jdi.light.actions.ActionHelper;
import com.epam.jdi.light.elements.base.DriverBase;
import com.epam.jdi.tools.func.JAction1;
import com.epam.jdi.tools.func.JFunc1;
import com.epam.jdi.tools.map.MapArray;
import com.epam.jdi.tools.pairs.Pair;
import org.apache.logging.log4j.util.Strings;
import org.aspectj.lang.JoinPoint;

public class ActionOverride {
    static MapArray<JFunc1<JoinPoint, Boolean>, JFunc1<Object, Object>> OVERRIDE_ACTIONS_LIST = new MapArray();

    private ActionOverride() {
    }

    public static void overrideFunction(JFunc1<JoinPoint, Boolean> condition, JFunc1<Object, Object> func) {
        OVERRIDE_ACTIONS_LIST.add(condition, func);
    }

    public static void overrideFunction(String actionName, JFunc1<Object, Object> func) {
        OVERRIDE_ACTIONS_LIST.add(jp -> jp.getSignature().getName().equalsIgnoreCase(actionName), func);
    }

    public static void overrideFunction(String typeName, String actionName, JFunc1<Object, Object> func) {
        OVERRIDE_ACTIONS_LIST.add(jp -> ActionOverride.getJpTypeName(jp).equalsIgnoreCase(typeName) && jp.getSignature().getName().equalsIgnoreCase(actionName), func);
    }

    private static String getJpTypeName(JoinPoint jp) {
        Object obj = jp.getThis();
        if (obj == null) {
            return ActionHelper.getJpClass(jp).getSimpleName();
        }
        String typeName = ((DriverBase)jp.getThis()).typeName;
        return Strings.isNotBlank((String)typeName) ? typeName : jp.getThis().getClass().getSimpleName();
    }

    public static void overrideAction(JFunc1<JoinPoint, Boolean> condition, JAction1<Object> action) {
        ActionOverride.overrideFunction(condition, (JFunc1<Object, Object>)((JFunc1)jdi -> {
            action.execute(jdi);
            return null;
        }));
    }

    public static void overrideAction(String actionName, JAction1<Object> action) {
        ActionOverride.overrideFunction(actionName, (JFunc1<Object, Object>)((JFunc1)jdi -> {
            action.execute(jdi);
            return null;
        }));
    }

    public static void overrideAction(String className, String actionName, JAction1<Object> action) {
        ActionOverride.overrideFunction(className, actionName, (JFunc1<Object, Object>)((JFunc1)jdi -> {
            action.execute(jdi);
            return null;
        }));
    }

    public static JFunc1<Object, Object> getOverrideAction(JoinPoint jp) {
        if (OVERRIDE_ACTIONS_LIST.isEmpty()) {
            return null;
        }
        for (Pair override : OVERRIDE_ACTIONS_LIST) {
            if (!((Boolean)((JFunc1)override.key).execute((Object)jp)).booleanValue()) continue;
            return (JFunc1)override.value;
        }
        return null;
    }
}

