/*
 * Decompiled with CFR 0.152.
 */
package com.epam.jdi.light.ui.html;

import com.epam.jdi.light.common.Exceptions;
import org.openqa.selenium.WebElement;

public class HtmlUtils {
    public static int getInt(String attr, WebElement el) {
        return HtmlUtils.getInt(el.getAttribute(attr));
    }

    public static int getInt(String value) {
        try {
            return Integer.parseInt(value);
        }
        catch (Exception exception) {
            throw Exceptions.exception((String)"Can't parse value '%s' to Integer", (Object[])new Object[]{value});
        }
    }

    public static double getDouble(String attr, WebElement el) {
        return HtmlUtils.getDouble(el.getAttribute(attr));
    }

    public static double getDouble(String value) {
        try {
            return Double.parseDouble(value);
        }
        catch (Exception exception) {
            throw Exceptions.exception((String)"Can't parse value '%s' to Double", (Object[])new Object[]{value});
        }
    }

    public static double getDouble(String attr, WebElement el, double defaultValue) {
        String value = el.getAttribute(attr);
        try {
            return Double.parseDouble(value);
        }
        catch (Exception exception) {
            return defaultValue;
        }
    }

    public static float getFloat(String attr, WebElement el) {
        return HtmlUtils.getFloat(el.getAttribute(attr));
    }

    public static float getFloat(String value) {
        try {
            return Float.parseFloat(value);
        }
        catch (Exception exception) {
            throw Exceptions.exception((String)"Can't parse value '%s' to Double", (Object[])new Object[]{value});
        }
    }
}

