/*
 * Decompiled with CFR 0.152.
 */
package ua_parser;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ua_parser.Device;

public class DeviceParser {
    List<DevicePattern> patterns;

    public DeviceParser(List<DevicePattern> patterns) {
        this.patterns = patterns;
    }

    public Device parse(String agentString) {
        DevicePattern p;
        if (agentString == null) {
            return null;
        }
        String device = null;
        Iterator<DevicePattern> iterator = this.patterns.iterator();
        while (iterator.hasNext() && (device = (p = iterator.next()).match(agentString)) == null) {
        }
        if (device == null) {
            device = "Other";
        }
        return new Device(device);
    }

    public static DeviceParser fromList(List<Map<String, String>> configList) {
        ArrayList<DevicePattern> configPatterns = new ArrayList<DevicePattern>();
        for (Map<String, String> configMap : configList) {
            configPatterns.add(DeviceParser.patternFromMap(configMap));
        }
        return new DeviceParser(configPatterns);
    }

    protected static DevicePattern patternFromMap(Map<String, String> configMap) {
        String regex = configMap.get("regex");
        if (regex == null) {
            throw new IllegalArgumentException("Device is missing regex");
        }
        return new DevicePattern(Pattern.compile(regex), configMap.get("device_replacement"));
    }

    protected static class DevicePattern {
        private final Pattern pattern;
        private final String familyReplacement;

        public DevicePattern(Pattern pattern, String familyReplacement) {
            this.pattern = pattern;
            this.familyReplacement = familyReplacement;
        }

        public String match(String agentString) {
            Matcher matcher = this.pattern.matcher(agentString);
            if (!matcher.find()) {
                return null;
            }
            String family = null;
            if (this.familyReplacement != null) {
                family = this.familyReplacement.contains("$1") && matcher.groupCount() >= 1 && matcher.group(1) != null ? this.familyReplacement.replaceFirst("\\$1", Matcher.quoteReplacement(matcher.group(1))) : this.familyReplacement;
            } else if (matcher.groupCount() >= 1) {
                family = matcher.group(1);
            }
            return family;
        }
    }
}

