/*
 * Decompiled with CFR 0.152.
 */
package com.simontuffs.onejar;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.zip.ZipEntry;

public class OneJarFile
extends JarFile {
    protected final String jarFilename;
    protected final String filename;
    protected final JarEntry wrappedJarFile;

    public OneJarFile(String string, String string2, String string3) throws IOException {
        super(string);
        this.jarFilename = string2;
        this.filename = string3;
        this.wrappedJarFile = super.getJarEntry(this.jarFilename);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public JarEntry getJarEntry(String string) {
        String string2 = string.substring(string.indexOf("!/") + 2);
        if (string2.equals("META-INF/MANIFEST.MF")) {
            return new JarEntry(string2){};
        }
        try (JarInputStream jarInputStream = new JarInputStream(super.getInputStream(this.wrappedJarFile));){
            JarEntry jarEntry;
            do {
                if ((jarEntry = jarInputStream.getNextJarEntry()) == null) return null;
            } while (!jarEntry.getName().equals(string2));
            JarEntry jarEntry2 = jarEntry;
            return jarEntry2;
        }
        catch (IOException iOException) {
            throw new IllegalStateException("Undefined Error", iOException);
        }
    }

    public Enumeration entries() {
        try {
            final JarInputStream jarInputStream = new JarInputStream(super.getInputStream(this.wrappedJarFile));
            return new Enumeration(){
                protected JarEntry next;

                public Object nextElement() {
                    if (this.next != null) {
                        JarEntry jarEntry = this.next;
                        this.next = null;
                        return jarEntry;
                    }
                    try {
                        return jarInputStream.getNextJarEntry();
                    }
                    catch (IOException iOException) {
                        throw new RuntimeException("Undefined Error", iOException);
                    }
                }

                @Override
                public boolean hasMoreElements() {
                    if (this.next != null) {
                        return true;
                    }
                    try {
                        this.next = jarInputStream.getNextJarEntry();
                        if (this.next == null) {
                            jarInputStream.close();
                        }
                    }
                    catch (IOException iOException) {
                        throw new RuntimeException("Undefined Error", iOException);
                    }
                    return this.next != null;
                }
            };
        }
        catch (IOException iOException) {
            throw new RuntimeException("Undefined Error", iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public synchronized InputStream getInputStream(ZipEntry zipEntry) throws IOException {
        if (zipEntry == null) {
            return null;
        }
        try {
            JarInputStream jarInputStream = new JarInputStream(super.getInputStream(this.wrappedJarFile));
            if (this.filename.equals("META-INF/MANIFEST.MF")) {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                jarInputStream.getManifest().write(byteArrayOutputStream);
                return new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            }
            try {
                JarEntry jarEntry;
                do {
                    if ((jarEntry = jarInputStream.getNextJarEntry()) == null) throw new RuntimeException("Entry not found : " + zipEntry.getName());
                } while (!jarEntry.getName().equals(zipEntry.getName()));
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                this.copy(jarInputStream, byteArrayOutputStream);
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
                return byteArrayInputStream;
            }
            finally {
                jarInputStream.close();
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException("Undefined Error", iOException);
        }
    }

    protected void copy(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        byte[] byArray = new byte[1024];
        while ((n = inputStream.read(byArray)) >= 0) {
            outputStream.write(byArray, 0, n);
        }
    }
}

