/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.OS;

public final class Font
extends Resource {
    public long handle;

    Font(Device device) {
        super(device);
    }

    public Font(Device device, FontData fontData) {
        super(device);
        if (fontData == null) {
            SWT.error(4);
        }
        this.init(fontData.getName(), fontData.getHeightF(), fontData.getStyle(), fontData.string);
        this.init();
    }

    public Font(Device device, FontData[] fontDataArray) {
        super(device);
        if (fontDataArray == null) {
            SWT.error(4);
        }
        if (fontDataArray.length == 0) {
            SWT.error(5);
        }
        int n = 0;
        while (n < fontDataArray.length) {
            if (fontDataArray[n] == null) {
                SWT.error(5);
            }
            ++n;
        }
        FontData fontData = fontDataArray[0];
        this.init(fontData.getName(), fontData.getHeightF(), fontData.getStyle(), fontData.string);
        this.init();
    }

    public Font(Device device, String string, int n, int n2) {
        super(device);
        this.init(string, n, n2, null);
        this.init();
    }

    Font(Device device, String string, float f, int n) {
        super(device);
        this.init(string, f, n, null);
        this.init();
    }

    void destroy() {
        OS.pango_font_description_free(this.handle);
        this.handle = 0L;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Font)) {
            return false;
        }
        return this.handle == ((Font)object).handle;
    }

    public FontData[] getFontData() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        long l = OS.pango_font_description_get_family(this.handle);
        int n = OS.strlen(l);
        byte[] byArray = new byte[n];
        OS.memmove(byArray, l, (long)n);
        String string = new String(Converter.mbcsToWcs(null, byArray));
        float f = (float)OS.pango_font_description_get_size(this.handle) / 1024.0f;
        Point point = this.device.dpi;
        Point point2 = this.device.getScreenDPI();
        float f2 = f * (float)point2.y / (float)point.y;
        int n2 = OS.pango_font_description_get_style(this.handle);
        int n3 = OS.pango_font_description_get_weight(this.handle);
        int n4 = 0;
        if (n2 == 2) {
            n4 |= 2;
        }
        if (n2 == 1) {
            n4 |= 0x20;
        }
        if (n3 >= 700) {
            n4 |= 1;
        }
        long l2 = OS.pango_font_description_to_string(this.handle);
        n = OS.strlen(l2);
        byArray = new byte[n + 1];
        OS.memmove(byArray, l2, (long)n);
        OS.g_free(l2);
        FontData fontData = new FontData(string, f2, n4);
        fontData.string = byArray;
        return new FontData[]{fontData};
    }

    public static Font gtk_new(Device device, long l) {
        Font font = new Font(device);
        font.handle = l;
        return font;
    }

    public int hashCode() {
        return (int)this.handle;
    }

    void init(String string, float f, int n, byte[] byArray) {
        if (string == null) {
            SWT.error(4);
        }
        if (f < 0.0f) {
            SWT.error(5);
        }
        Point point = this.device.dpi;
        Point point2 = this.device.getScreenDPI();
        float f2 = f * (float)point.y / (float)point2.y;
        if (byArray != null) {
            this.handle = OS.pango_font_description_from_string(byArray);
            if (this.handle == 0L) {
                SWT.error(2);
            }
        } else {
            this.handle = OS.pango_font_description_new();
            if (this.handle == 0L) {
                SWT.error(2);
            }
            byte[] byArray2 = Converter.wcsToMbcs(null, string, true);
            OS.pango_font_description_set_family(this.handle, byArray2);
            if (f2 > 0.0f) {
                OS.pango_font_description_set_size(this.handle, (int)(0.5f + f2 * 1024.0f));
            }
            OS.pango_font_description_set_stretch(this.handle, 4);
            int n2 = 0;
            int n3 = 400;
            if ((n & 2) != 0) {
                n2 = 2;
            }
            if ((n & 0x20) != 0) {
                n2 = 1;
            }
            if ((n & 1) != 0) {
                n3 = 700;
            }
            OS.pango_font_description_set_style(this.handle, n2);
            OS.pango_font_description_set_weight(this.handle, n3);
        }
    }

    public boolean isDisposed() {
        return this.handle == 0L;
    }

    public String toString() {
        if (this.isDisposed()) {
            return "Font {*DISPOSED*}";
        }
        return "Font {" + this.handle + "}";
    }
}

