(ns coconut.alpha.main
  #?(:cljs (:require-macros [cljs.core.async.macros :as async]))
  (:require
    [clojure.core.async :as async :refer [<! >!]]
    [coconut.alpha.aggregation :as caa]
    #?(:cljs [coconut.alpha.browser-console :as browser-console])
    [coconut.alpha.cli :as cli]
    #?(:cljs [coconut.alpha.html :as html])
    #?(:cljs [coconut.alpha.karma :as cak])
    [coconut.alpha.platform :as capl]
    [coconut.alpha.query :as query]
    [coconut.alpha.running :as running]
    [coconut.alpha.summarizing :as summarizing]
    [coconut.alpha.reporting :as care]
    ))

(defn channel-consuming
  ([f]
   (fn [channel]
     (async/go
       (loop []
         (when-let [e (<! channel)]
           (f e)
           (recur)))))))

(defn reporters
  ([options]
   (if (= :karma
          (:output options))
     [caa/return]
     (into (vector)
           (map #(case %
                   :documentation care/documentation
                   :progress care/progress
                   :results care/results
                   (throw (capl/illegal-argument-exception
                            (capl/format "unsupported reporter: %s"
                                         (pr-str %))))))
           (:reporters options)))))

(defn output
  ([options]
   (if (= [:karma]
          (:reporters options))
     (channel-consuming (fn [_]))
     (case (:output options)
       #?@(:cljs [:browser-console (channel-consuming browser-console/output!)])
       :cli (channel-consuming cli/output!)
       #?@(:cljs [:html (channel-consuming html/output!)])
       #?@(:cljs [:karma (channel-consuming cak/output!)])
       (throw (capl/illegal-argument-exception
                (capl/format "unsupported output: %s"
                             (:output options))))))))

(defn run
  ([options]
   (let [summarize (caa/aggregation summarizing/summarize)
         report (-> (reporters options)
                    (caa/compose)
                    (caa/aggregation))
         output (output options)]
     (-> (:criteria options)
         (query/query)
         (running/run)
         (summarize)
         (report)
         (output)
         #?(:clj (async/<!!))))))

(defn explore
  []
  (group-by (comp :coconut.alpha.api/category meta)
            (vals (ns-publics 'coconut.alpha))))
