(ns coconut.alpha.karma
  (:require-macros [cljs.core.async.macros :as async])
  (:require
    [clojure.core.async :as async]
    [coconut.alpha.platform :as platform]
    [coconut.alpha.summarizing :as summarizing]
    ))

(defmulti output!
  (fn [event]
    (::summarizing/type event)))

(defmethod output!
  ::summarizing/suite-started
  ([event]
   (.info js/window.__karma__
          (clj->js {:total (::summarizing/total-number-of-tests event)}))))

(defmethod output!
  ::summarizing/test-pending
  ([event]
   (.result js/window.__karma__
            (clj->js {:description (::summarizing/description event)
                      :suite (::summarizing/context event)
                      :success true
                      :skipped true
                      :time (::summarizing/duration-in-milliseconds event)
                      :log [(str "PENDING -- " (::summarizing/pending-reason event))]}))))

(defmethod output!
  ::summarizing/test-passed
  ([event]
   (.result js/window.__karma__
            (clj->js {:description (::summarizing/description event)
                      :suite (::summarizing/context event)
                      :success true
                      :skipped false
                      :time (::summarizing/duration-in-milliseconds event)
                      :log []}))))

(defmethod output!
  ::summarizing/test-failed
  ([event]
   (.result js/window.__karma__
            (clj->js {:description (::summarizing/description event)
                      :suite (::summarizing/context event)
                      :success false
                      :skipped false
                      :time (::summarizing/duration-in-milliseconds event)
                      :log (let [expected (::summarizing/expected event)
                                 actual (::summarizing/actual event)]
                             (flatten [(str "namespace: " (::summarizing/namespace-name event))
                                       (str "     line: " (::summarizing/definition-line-number event))
                                       (str " expected: " (first expected))
                                       (for [line (rest expected)]
                                         (str "           " line))
                                       (str "   actual: " (first actual))
                                       (for [line (rest actual)]
                                         (str "           " line))]))}))))

(defmethod output!
  ::summarizing/test-timed-out
  ([event]
   (.result js/window.__karma__
            (clj->js {:description (::summarizing/description event)
                      :suite (::summarizing/context event)
                      :success false
                      :skipped false
                      :time (::summarizing/duration-in-milliseconds event)
                      :log ["TIMEOUT"]}))))

(defmethod output!
  ::summarizing/test-threw-exception
  ([event]
   (.result js/window.__karma__
            (clj->js {:description (::summarizing/description event)
                      :suite (::summarizing/context event)
                      :success false
                      :skipped false
                      :time (::summarizing/duration-in-milliseconds event)
                      :log [(apply str
                                   (interpose \newline
                                              (list* (platform/exception-class-name (::summarizing/exception event))
                                                     (platform/exception-message (::summarizing/exception event))
                                                     (platform/exception-stack-trace (::summarizing/exception event)))))]}))))

(defmethod output!
  ::summarizing/suite-finished
  ([event]
   (.complete js/window.__karma__
              (clj->js {:coverage js/window.__coverage__}))))

(defmethod output!
  :default
  ([_ _]))
