(defproject com.coconut-framework/coconut "0.3.1"
  :description "An asynchronous testing framework for Clojure and Clojurescript."
  :url "https://www.coconut-framework.com/"
  :license {:name "Eclipse Public License"
            :url "http://www.eclipse.org/legal/epl-v10.html"}
  :source-paths ["src"]
  :dependencies [[org.clojure/clojure "1.9.0-beta2"]
                 [org.clojure/core.async "0.3.443"]
                 [org.clojure/core.match "0.3.0-alpha5"]]
  :clean-targets ["target"
                  "dist/console/whitespace/js"
                  "dist/console/simple/js"
                  "dist/console/advanced/js"
                  "dist/html/whitespace/js"
                  "dist/html/simple/js"
                  "dist/html/advanced/js"
                  "dist/karma/whitespace/js"
                  "dist/karma/simple/js"
                  "dist/karma/advanced/js"]
  :aliases {"karma"                          [["shell" "karma"] "start"]
            "karma.whitespace"               ["karma" "dist/karma/whitespace/karma.config.js"]
            "karma.simple"                   ["karma" "dist/karma/simple/karma.config.js"]
            "karma.advanced"                 ["karma" "dist/karma/advanced/karma.config.js"]
            "karma.watch"                    [["shell" "karma"] "start" "--no-single-run"]
            "karma.watch.whitespace"         ["karma.watch" "dist/karma/whitespace/karma.config.js"]
            "karma.watch.simple"             ["karma.watch" "dist/karma/simple/karma.config.js"]
            "karma.watch.advanced"           ["karma.watch" "dist/karma/advanced/karma.config.js"]
            "build"                          ["cljsbuild" "once"]
            "build.html.whitespace"          ["build" "html.whitespace"]
            "build.html.simple"              ["build" "html.simple"]
            "build.html.advanced"            ["build" "html.advanced"]
            "build.console.whitespace"       ["build" "console.whitespace"]
            "build.console.simple"           ["build" "console.simple"]
            "build.console.advanced"         ["build" "console.advanced"]
            "build.karma.whitespace"         ["build" "karma.whitespace"]
            "build.karma.simple"             ["build" "karma.simple"]
            "build.karma.advanced"           ["build" "karma.advanced"]
            "build.watch"                    ["cljsbuild" "auto"]
            "build.watch.html.whitespace"    ["build.watch" "html.whitespace"]
            "build.watch.html.simple"        ["build.watch" "html.simple"]
            "build.watch.html.advanced"      ["build.watch" "html.advanced"]
            "build.watch.console.whitespace" ["build.watch" "console.whitespace"]
            "build.watch.console.simple"     ["build.watch" "console.simple"]
            "build.watch.console.advanced"   ["build.watch" "console.advanced"]
            "build.watch.karma.whitespace"   ["build.watch" "karma.whitespace"]
            "build.watch.karma.simple"       ["build.watch" "karma.simple"]
            "build.watch.karma.advanced"     ["build.watch" "karma.advanced"]}
  :cljsbuild {:builds [{:id "html.whitespace"
                        :source-paths ["test" "target/classes"]
                        :compiler {:output-to "dist/html/whitespace/js/coconut.tests.js"
                                   :output-dir "dist/html/whitespace/js/out"
                                   :optimizations :whitespace
                                   :source-map "dist/html/whitespace/js/coconut.tests.js.map"}}

                       {:id "html.simple"
                        :source-paths ["test" "target/classes"]
                        :compiler {:output-to "dist/html/simple/js/coconut.tests.js"
                                   :output-dir "dist/html/simple/js/out"
                                   :optimizations :simple
                                   :source-map "dist/html/simple/js/coconut.tests.js.map"}}

                       {:id "html.advanced"
                        :source-paths ["test" "target/classes"]
                        :compiler {:output-to "dist/html/advanced/js/coconut.tests.js"
                                   :output-dir "dist/html/advanced/js/out"
                                   :optimizations :advanced
                                   :source-map "dist/html/advanced/js/coconut.tests.js.map"}}

                       {:id "console.whitespace"
                        :source-paths ["test" "target/classes"]
                        :compiler {:output-to "dist/console/whitespace/js/coconut.tests.js"
                                   :output-dir "dist/console/whitespace/js/out"
                                   :optimizations :whitespace
                                   :source-map "dist/console/whitespace/js/coconut.tests.js.map"}}

                       {:id "console.simple"
                        :source-paths ["test" "target/classes"]
                        :compiler {:output-to "dist/console/simple/js/coconut.tests.js"
                                   :output-dir "dist/console/simple/js/out"
                                   :optimizations :simple
                                   :source-map "dist/console/simple/js/coconut.tests.js.map"}}

                       {:id "console.advanced"
                        :source-paths ["test" "target/classes"]
                        :compiler {:output-to "dist/console/advanced/js/coconut.tests.js"
                                   :output-dir "dist/console/advanced/js/out"
                                   :optimizations :advanced
                                   :source-map "dist/console/advanced/js/coconut.tests.js.map"}}

                       {:id "karma.whitespace"
                        :source-paths ["test" "target/classes"]
                        :compiler {:output-to "dist/karma/whitespace/js/coconut.tests.js"
                                   :output-dir "dist/karma/whitespace/js/out"
                                   :optimizations :whitespace
                                   :parallel-build true
                                   :source-map "dist/karma/whitespace/js/coconut.tests.js.map"}}

                       {:id "karma.simple"
                        :source-paths ["test" "target/classes"]
                        :compiler {:output-to "dist/karma/simple/js/coconut.tests.js"
                                   :output-dir "dist/karma/simple/js/out"
                                   :optimizations :simple
                                   :source-map "dist/karma/simple/js/coconut.tests.js.map"}}

                       {:id "karma.advanced"
                        :source-paths ["test" "target/classes"]
                        :compiler {:output-to "dist/karma/advanced/js/coconut.tests.js"
                                   :output-dir "dist/karma/advanced/js/out"
                                   :optimizations :advanced
                                   :source-map "dist/karma/advanced/js/coconut.tests.js.map"}}]}
  :profiles {:release {:aot :all}
             :dev {:dependencies [[org.clojure/clojurescript "1.9.946"]
                                  [org.clojure/tools.namespace "0.2.11"]
                                  [org.clojure/test.check "0.9.0"]]
                   :jvm-opts ["-Xss4m"]
                   :codox {:namespaces [coconut.alpha]}
                   :repl-options {:init-ns coconut.repl}
                   :source-paths ["test" "development"]
                   :java-source-paths ["test/coconut"]
                   :plugins [[lein-cljsbuild "1.1.7"]
                             [lein-shell "0.5.0"]
                             [lein-pdo "0.1.1"]
                             [lein-codox "0.10.3"]]}})
