(ns coconut.alpha.specs
  (:require
    [clojure.spec.alpha :as s]
    ))

(s/def :coconut.alpha.run.options/reporter
  #{:progress :documentation :results})

(s/def :coconut.alpha.run.options/reporters
  (s/+ :coconut.alpha.run.options/reporter))

(s/def :coconut.alpha.run.options/output
  #{:cli
    #?(:cljs :html)
    #?(:cljs :browser-console)})

(s/def :coconut.alpha.run.options.criterion/namespace-representation
  (s/alt :string string?
         :symbol symbol?
         #?@(:clj [:namespace #(instance? clojure.lang.Namespace %)])))

(s/def :coconut.alpha.run.options.criterion/all
  (s/cat :type #{:all}))

(s/def :coconut.alpha.run.options.criterion/within-namespace
  (s/cat :type #{:within-namespace}
         :namespace-representation :coconut.alpha.run.options.criterion/namespace-representation))

(s/def :coconut.alpha.run.options.criterion/within-namespaces
  (s/cat :type #{:within-namespaces}
         :namespace-representations (s/+ :coconut.alpha.run.options.criterion/namespace-representation)))

(s/def :coconut.alpha.run.options.criterion/not
  (s/cat :type #{:not}
         :criteria :coconut.alpha.run.options/criteria))

(s/def :coconut.alpha.run.options.criterion/or
  (s/cat :type #{:or}
         :criteria (s/+ :coconut.alpha.run.options/criteria)))

(s/def :coconut.alpha.run.options.criterion/and
  (s/cat :type #{:and}
         :criteria (s/+ :coconut.alpha.run.options/criteria)))

(s/def :coconut.alpha.run.options.criterion/defined-on-line
  (s/cat :type #{:defined-on-line}
         :line-number pos-int?))

(s/def :coconut.alpha.run.options.criterion/description-matches
  (s/cat :type #{:description-matches}
         :regex #(instance? java.util.regex.Pattern %)))

(s/def :coconut.alpha.run.options.criterion/namespace-matches
  (s/cat :type #{:namespace-matches}
         :regex #(instance? java.util.regex.Pattern %)))

(s/def :coconut.alpha.run.options.criterion/has-tag
  (s/cat :type #{:has-tag}
         :tags (s/+ any?)))

(s/def :coconut.alpha.run.options/criteria
  (s/or :all :coconut.alpha.run.options.criterion/all
        :within-namespace :coconut.alpha.run.options.criterion/within-namespace
        :within-namespaces :coconut.alpha.run.options.criterion/within-namespaces
        :not :coconut.alpha.run.options.criterion/not
        :or :coconut.alpha.run.options.criterion/or
        :and :coconut.alpha.run.options.criterion/and
        :defined-on-line :coconut.alpha.run.options.criterion/defined-on-line
        :description-matches :coconut.alpha.run.options.criterion/description-matches
        :namespace-matches :coconut.alpha.run.options.criterion/namespace-matches
        :has-tag :coconut.alpha.run.options.criterion/has-tag))

(s/def :coconut.alpha.run/options
  (s/keys :req-un
          [:coconut.alpha.run.options/reporters
           :coconut.alpha.run.options/output
           :coconut.alpha.run.options/criteria]))

(s/fdef coconut.alpha/run
  :args (s/cat :options :coconut.alpha.run/options))
