(ns coconut.alpha.aggregation
  #?(:cljs (:require-macros [cljs.core.async.macros :as cca]))
  (:require
    [clojure.core.async :as cca :refer [<! >!]]
    ))

(defn return
  ([state event]
   #::{:events [event]
       :state state}))

(defn aggregation
  ([f]
   (fn aggregate
     ([c]
      (aggregate c (cca/chan)))
     ([c ret]
      (cca/go
        (loop [state nil]
          (when-let [e (<! c)]
            (let [fret (f state e)]
              (doseq [out (::events fret)]
                (>! ret out))
              (recur (::state fret)))))
        (cca/close! ret))
      ret))))

(defn compose
  ([fs]
   (reduce (fn [f g]
             (fn [state event]
               (let [f-ret (f (::f state) event)
                     g-ret (g (::g state) event)]
                 #::{:events (into (::events f-ret)
                                   (::events g-ret))
                     :state #::{:f (::state f-ret)
                                :g (::state g-ret)}})))
           fs)))
