(ns coconut.alpha.cli
  (:require
    [clojure.core.match :as ccm]
    [coconut.alpha.platform :as cap]
    [coconut.alpha.rendering :as car]
    ))

(defn ansi
  ([color-code]
   (fn [& strings]
     (apply str
            (into (vector)
                  (map (partial cap/format
                                "\u001b[%sm%s\u001b[0m"
                                color-code))
                  strings)))))

(def bold   (ansi 1))
(def grey   (ansi 30))
(def red    (ansi 31))
(def green  (ansi 32))
(def yellow (ansi 33))
(def blue   (ansi 34))
(def teal   (ansi 36))

(defn render-colorized-output
  ([data]
   (let [f (case (::car/color data)
             ::car/grey grey
             ::car/red red
             ::car/green green
             ::car/yellow yellow
             ::car/teal teal
             nil str
             (throw (cap/illegal-argument-exception
                      (str "unsupported color: "
                           (::car/color data)))))]
     (bold (f (::car/text data))))))

(defn output!
  ([data]
   (ccm/match [(::car/type data)]
     [::car/newline]
     (println)

     [::car/line]
     (println (transduce (map render-colorized-output)
                         str
                         (::car/segments data)))

     [::car/segment]
     (do (print (transduce (map render-colorized-output)
                           str
                           (::car/segments data)))
         (flush)))))
