(ns coconut.alpha.browser-console
  (:require
    [clojure.core.match :as ccm]
    [coconut.alpha.rendering :as car]
    ))

(defn color->css
  ([data]
   (case (::car/color data)
     ::car/red "color: red;"
     ::car/green "color: green;"
     ::car/yellow "color: yellow;"
     ::car/teal "color: teal;"
     "color: none;")))

(defn output!
  ([data]
   (ccm/match [(::car/type data)]
     [::car/newline]
     (js/console.log "")

     [(:or ::car/line
           ::car/segment)]
     (let [output (transduce (comp (map ::car/text)
                                   (map (partial str "%c")))
                             str
                             (::car/segments data))
           color-strings (into (vector)
                               (map color->css)
                               (::car/segments data))]
       (apply js/console.log
              output
              color-strings)))))
