# Coconut

```clojure
(ns example.core-test
  (:require-macros [cljs.core.async.macros :as async])
  (:require
    [cljs.core.async :as async]
    [coconut.alpha.core :as c]
    [example.core :as core]
    ))

(c/describe "example.core/sum"
  (c/it "returns the sum of two numbers"
    (fn [assert-that]
      (assert-that (core/sum 42 42) (c/is 84)))))

(c/describe "example.core/sum-async"
  (c/it "returns the sum of two numbers"
    :asynchronous {:timeout 50}
    (fn [assert-that done]
      (async/go (let [c (core/sum-async 42 42)]
                  (assert-that (async/<! c) (c/is 84))
                  (done))))))
```
