/*
 * Decompiled with CFR 0.152.
 */
package ham_fisted;

import clojure.lang.IDeref;
import clojure.lang.IFn;
import clojure.lang.IPersistentMap;
import clojure.lang.IReduceInit;
import clojure.lang.RT;
import ham_fisted.HashMap;
import ham_fisted.HashNode;
import ham_fisted.LinkedHashNode;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.BiFunction;
import java.util.function.Function;

public class LinkedHashMap
extends HashMap {
    LinkedHashNode firstLink;
    LinkedHashNode lastLink;

    public LinkedHashMap(IPersistentMap iPersistentMap) {
        super(iPersistentMap);
    }

    public LinkedHashMap() {
        this(null);
    }

    public LinkedHashMap(float f, int n, int n2, HashNode[] hashNodeArray, IPersistentMap iPersistentMap) {
        super(f, n, n2, hashNodeArray, iPersistentMap);
    }

    @Override
    public LinkedHashMap clone() {
        LinkedHashMap linkedHashMap = new LinkedHashMap(this.loadFactor, this.capacity, 0, new HashNode[this.data.length], this.meta);
        HashNode[] hashNodeArray = this.data;
        int n = this.mask;
        HashNode[] hashNodeArray2 = linkedHashMap.data;
        LinkedHashNode linkedHashNode = this.lastLink;
        while (linkedHashNode != null) {
            HashNode hashNode;
            int n2 = linkedHashNode.hashcode & n;
            HashNode hashNode2 = hashNodeArray2[n2];
            hashNodeArray2[n2] = hashNode = linkedHashMap.newNode(linkedHashNode.k, linkedHashNode.hashcode, linkedHashNode.v);
            hashNode.nextNode = hashNode2;
            linkedHashNode = linkedHashNode.nextLink;
        }
        return linkedHashMap;
    }

    @Override
    protected HashNode newNode(Object object, int n, Object object2) {
        return new LinkedHashNode(this, object, n, object2, null);
    }

    @Override
    protected void inc(HashNode hashNode) {
        super.inc(hashNode);
        LinkedHashNode linkedHashNode = (LinkedHashNode)hashNode;
        if (this.lastLink == null) {
            this.lastLink = linkedHashNode;
        }
        linkedHashNode.prevLink = this.firstLink;
        if (this.firstLink != null) {
            this.firstLink.nextLink = linkedHashNode;
        }
        this.firstLink = linkedHashNode;
    }

    protected static void removeLink(LinkedHashNode linkedHashNode) {
        if (linkedHashNode.prevLink != null) {
            linkedHashNode.prevLink.nextLink = linkedHashNode.nextLink;
        }
        if (linkedHashNode.nextLink != null) {
            linkedHashNode.nextLink.prevLink = linkedHashNode.prevLink;
        }
    }

    @Override
    protected void dec(HashNode hashNode) {
        super.dec(hashNode);
        LinkedHashNode linkedHashNode = (LinkedHashNode)hashNode;
        if (linkedHashNode == this.firstLink) {
            this.firstLink = linkedHashNode.prevLink;
        }
        if (linkedHashNode == this.lastLink) {
            this.lastLink = linkedHashNode.nextLink;
        }
        LinkedHashMap.removeLink(linkedHashNode);
        linkedHashNode.prevLink = null;
        linkedHashNode.nextLink = null;
    }

    @Override
    protected void modify(HashNode hashNode) {
    }

    @Override
    public Iterator iterator(Function<Map.Entry, Object> function) {
        return new LinkedIter(function, this.lastLink);
    }

    @Override
    public Object reduce(IFn iFn, Object object) {
        LinkedHashNode linkedHashNode = this.lastLink;
        while (linkedHashNode != null) {
            if (RT.isReduced((Object)(object = iFn.invoke(object, (Object)linkedHashNode)))) {
                return ((IDeref)object).deref();
            }
            linkedHashNode = linkedHashNode.nextLink;
        }
        return object;
    }

    @Override
    public Object kvreduce(IFn iFn, Object object) {
        LinkedHashNode linkedHashNode = this.lastLink;
        while (linkedHashNode != null) {
            if (RT.isReduced((Object)(object = iFn.invoke(object, linkedHashNode.k, linkedHashNode.v)))) {
                return ((IDeref)object).deref();
            }
            linkedHashNode = linkedHashNode.nextLink;
        }
        return object;
    }

    @Override
    public HashMap union(Map map, BiFunction biFunction) {
        if (map instanceof LinkedHashMap) {
            return LinkedHashMap.reduceUnion(this, (IReduceInit)map, biFunction);
        }
        return super.union(map, biFunction);
    }

    public static class LinkedIter
    implements Iterator {
        LinkedHashNode current;
        Function<Map.Entry, Object> fn;

        public LinkedIter(Function<Map.Entry, Object> function, LinkedHashNode linkedHashNode) {
            this.current = linkedHashNode;
            this.fn = function;
        }

        @Override
        public boolean hasNext() {
            return this.current != null;
        }

        public Object next() {
            if (this.current == null) {
                throw new NoSuchElementException();
            }
            Object object = this.fn.apply(this.current);
            this.current = this.current.nextLink;
            return object;
        }
    }
}

