/*
 * Decompiled with CFR 0.152.
 */
package ham_fisted;

import clojure.lang.Counted;
import clojure.lang.ISeq;
import clojure.lang.Seqable;
import ham_fisted.ArrayLists;
import ham_fisted.IFnDef;
import ham_fisted.ITypedReduce;
import ham_fisted.LazyChunkedSeq;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.function.Consumer;

public interface ISet
extends Set,
ITypedReduce,
IFnDef,
Counted,
Seqable {
    default public int count() {
        return this.size();
    }

    @Override
    default public boolean addAll(Collection collection) {
        int n = this.size();
        for (Object e : collection) {
            this.add(e);
        }
        return n == this.size();
    }

    @Override
    default public void forEach(Consumer consumer) {
        ITypedReduce.super.forEach(consumer);
    }

    @Override
    default public boolean retainAll(Collection collection) {
        int n = this.size();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            if (collection.contains(iterator.next())) continue;
            iterator.remove();
        }
        return n == this.size();
    }

    @Override
    default public boolean containsAll(Collection collection) {
        for (Object e : collection) {
            if (this.contains(collection)) continue;
            return false;
        }
        return true;
    }

    @Override
    default public boolean removeAll(Collection collection) {
        int n = this.size();
        for (Object e : collection) {
            this.remove(e);
        }
        return n == this.size();
    }

    default public ISeq seq() {
        return LazyChunkedSeq.chunkIteratorSeq(this.iterator());
    }

    @Override
    default public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    default public Object[] toArray() {
        return ArrayLists.toArray(this);
    }

    @Override
    default public Object[] toArray(Object[] objectArray) {
        return ArrayLists.toArray(this, objectArray);
    }

    @Override
    default public Object invoke(Object object) {
        return this.contains(object) ? object : null;
    }
}

