/*
 * Decompiled with CFR 0.152.
 */
package ham_fisted;

import clojure.lang.ITransientVector;
import clojure.lang.RT;
import clojure.lang.Util;
import ham_fisted.ChunkedList;
import ham_fisted.IFnDef;
import ham_fisted.ImmutList;
import ham_fisted.IntegerOps;
import java.util.Arrays;
import java.util.BitSet;

public class TransientList
implements ITransientVector,
IFnDef {
    final ChunkedList data;
    final BitSet ownedChunks;
    int nElems;

    public TransientList(ChunkedList chunkedList, int n, boolean bl) {
        this.data = chunkedList;
        this.nElems = n;
        this.ownedChunks = new BitSet();
        if (bl) {
            int n2 = ChunkedList.numChunks(this.nElems);
            for (int i = 0; i < n2; ++i) {
                this.ownedChunks.set(i);
            }
        }
    }

    final int indexCheck(int n) {
        return ChunkedList.indexCheck(0, this.nElems, n);
    }

    final int wrapIndexCheck(int n) {
        return ChunkedList.wrapIndexCheck(0, this.nElems, n);
    }

    public final int count() {
        return this.nElems;
    }

    public final int size() {
        return this.nElems;
    }

    public final int length() {
        return this.nElems;
    }

    public final Object nth(int n) {
        return this.nth(n, null);
    }

    public final Object nth(int n, Object object) {
        if (n < 0) {
            n += this.nElems;
        }
        if (n >= 0 && n < this.nElems) {
            return this.data.getValue(n);
        }
        return object;
    }

    @Override
    public final Object invoke(Object object) {
        return this.nth(RT.intCast((Object)object));
    }

    @Override
    public final Object invoke(Object object, Object object2) {
        return this.nth(RT.intCast((Object)object), object2);
    }

    public final Object valAt(Object object) {
        if (Util.isInteger((Object)object)) {
            return this.nth(RT.intCast((Object)object));
        }
        return null;
    }

    public final Object valAt(Object object, Object object2) {
        if (Util.isInteger((Object)object)) {
            return this.nth(RT.intCast((Object)object), object2);
        }
        return object2;
    }

    public final TransientList assocN(int n, Object object) {
        if (n == this.nElems) {
            return this.conj(object);
        }
        this.indexCheck(n);
        int n2 = n / 32;
        int n3 = n % 32;
        Object[][] objectArray = this.data.data;
        Object[] objectArray2 = objectArray[n2];
        if (!this.ownedChunks.get(n2)) {
            this.ownedChunks.set(n2);
            objectArray2 = (Object[])objectArray2.clone();
            objectArray[n2] = objectArray2;
        }
        objectArray2[n3] = object;
        return this;
    }

    public final TransientList assoc(Object object, Object object2) {
        if (!Util.isInteger((Object)object)) {
            throw new RuntimeException("Vectors must have integer indexes: " + String.valueOf(object));
        }
        return this.assocN(RT.intCast((Object)object), object2);
    }

    public final TransientList conj(Object object) {
        Object[] objectArray;
        int n = this.nElems++;
        int n2 = n / 32;
        int n3 = n % 32;
        Object[][] objectArray2 = this.data.data;
        if (n2 == objectArray2.length) {
            objectArray2 = (Object[][])Arrays.copyOf(objectArray2, n2 + 1);
            objectArray = new Object[4];
            objectArray2[n2] = objectArray;
            this.ownedChunks.set(n2);
        } else {
            objectArray = objectArray2[n2];
            if (!this.ownedChunks.get(n2) || objectArray.length <= n3) {
                objectArray = Arrays.copyOf(objectArray, IntegerOps.nextPow2(n3 + 1));
                objectArray2[n2] = objectArray;
                this.ownedChunks.set(n2);
            }
        }
        objectArray[n3] = object;
        return this;
    }

    public final TransientList pop() {
        if (this.nElems == 0) {
            throw new RuntimeException("Attempt to pop empty vector");
        }
        int n = --this.nElems;
        int n2 = n / 32;
        int n3 = n % 32;
        Object[][] objectArray = this.data.data;
        Object[] objectArray2 = objectArray[n2];
        if (!this.ownedChunks.get(n2)) {
            objectArray2 = (Object[])objectArray2.clone();
            this.ownedChunks.set(n2);
            objectArray[n2] = objectArray2;
        }
        objectArray2[n3] = null;
        return this;
    }

    public final ImmutList persistent() {
        return new ImmutList(0, this.nElems, this.data);
    }
}

