/*
 * Decompiled with CFR 0.152.
 */
package ham_fisted;

import clojure.lang.IDeref;
import clojure.lang.IFn;
import clojure.lang.IMeta;
import clojure.lang.IPersistentMap;
import clojure.lang.RT;
import ham_fisted.Casts;
import ham_fisted.ITypedReduce;
import ham_fisted.IntegerOps;
import ham_fisted.LongHashNode;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.Function;

public class LongHashBase
implements IMeta {
    int capacity;
    int mask;
    int length;
    int threshold;
    float loadFactor;
    LongHashNode[] data;
    IPersistentMap meta;

    public LongHashBase(float f, int n, int n2, LongHashNode[] longHashNodeArray, IPersistentMap iPersistentMap) {
        this.loadFactor = f;
        this.capacity = IntegerOps.nextPow2(Math.max(4, n));
        this.mask = this.capacity - 1;
        this.length = n2;
        this.data = longHashNodeArray == null ? new LongHashNode[this.capacity] : longHashNodeArray;
        this.threshold = (int)((float)this.capacity * f);
        this.meta = iPersistentMap;
    }

    public LongHashBase(LongHashBase longHashBase, IPersistentMap iPersistentMap) {
        this.loadFactor = longHashBase.loadFactor;
        this.capacity = longHashBase.capacity;
        this.mask = longHashBase.mask;
        this.length = longHashBase.length;
        this.data = longHashBase.data;
        this.threshold = longHashBase.threshold;
        this.meta = iPersistentMap;
    }

    public int size() {
        return this.length;
    }

    public int count() {
        return this.length;
    }

    static int hash(long l) {
        return IntegerOps.mixhash(Long.hashCode(l));
    }

    static boolean equals(long l, long l2) {
        return l == l2;
    }

    protected void inc(LongHashNode longHashNode) {
        ++this.length;
    }

    protected void dec(LongHashNode longHashNode) {
        --this.length;
    }

    protected void modify(LongHashNode longHashNode) {
    }

    protected LongHashNode newNode(long l, int n, Object object) {
        return new LongHashNode(this, l, n, object, null);
    }

    Object checkResize(Object object) {
        if (this.length >= this.threshold) {
            int n = this.capacity * 2;
            LongHashNode[] longHashNodeArray = new LongHashNode[n];
            LongHashNode[] longHashNodeArray2 = this.data;
            int n2 = longHashNodeArray2.length;
            int n3 = n - 1;
            for (int i = 0; i < n2; ++i) {
                LongHashNode longHashNode = longHashNodeArray2[i];
                if (longHashNode == null) continue;
                longHashNodeArray2[i] = null;
                if (longHashNode.nextNode == null) {
                    longHashNodeArray[longHashNode.hashcode & n3] = longHashNode;
                    continue;
                }
                LongHashNode longHashNode2 = null;
                LongHashNode longHashNode3 = null;
                LongHashNode longHashNode4 = null;
                LongHashNode longHashNode5 = null;
                while (longHashNode != null) {
                    LongHashNode longHashNode6 = longHashNode.setOwner(this);
                    longHashNode = longHashNode.nextNode;
                    if ((longHashNode6.hashcode & n2) == 0) {
                        if (longHashNode3 == null) {
                            longHashNode2 = longHashNode6;
                        } else {
                            longHashNode3.nextNode = longHashNode6;
                        }
                        longHashNode3 = longHashNode6;
                        continue;
                    }
                    if (longHashNode5 == null) {
                        longHashNode4 = longHashNode6;
                    } else {
                        longHashNode5.nextNode = longHashNode6;
                    }
                    longHashNode5 = longHashNode6;
                }
                if (longHashNode2 != null) {
                    longHashNode3.nextNode = null;
                    longHashNodeArray[i] = longHashNode2;
                }
                if (longHashNode4 == null) continue;
                longHashNode5.nextNode = null;
                longHashNodeArray[i + n2] = longHashNode4;
            }
            this.capacity = n;
            this.threshold = (int)((float)n * this.loadFactor);
            this.mask = n3;
            this.data = longHashNodeArray;
        }
        return object;
    }

    public void clear() {
        for (int i = 0; i < this.data.length; ++i) {
            LongHashNode longHashNode = this.data[i];
            while (longHashNode != null) {
                this.dec(longHashNode);
                longHashNode = longHashNode.nextNode;
            }
        }
        this.length = 0;
        Arrays.fill(this.data, null);
    }

    public IPersistentMap meta() {
        return this.meta;
    }

    final boolean containsNodeKey(Object object) {
        long l = Casts.longCast(object);
        LongHashNode longHashNode = this.data[LongHashBase.hash(l) & this.mask];
        while (longHashNode != null) {
            if (longHashNode.k == l) {
                return true;
            }
            longHashNode = longHashNode.nextNode;
        }
        return false;
    }

    static class HTSpliterator
    implements Spliterator,
    ITypedReduce {
        final LongHashNode[] d;
        final Function<Map.Entry, Object> fn;
        int sidx;
        int eidx;
        int estimateSize;
        LongHashNode l;

        public HTSpliterator(LongHashNode[] longHashNodeArray, int n, Function<Map.Entry, Object> function) {
            this.d = longHashNodeArray;
            this.fn = function;
            this.sidx = 0;
            this.eidx = longHashNodeArray.length;
            this.estimateSize = n;
            this.l = null;
        }

        public HTSpliterator(LongHashNode[] longHashNodeArray, int n, int n2, int n3, Function<Map.Entry, Object> function) {
            this.d = longHashNodeArray;
            this.fn = function;
            this.sidx = n;
            this.eidx = n2;
            this.estimateSize = n3;
            this.l = null;
        }

        public HTSpliterator trySplit() {
            int n = this.eidx - this.sidx;
            if (n > 4) {
                int n2 = n / 2;
                int n3 = this.eidx;
                this.eidx = this.sidx + n2;
                this.estimateSize /= 2;
                return new HTSpliterator(this.d, this.eidx, n3, this.estimateSize, this.fn);
            }
            return null;
        }

        @Override
        public int characteristics() {
            return 1089;
        }

        @Override
        public long estimateSize() {
            return this.estimateSize;
        }

        @Override
        public long getExactSizeIfKnown() {
            return this.estimateSize();
        }

        public boolean tryAdvance(Consumer consumer) {
            if (this.l != null) {
                consumer.accept(this.fn.apply(this.l));
                this.l = this.l.nextNode;
                return true;
            }
            while (this.sidx < this.eidx) {
                LongHashNode longHashNode = this.d[this.sidx];
                if (longHashNode != null) {
                    consumer.accept(this.fn.apply(longHashNode));
                    this.l = longHashNode.nextNode;
                    return true;
                }
                ++this.sidx;
            }
            return false;
        }

        public Object reduce(IFn iFn, Object object) {
            LongHashNode[] longHashNodeArray = this.d;
            int n = this.eidx;
            Function<Map.Entry, Object> function = this.fn;
            for (int i = this.sidx; i < n; ++i) {
                LongHashNode longHashNode = longHashNodeArray[i];
                while (longHashNode != null) {
                    if (RT.isReduced((Object)(object = iFn.invoke(object, function.apply(longHashNode))))) {
                        return ((IDeref)object).deref();
                    }
                    longHashNode = longHashNode.nextNode;
                }
            }
            return object;
        }
    }

    static class HTIter
    implements Iterator {
        final LongHashNode[] d;
        final Function<Map.Entry, Object> fn;
        LongHashNode l;
        int idx;
        final int dlen;

        HTIter(LongHashNode[] longHashNodeArray, Function<Map.Entry, Object> function) {
            this.d = longHashNodeArray;
            this.fn = function;
            this.l = null;
            this.idx = 0;
            this.dlen = this.d.length;
            this.advance();
        }

        void advance() {
            if (this.l != null) {
                this.l = this.l.nextNode;
            }
            if (this.l == null) {
                while (this.idx < this.dlen && this.l == null) {
                    this.l = this.d[this.idx];
                    ++this.idx;
                }
            }
        }

        @Override
        public boolean hasNext() {
            return this.l != null;
        }

        public Object next() {
            LongHashNode longHashNode = this.l;
            this.advance();
            return this.fn.apply(longHashNode);
        }
    }
}

