/*
 * Decompiled with CFR 0.152.
 */
package ham_fisted;

import clojure.lang.IHashEq;
import clojure.lang.Util;
import ham_fisted.CljHash;
import ham_fisted.HashProvider;
import ham_fisted.IntegerOps;

public class HashProviders {
    public static final HashProvider equalHashProvider = new HashProvider(){};
    public static final HashProvider equivHashProvider = new HashProvider(){

        @Override
        public int hash(Object object) {
            return Util.hasheq((Object)object);
        }

        @Override
        public boolean equals(Object object, Object object2) {
            return CljHash.equiv(object, object2);
        }
    };
    public static final HashProvider hybridHashProvider;
    public static final HashProvider defaultHashProvider;

    static {
        defaultHashProvider = hybridHashProvider = new HashProvider(){

            @Override
            public int hash(Object object) {
                return object == null ? 0 : (object instanceof IHashEq ? ((IHashEq)object).hasheq() : IntegerOps.mixhash(object.hashCode()));
            }

            @Override
            public boolean equals(Object object, Object object2) {
                return object == object2 ? true : (object == null || object2 == null ? false : CljHash.nonNullEquiv(object, object2));
            }
        };
    }
}

