/*
 * Decompiled with CFR 0.152.
 */
package ham_fisted;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.PriorityQueue;
import java.util.function.Predicate;

public class MergeIterator
implements Iterator {
    Comparator cmp;
    CurrentIterator[] iters;
    int curIdx;
    Predicate p;
    public static final Iterator emptyIter = new Iterator(){

        @Override
        public boolean hasNext() {
            return false;
        }

        public Object next() {
            throw new NoSuchElementException();
        }
    };
    public static final Predicate alwaysTrue = new Predicate(){

        public boolean test(Object object) {
            return true;
        }
    };

    int leastIndex() {
        int n = this.iters.length;
        if (n <= 1) {
            return 0;
        }
        Object object = this.iters[0].current();
        int n2 = 0;
        for (int i = 1; i < n; ++i) {
            Object object2 = this.iters[i].current();
            if (this.cmp.compare(object, object2) <= -1) continue;
            object = object2;
            n2 = i;
        }
        return n2;
    }

    public MergeIterator(CurrentIterator[] currentIteratorArray, Comparator comparator, Predicate predicate) {
        this.iters = currentIteratorArray;
        this.p = predicate;
        this.cmp = comparator;
        this.curIdx = this.leastIndex();
    }

    @Override
    public boolean hasNext() {
        return this.iters.length != 0;
    }

    public Object next() {
        Object object = null;
        do {
            if (this.iters.length == 0) {
                return null;
            }
            CurrentIterator currentIterator = this.iters[this.curIdx];
            object = currentIterator.current();
            if (currentIterator.hasNext()) {
                currentIterator.next();
            } else {
                int n = this.iters.length;
                CurrentIterator[] currentIteratorArray = new CurrentIterator[n - 1];
                for (int i = 0; i < n; ++i) {
                    if (i < this.curIdx) {
                        currentIteratorArray[i] = this.iters[i];
                        continue;
                    }
                    if (i <= this.curIdx) continue;
                    currentIteratorArray[i - 1] = this.iters[i];
                }
                this.iters = currentIteratorArray;
            }
            this.curIdx = this.leastIndex();
        } while (!this.p.test(object));
        return object;
    }

    public static final Iterator createMergeIterator(Iterable<Iterator> iterable, Comparator comparator, Predicate predicate) {
        ArrayList<Iterator> arrayList = new ArrayList<Iterator>();
        for (Iterator iterator : iterable) {
            if (iterator == null || !iterator.hasNext()) continue;
            arrayList.add(iterator);
        }
        if (arrayList.isEmpty()) {
            return emptyIter;
        }
        if (arrayList.size() >= 8) {
            return PriorityQueueIterator.create(arrayList, comparator, predicate);
        }
        CurrentIterator[] currentIteratorArray = new CurrentIterator[arrayList.size()];
        for (int i = 0; i < currentIteratorArray.length; ++i) {
            Iterator iterator = arrayList.get(i);
            currentIteratorArray[i] = new CurrentIterator(iterator, iterator.next());
        }
        if (arrayList.size() == 2) {
            return new TwoWayMergeIterator(currentIteratorArray[0], currentIteratorArray[1], comparator, predicate);
        }
        return new MergeIterator(currentIteratorArray, comparator, predicate);
    }

    public static Iterator createMergeIterator(Iterable<Iterator> iterable, Comparator comparator) {
        return MergeIterator.createMergeIterator(iterable, comparator, alwaysTrue);
    }

    public static class CurrentIterator
    implements Iterator {
        public static final Object invalid = new Object();
        Object current;
        Iterator iter;

        public CurrentIterator(Iterator iterator) {
            this.iter = iterator;
            this.current = invalid;
        }

        public CurrentIterator(Iterator iterator, Object object) {
            this.iter = iterator;
            this.current = object;
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        public Object next() {
            this.current = this.iter.next();
            return this.current;
        }

        public Object current() {
            return this.current;
        }

        public boolean hasCurrent() {
            return this.current != invalid;
        }

        public static CurrentIterator create(Iterator iterator) {
            if (iterator.hasNext()) {
                return new CurrentIterator(iterator, iterator.next());
            }
            return null;
        }
    }

    public static class PriorityQueueIterator
    implements Iterator {
        PriorityQueue pq;
        Predicate p;

        public PriorityQueueIterator(PriorityQueue priorityQueue, Predicate predicate) {
            this.pq = priorityQueue;
            this.p = predicate;
        }

        @Override
        public boolean hasNext() {
            return !this.pq.isEmpty();
        }

        public Object next() {
            Object object;
            if (this.pq.isEmpty()) {
                throw new NoSuchElementException();
            }
            do {
                if (this.pq.isEmpty()) {
                    return null;
                }
                Object[] objectArray = (Object[])this.pq.poll();
                Iterator iterator = (Iterator)objectArray[0];
                object = objectArray[1];
                if (!iterator.hasNext()) continue;
                objectArray[1] = iterator.next();
                this.pq.offer(objectArray);
            } while (!this.p.test(object));
            return object;
        }

        public static Iterator create(Iterable<Iterator> iterable, final Comparator comparator, Predicate predicate) {
            Comparator comparator2 = new Comparator(){

                public int compare(Object object, Object object2) {
                    return comparator.compare(((Object[])object)[1], ((Object[])object2)[1]);
                }
            };
            PriorityQueue<Object[]> priorityQueue = new PriorityQueue<Object[]>(comparator2);
            for (Iterator iterator : iterable) {
                if (iterator == null || !iterator.hasNext()) continue;
                priorityQueue.offer(new Object[]{iterator, iterator.next()});
            }
            return new PriorityQueueIterator(priorityQueue, predicate);
        }

        public static Iterator create(Iterable<Iterator> iterable, Comparator comparator) {
            return PriorityQueueIterator.create(iterable, comparator, alwaysTrue);
        }
    }

    public static class TwoWayMergeIterator
    implements Iterator {
        CurrentIterator lhs;
        CurrentIterator rhs;
        Comparator cmp;
        Predicate p;
        boolean left;

        public TwoWayMergeIterator(CurrentIterator currentIterator, CurrentIterator currentIterator2, Comparator comparator, Predicate predicate) {
            this.lhs = currentIterator;
            this.rhs = currentIterator2;
            this.cmp = comparator;
            this.p = predicate;
            this.left = comparator.compare(currentIterator.current(), currentIterator2.current()) < 0;
        }

        @Override
        public boolean hasNext() {
            return this.lhs != null || this.rhs != null;
        }

        public Object next() {
            Object object;
            if (this.lhs == null && this.rhs == null) {
                throw new NoSuchElementException();
            }
            do {
                CurrentIterator currentIterator;
                CurrentIterator currentIterator2 = currentIterator = this.left ? this.lhs : this.rhs;
                if (currentIterator == null) {
                    return null;
                }
                object = currentIterator.current();
                if (currentIterator.hasNext()) {
                    currentIterator.next();
                } else if (this.left) {
                    this.lhs = null;
                } else {
                    this.rhs = null;
                }
                if (this.lhs == null) {
                    this.left = false;
                    continue;
                }
                if (this.rhs == null) {
                    this.left = true;
                    continue;
                }
                boolean bl = this.left = this.cmp.compare(this.lhs.current(), this.rhs.current()) < 0;
            } while (!this.p.test(object));
            return object;
        }

        public static Iterator create(Iterator iterator, Iterator iterator2, Comparator comparator) {
            return new TwoWayMergeIterator(new CurrentIterator(iterator, iterator.next()), new CurrentIterator(iterator2, iterator2.next()), comparator, alwaysTrue);
        }
    }
}

