/*
 * Decompiled with CFR 0.152.
 */
package ham_fisted;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.util.Arrays;
import net.openhft.hashing.LongHashFunction;

public class BlockSplitBloomFilter {
    private static final int BYTES_PER_BLOCK = 32;
    private static final int BITS_PER_BLOCK = 256;
    public static final int LOWER_BOUND_BYTES = 32;
    public static final int UPPER_BOUND_BYTES = 0x8000000;
    private static final int BITS_SET_PER_BLOCK = 8;
    public static final int HEADER_SIZE = 16;
    public static final double DEFAULT_FPP = 0.01;
    private byte[] bitset;
    private IntBuffer intBuffer;
    private int maximumBytes = 0x8000000;
    private int minimumBytes = 32;
    private int[] mask = new int[8];
    private static final int[] SALT = new int[]{1203114875, 1150766481, -2010862245, -1565054819, 1884591559, 770785867, -1627633337, 1550580529};

    public BlockSplitBloomFilter(int n) {
        this.minimumBytes = 32;
        this.maximumBytes = 0x8000000;
        this.initBitset(n);
    }

    public byte[] bitset() {
        return this.bitset;
    }

    public BlockSplitBloomFilter(byte[] byArray) {
        if (byArray == null) {
            throw new RuntimeException("Given bitset is null");
        }
        this.bitset = byArray;
        this.intBuffer = ByteBuffer.wrap(byArray).order(ByteOrder.LITTLE_ENDIAN).asIntBuffer();
    }

    private void initBitset(int n) {
        if (n < this.minimumBytes) {
            n = this.minimumBytes;
        }
        if ((n & n - 1) != 0) {
            n = Integer.highestOneBit(n) << 1;
        }
        if (n > this.maximumBytes || n < 0) {
            n = this.maximumBytes;
        }
        this.bitset = new byte[n];
        this.intBuffer = ByteBuffer.wrap(this.bitset).order(ByteOrder.LITTLE_ENDIAN).asIntBuffer();
    }

    private int[] setMask(int n) {
        int n2;
        for (n2 = 0; n2 < 8; ++n2) {
            this.mask[n2] = n * SALT[n2];
        }
        for (n2 = 0; n2 < 8; ++n2) {
            this.mask[n2] = this.mask[n2] >>> 27;
        }
        for (n2 = 0; n2 < 8; ++n2) {
            this.mask[n2] = 1 << this.mask[n2];
        }
        return this.mask;
    }

    public void insertHash(long l) {
        long l2 = this.bitset.length / 32;
        long l3 = l >>> 32;
        int n = (int)(l3 * l2 >> 32);
        int n2 = (int)l;
        int[] nArray = this.setMask(n2);
        for (int i = 0; i < 8; ++i) {
            int n3 = this.intBuffer.get(n * 8 + i);
            this.intBuffer.put(n * 8 + i, n3 |= nArray[i]);
        }
    }

    public boolean findHash(long l) {
        long l2 = this.bitset.length / 32;
        long l3 = l >>> 32;
        int n = (int)(l3 * l2 >> 32);
        int n2 = (int)l;
        int[] nArray = this.setMask(n2);
        for (int i = 0; i < 8; ++i) {
            if (0 != (this.intBuffer.get(n * 8 + i) & nArray[i])) continue;
            return false;
        }
        return true;
    }

    private static void checkArgument(boolean bl, String string) {
        if (!bl) {
            throw new RuntimeException(string);
        }
    }

    public static int optimalNumOfBits(long l, double d) {
        BlockSplitBloomFilter.checkArgument(d > 0.0 && d < 1.0, "FPP should be less than 1.0 and great than 0.0");
        double d2 = (double)(-8L * l) / Math.log(1.0 - Math.pow(d, 0.125));
        int n = (int)d2;
        if (n > 0x40000000 || d2 < 0.0) {
            n = 0x40000000;
        }
        if ((n = n + 256 - 1 & 0xFFFFFEFF) < 256) {
            n = 256;
        }
        return n;
    }

    public int getBitsetSize() {
        return this.bitset.length;
    }

    public static long hash(byte[] byArray) {
        return LongHashFunction.xx().hashBytes(byArray);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof BlockSplitBloomFilter) {
            BlockSplitBloomFilter blockSplitBloomFilter = (BlockSplitBloomFilter)object;
            return Arrays.equals(this.bitset, blockSplitBloomFilter.bitset);
        }
        return false;
    }

    public boolean canMergeFrom(BlockSplitBloomFilter blockSplitBloomFilter) {
        return blockSplitBloomFilter != null && this.getBitsetSize() == blockSplitBloomFilter.getBitsetSize();
    }

    public void merge(BlockSplitBloomFilter blockSplitBloomFilter) throws IOException {
        BlockSplitBloomFilter.checkArgument(blockSplitBloomFilter != null, "The BloomFilter to merge shouldn't be null");
        BlockSplitBloomFilter.checkArgument(this.canMergeFrom(blockSplitBloomFilter), "BloomFilters must have the same size of bitset.");
        byte[] byArray = blockSplitBloomFilter.bitset;
        for (int i = 0; i < byArray.length; ++i) {
            int n = i;
            this.bitset[n] = (byte)(this.bitset[n] | byArray[i]);
        }
    }
}

