/*
 * Decompiled with CFR 0.152.
 */
package ham_fisted;

import java.util.Iterator;

public interface Iter {
    public Object get();

    public Iter next();

    public static Iter fromIterator(Iterator iterator) {
        return iterator != null && iterator.hasNext() ? new IteratorIter(iterator) : null;
    }

    public static Iterator fromIter(Iter iter) {
        return new IterIterator(iter);
    }

    public static Iter fromIterable(Iterable iterable) {
        return iterable != null ? Iter.fromIterator(iterable.iterator()) : null;
    }

    public static Iter prepend(final Object object, final Iter iter) {
        return new Iter(){

            @Override
            public Object get() {
                return object;
            }

            @Override
            public Iter next() {
                return iter;
            }
        };
    }

    public static class IteratorIter
    implements Iter {
        public final Iterator iter;
        Object get;

        public IteratorIter(Iterator iterator) {
            this.iter = iterator;
            this.get = iterator.next();
        }

        @Override
        public Object get() {
            return this.get;
        }

        @Override
        public Iter next() {
            if (this.iter.hasNext()) {
                this.get = this.iter.next();
                return this;
            }
            return null;
        }
    }

    public static class IterIterator
    implements Iterator {
        Iter iter;

        public IterIterator(Iter iter) {
            this.iter = iter;
        }

        public Iter iter() {
            return this.iter;
        }

        @Override
        public boolean hasNext() {
            return this.iter != null;
        }

        public Object next() {
            Object object = this.iter.get();
            this.iter = this.iter.next();
            return object;
        }
    }
}

