/*
 * Decompiled with CFR 0.152.
 */
package ham_fisted;

import clojure.lang.Box;
import clojure.lang.IDeref;
import clojure.lang.IFn;
import clojure.lang.IPersistentVector;
import clojure.lang.RT;
import ham_fisted.IMutList;
import ham_fisted.Iter;
import ham_fisted.TreeList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.BiFunction;

public class TreeListBase
implements IMutList {
    public static final int branchWidth = 32;
    public static final int leafWidth = 32;
    public static final int tailWidth = 32;
    public static final int shiftWidth = Integer.numberOfTrailingZeros(32);
    public static final Object[][] emptyObjAryAry = new Object[0][];
    public static final Object[] emptyObjAry = new Object[0];
    Object[] tail;
    Object root;
    int count;
    int shift;

    public static int checkIndex(int n, int n2) {
        if (n < 0 || n >= n2) {
            throw new IndexOutOfBoundsException("Index: " + String.valueOf(n) + " is out of range 0-" + String.valueOf(n2));
        }
        return n;
    }

    public static final void sublistCheck(long l, long l2, long l3) {
        if (l < 0L || l > l3) {
            throw new IndexOutOfBoundsException("Start index out of range: start-index(" + String.valueOf(l) + "), n-elems(" + String.valueOf(l3) + ")");
        }
        if (l2 < 0L || l2 > l3) {
            throw new IndexOutOfBoundsException("End index out of range: end-index(" + String.valueOf(l2) + "), n-elems(" + String.valueOf(l3) + ")");
        }
        if (l2 < l) {
            throw new IndexOutOfBoundsException("End index underflow: end-index(" + String.valueOf(l2) + ") < start-index(" + String.valueOf(l) + ")");
        }
    }

    public Object[] tail() {
        return this.tail;
    }

    public Object[] validTail() {
        return this.tail;
    }

    public Object root() {
        return this.root;
    }

    @Override
    public int length() {
        return this.count;
    }

    @Override
    public int count() {
        return this.count;
    }

    @Override
    public int size() {
        return this.count;
    }

    public int shift() {
        return this.shift;
    }

    public int nTail() {
        return this.tail.length;
    }

    public TreeListBase(Object object, Object[] objectArray, int n, int n2) {
        this.tail = objectArray;
        this.root = object;
        this.count = n2;
        this.shift = n;
    }

    public TreeListBase() {
        this.tail = new Object[0];
        this.root = new Leaf();
        this.count = 0;
        this.shift = 0;
    }

    public TreeListBase(TreeListBase treeListBase) {
        this.tail = treeListBase.validTail();
        this.root = treeListBase.root;
        this.count = treeListBase.count;
        this.shift = treeListBase.shift;
    }

    public Iterator<Object[]> arrayIterator(int n, int n2) {
        int n3 = n / 32;
        int n4 = (n2 - n3 * 32 + 31) / 32;
        int n5 = n3 + n4;
        return new ArrayIterator(this, n3, n5);
    }

    public Object[] getArray(int n) {
        int n2 = this.count - this.nTail();
        return n < n2 ? (this.shift == 0 ? ((Leaf)this.root).getArray(n) : ((Branch)this.root).getArray(this.shift, n)) : this.tail;
    }

    @Override
    public Object get(int n) {
        TreeListBase.checkIndex(n, this.count);
        return this.getArray(n)[n % 32];
    }

    public Object reduce(int n, int n2, IFn iFn, Object object) {
        Iterator<Object[]> iterator = this.arrayIterator(n, n2);
        int n3 = n - n % 32;
        while (iterator.hasNext()) {
            int n4 = Math.max(n, n3);
            int n5 = Math.min(n2, n3 + 32);
            int n6 = n5 - n4;
            Object[] objectArray = iterator.next();
            int n7 = n4 % 32;
            int n8 = n7 + n6;
            for (int i = n7; i < n8; ++i) {
                if (!RT.isReduced((Object)(object = iFn.invoke(object, objectArray[i])))) continue;
                return ((IDeref)object).deref();
            }
            n3 += 32;
        }
        return object;
    }

    @Override
    public Object reduce(IFn iFn, Object object) {
        return this.reduce(0, this.count, iFn, object);
    }

    public Object[] fillArray(int n, int n2, Object[] objectArray) {
        Iterator<Object[]> iterator = this.arrayIterator(n, n2);
        int n3 = n - n % 32;
        int n4 = 0;
        while (iterator.hasNext()) {
            int n5 = Math.max(n, n3);
            int n6 = Math.min(n2, n3 + 32);
            int n7 = n6 - n5;
            System.arraycopy(iterator.next(), n5 % 32, objectArray, n4, n7);
            n4 += n7;
            n3 += 32;
        }
        return objectArray;
    }

    @Override
    public Object[] fillArray(Object[] objectArray) {
        return this.fillArray(0, this.count, objectArray);
    }

    @Override
    public IMutList subList(int n, int n2) {
        int n3;
        TreeListBase.sublistCheck(n, n2, this.size());
        int n4 = this.tail.length;
        int n5 = this.count - this.tail.length;
        if (n == 0 && n2 == this.count) {
            return this;
        }
        if (n == n2) {
            return TreeList.EMPTY;
        }
        Object[] objectArray = null;
        if (n2 > n5) {
            n3 = Math.max(n, n5);
            objectArray = Arrays.copyOfRange(this.tail, n3 - n5, n2 - n5);
        }
        Object object = null;
        Object[] objectArray2 = null;
        int n6 = n % 32;
        int n7 = n - n6;
        if (n < n5) {
            int n8 = Math.min(n2, n5);
            SublistResult sublistResult = this.shift == 0 ? ((Leaf)this.root).subList(n7, n8) : ((Branch)this.root).subList(this.shift, n7, n8);
            object = sublistResult.node;
            objectArray2 = sublistResult.tail;
            for (n3 = this.shift; n3 > 0; --n3) {
                Branch branch = (Branch)object;
                if (branch.data.length != 1) break;
                object = branch.data[0];
            }
        }
        if (object == null) {
            return new TreeList(new Leaf(), objectArray, this.meta(), 0, objectArray.length);
        }
        TreeList treeList = new TreeList(object, objectArray == null ? objectArray2 : objectArray, this.meta(), n3, n2 - n7);
        return SubList.create(n6, treeList);
    }

    public static class Leaf {
        final Object owner;
        Object[][] data;

        public Object[][] data() {
            return this.data;
        }

        public Leaf() {
            this.owner = null;
            this.data = emptyObjAryAry;
        }

        public Leaf(Object object, Object[][] objectArray) {
            this.owner = object;
            this.data = objectArray;
        }

        public Leaf(Object[][] objectArray) {
            this(null, objectArray);
        }

        public Leaf(Object[] objectArray) {
            this.owner = null;
            this.data = new Object[][]{objectArray};
        }

        public Object cons(Object object, Object[] objectArray) {
            boolean bl;
            boolean bl2 = bl = object == null || this.owner != object;
            if (this.data.length == 32) {
                return new Object[]{this, new Leaf(object, new Object[][]{objectArray})};
            }
            Object[][] objectArray2 = (Object[][])Arrays.copyOf(this.data, this.data.length + 1);
            objectArray2[this.data.length] = objectArray;
            if (bl) {
                return new Leaf(object, objectArray2);
            }
            this.data = objectArray2;
            return this;
        }

        public Object cons(Object[] objectArray) {
            return this.cons(null, objectArray);
        }

        public Object add(Object object, Object[] objectArray) {
            return this.cons(object, objectArray);
        }

        public ConsAllResult consAll(Object object, int n, Iter iter) {
            int n2;
            int n3 = 32 - this.data.length + 32 * n;
            ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
            Object[] objectArray = new Object[32];
            int n4 = 0;
            int n5 = 0;
            while (arrayList.size() < n3 && iter != null) {
                if (n4 == 32) {
                    arrayList.add((Object[])objectArray.clone());
                }
                for (n4 = 0; n4 < 32 && iter != null; ++n4) {
                    objectArray[n4++] = iter.get();
                    iter = iter.next();
                    ++n5;
                }
                n4 = 0;
            }
            if (n4 == 0) {
                objectArray = new Object[]{};
            } else if (n4 != 32) {
                objectArray = Arrays.copyOf(objectArray, n4);
            }
            if (arrayList.isEmpty()) {
                return new ConsAllResult(new Object[]{this}, iter, objectArray, n5);
            }
            int n6 = arrayList.size();
            int n7 = Math.min(32 - this.data.length, n6);
            Object[][] objectArray2 = (Object[][])Arrays.copyOf(this.data, n7);
            for (n2 = this.data.length; n2 < n7; ++n2) {
                objectArray2[n2] = (Object[])arrayList.get(n2 - this.data.length);
            }
            n2 = (n6 - n7 + 32 - 1) / 32;
            Object[] objectArray3 = new Object[1 + n2];
            objectArray3[0] = new Leaf(object, objectArray2);
            int n8 = 1;
            for (int i = n7; i < n6; i += 32) {
                int n9 = Math.min(n6, i + 32);
                int n10 = n9 - i;
                objectArray3[n8++] = new Leaf(object, (Object[][])arrayList.subList(i, n9).toArray((T[])emptyObjAryAry));
            }
            return new ConsAllResult(objectArray3, iter, objectArray, n5);
        }

        public Object[] getArray(int n) {
            return this.data[n / 32];
        }

        public Leaf assocN(Object object, int n, Object object2, Box box) {
            boolean bl = object == null || this.owner != object;
            int n2 = n / 32;
            Object[] objectArray = bl ? Arrays.copyOf(this.data[n2], 32) : this.data[n2];
            int n3 = n % 32;
            if (box != null) {
                box.val = objectArray[n3];
            }
            objectArray[n3] = object2;
            if (bl) {
                Object[][] objectArray2 = (Object[][])Arrays.copyOf(this.data, this.data.length);
                objectArray2[n2] = objectArray;
                return new Leaf(object, objectArray2);
            }
            return this;
        }

        public SublistResult pop(Object object) {
            Leaf leaf;
            boolean bl;
            int n = this.data.length;
            Object[] objectArray = this.data[n - 1];
            Object object2 = n - 1 == 0 ? new Object[][]{} : (Object[][])Arrays.copyOf(this.data, n - 1);
            boolean bl2 = bl = object == null || this.owner != object;
            if (bl) {
                leaf = new Leaf(object, (Object[][])object2);
            } else {
                this.data = object2;
                leaf = this;
            }
            return new SublistResult(leaf, objectArray);
        }

        public boolean isEmpty() {
            return this.data.length == 0;
        }

        public SublistResult subList(int n, int n2) {
            int n3 = n / 32;
            int n4 = (n2 - n + 31) / 32;
            int n5 = n3 + n4;
            int n6 = n2 - n;
            int n7 = n6 % 32;
            if (n == 0 && n2 == this.data.length * 32) {
                return new SublistResult(this, new Object[0]);
            }
            if (n7 == 0) {
                return new SublistResult(new Leaf((Object[][])Arrays.copyOfRange(this.data, n3, n5)), new Object[0]);
            }
            Object[] objectArray = this.data[n5 - 1];
            return new SublistResult(new Leaf((Object[][])Arrays.copyOfRange(this.data, n3, n5 - 1)), Arrays.copyOf(objectArray, n7));
        }
    }

    public static class ArrayIterator
    implements Iterator<Object[]> {
        final TreeListBase data;
        int arySidx;
        final int aryEidx;

        public ArrayIterator(TreeListBase treeListBase, int n, int n2) {
            this.data = treeListBase;
            this.arySidx = n;
            this.aryEidx = n2;
        }

        @Override
        public boolean hasNext() {
            return this.arySidx < this.aryEidx;
        }

        @Override
        public Object[] next() {
            if (this.arySidx >= this.aryEidx) {
                throw new NoSuchElementException();
            }
            Object[] objectArray = this.data.getArray(this.arySidx * 32);
            ++this.arySidx;
            return objectArray;
        }
    }

    public static class Branch {
        final Object owner;
        Object[] data;
        public static final BiFunction leafMergeRight = new BiFunction(){

            public Object apply(Object object, Object object2) {
                Object[] objectArray;
                Object object3 = (Object[])object;
                Leaf leaf = (Leaf)object2;
                if (object3.data.length < 32) {
                    int n = object3.data.length + leaf.data.length;
                    int n2 = Math.min(32, object3.data.length + leaf.data.length);
                    Object[][] objectArray2 = (Object[][])Arrays.copyOf(object3.data, n2);
                    System.arraycopy(leaf.data, 0, objectArray2, object3.data.length, n2 - object3.data.length);
                    object3 = new Leaf(objectArray2);
                    int n3 = n - n2;
                    leaf = n3 > 0 ? new Leaf((Object[][])Arrays.copyOfRange(leaf.data, leaf.data.length - n3, leaf.data.length)) : null;
                }
                if (leaf == null) {
                    objectArray = object3;
                } else {
                    Object[] objectArray3 = new Object[2];
                    objectArray3[0] = object3;
                    objectArray = objectArray3;
                    objectArray3[1] = leaf;
                }
                return objectArray;
            }
        };
        public static final BiFunction branchMergeRight = new BiFunction(){

            public Object apply(Object object, Object object2) {
                Object[] objectArray;
                Object object3 = (Object[])object;
                Branch branch = (Branch)object2;
                if (object3.data.length < 32) {
                    int n = object3.data.length + branch.data.length;
                    int n2 = Math.min(32, object3.data.length + branch.data.length);
                    Object[] objectArray2 = Arrays.copyOf(object3.data, n2);
                    System.arraycopy(branch.data, 0, objectArray2, object3.data.length, n2 - object3.data.length);
                    object3 = new Branch(object3.owner, objectArray2);
                    int n3 = n - n2;
                    branch = n3 > 0 ? new Branch(branch.owner, Arrays.copyOfRange(branch.data, branch.data.length - n3, branch.data.length)) : null;
                }
                if (branch == null) {
                    objectArray = object3;
                } else {
                    Object[] objectArray3 = new Object[2];
                    objectArray3[0] = object3;
                    objectArray = objectArray3;
                    objectArray3[1] = branch;
                }
                return objectArray;
            }
        };

        public Object[] data() {
            return this.data;
        }

        public Branch() {
            this.owner = null;
            this.data = new Object[0];
        }

        public Branch(Object object, Object[] objectArray) {
            this.owner = object;
            this.data = objectArray;
        }

        public Branch(Leaf leaf) {
            this.owner = null;
            this.data = new Object[]{leaf};
        }

        public Branch(Branch branch) {
            this.owner = null;
            this.data = new Object[]{branch};
        }

        public Branch(Object object, int n, Object[] objectArray) {
            this(object, new Object[]{n == 1 ? new Leaf(objectArray) : new Branch(n - 1, objectArray)});
        }

        public Object cons(Object object, int n, Object[] objectArray) {
            Object object2;
            if (this.data.length == 0) {
                return new Branch(object, n, objectArray);
            }
            int n2 = this.data.length - 1;
            Object object3 = this.data[n2];
            boolean bl = object == null || this.owner != object;
            Object object4 = object2 = n == 1 ? ((Leaf)object3).cons(object, objectArray) : ((Branch)object3).cons(object, n - 1, objectArray);
            if (object2 instanceof Object[]) {
                Object object5 = ((Object[])object2)[1];
                if (this.data.length == 32) {
                    return new Object[]{this, new Branch(object, new Object[]{object5})};
                }
                Object[] objectArray2 = Arrays.copyOf(this.data, this.data.length + 1);
                objectArray2[this.data.length] = object5;
                if (bl) {
                    return new Branch(object, objectArray2);
                }
                this.data = objectArray2;
                return this;
            }
            Object[] objectArray3 = bl ? (Object[])this.data.clone() : this.data;
            objectArray3[objectArray3.length - 1] = object2;
            if (bl) {
                return new Branch(object, objectArray3);
            }
            return this;
        }

        public Object cons(int n, Object[] objectArray) {
            return this.cons(null, n, objectArray);
        }

        public Object add(Object object, int n, Object[] objectArray) {
            return this.cons(object, n, objectArray);
        }

        public ConsAllResult consAll(Object object, int n, int n2, Iter iter) {
            int n3 = 32 - this.data.length + 32 * n2;
            Object object2 = this.data[this.data.length - 1];
            ConsAllResult consAllResult = n == 1 ? ((Leaf)object2).consAll(object, n3, iter) : ((Branch)object2).consAll(object, n - 1, n3, iter);
            int n4 = consAllResult.nodes.length;
            Object[] objectArray = consAllResult.tail;
            iter = consAllResult.nextData;
            int n5 = consAllResult.added;
            if (consAllResult.nodes.length == 1 && consAllResult.nodes[0] == object2) {
                return new ConsAllResult(new Object[]{this}, iter, objectArray, n5);
            }
            int n6 = Math.min(n4, 32 - this.data.length);
            Object[] objectArray2 = Arrays.copyOf(this.data, this.data.length + n6);
            int n7 = (n4 - n6 + 32 - 1) / 32;
            Object[] objectArray3 = new Object[1 + n7];
            objectArray3[0] = new Branch(object, objectArray2);
            for (int i = 0; i < n7; ++i) {
                int n8 = n6 + i * 32;
                int n9 = Math.min(n8 + 32, n4);
                objectArray3[i + 1] = new Branch(object, Arrays.copyOfRange(this.data, n8, n9));
            }
            return new ConsAllResult(objectArray3, iter, objectArray, n5);
        }

        public Object getNode(int n, int n2) {
            int n3 = n * shiftWidth;
            int n4 = 32 << n3;
            int n5 = n2 / n4;
            return this.data[n5];
        }

        public Object[] getArray(int n, int n2) {
            int n3 = n * shiftWidth;
            int n4 = 32 << n3;
            int n5 = n2 / n4;
            int n6 = n2 % n4;
            Object object = this.data[n5];
            return n == 1 ? ((Leaf)object).getArray(n6) : ((Branch)object).getArray(n - 1, n6);
        }

        public Branch assocN(Object object, int n, int n2, Object object2, Box box) {
            Object[] objectArray;
            boolean bl = object == null || this.owner != object;
            int n3 = n * shiftWidth;
            int n4 = 32 << n3;
            int n5 = n2 / n4;
            int n6 = n2 % n4;
            Object object3 = this.data[n5];
            Leaf leaf = n == 1 ? ((Leaf)object3).assocN(object, n6, object2, box) : ((Branch)object3).assocN(object, n - 1, n6, object2, box);
            Object[] objectArray2 = objectArray = bl ? Arrays.copyOf(this.data, this.data.length) : this.data;
            if (leaf != object3) {
                objectArray[n5] = leaf;
            }
            return bl ? new Branch(object, objectArray) : this;
        }

        public boolean isEmpty() {
            return this.data.length == 0;
        }

        public SublistResult pop(Object object, int n) {
            Branch branch;
            boolean bl;
            boolean bl2 = object == null || object != this.owner;
            int n2 = this.data.length;
            Object object2 = this.data[n2 - 1];
            SublistResult sublistResult = n == 1 ? ((Leaf)object2).pop(object) : ((Branch)object2).pop(object, n - 1);
            Object object3 = sublistResult.node;
            Object[] objectArray = sublistResult.tail;
            boolean bl3 = bl = n == 1 ? ((Leaf)object3).isEmpty() : ((Branch)object3).isEmpty();
            Object[] objectArray2 = bl ? (n2 - 1 == 0 ? new Object[]{} : Arrays.copyOf(this.data, n2 - 1)) : (bl2 ? (Object[])this.data.clone() : this.data);
            int n3 = objectArray2.length;
            if (!bl) {
                objectArray2[n3 - 1] = object3;
            }
            if (bl2) {
                branch = new Branch(object, objectArray2);
            } else {
                this.data = objectArray2;
                branch = this;
            }
            return new SublistResult(branch, objectArray);
        }

        public SublistResult subList(int n, int n2, int n3) {
            int n4 = n * shiftWidth;
            int n5 = 32 << n4;
            int n6 = n2 / n5;
            int n7 = (n3 - n6 * n5 + (n5 - 1)) / n5;
            int n8 = n6 + n7;
            ArrayList<Object> arrayList = new ArrayList<Object>(n7);
            Object[] objectArray = null;
            BiFunction biFunction = n == 1 ? leafMergeRight : branchMergeRight;
            for (int i = 0; i < n7; ++i) {
                Object[] objectArray2;
                int n9;
                int n10 = n6 + i;
                int n11 = n10 * n5;
                int n12 = n11 + n5;
                int n13 = Math.max(n11, n2);
                int n14 = Math.min(n12, n3);
                Object object = this.data[n10];
                if (n11 == n13 && n12 == n14) {
                    arrayList.add(object);
                } else {
                    n9 = n13 - n11;
                    int n15 = n14 - n11;
                    objectArray2 = n == 1 ? ((Leaf)object).subList(n9, n15) : ((Branch)object).subList(n - 1, n9, n15);
                    arrayList.add(objectArray2.node);
                    objectArray = objectArray2.tail;
                }
                n9 = arrayList.size();
                if (n9 <= 1) continue;
                Object r = biFunction.apply(arrayList.get(n9 - 2), arrayList.get(n9 - 1));
                if (r instanceof Object[]) {
                    objectArray2 = (Object[])r;
                    arrayList.set(n9 - 2, objectArray2[0]);
                    arrayList.set(n9 - 1, objectArray2[1]);
                    continue;
                }
                arrayList.set(n9 - 2, r);
                arrayList.remove(n9 - 1);
            }
            return new SublistResult(new Branch(this.owner, arrayList.toArray()), objectArray);
        }
    }

    public static class SublistResult {
        public final Object node;
        public final Object[] tail;

        public SublistResult(Object object, Object[] objectArray) {
            this.node = object;
            this.tail = objectArray;
        }
    }

    public static class SubList
    implements IMutList,
    IPersistentVector {
        int offset;
        TreeList data;

        public SubList(int n, TreeList treeList) {
            this.offset = n;
            this.data = treeList;
        }

        public int offset() {
            return this.offset;
        }

        public TreeList data() {
            return this.data;
        }

        @Override
        public int count() {
            return this.data.count() - this.offset;
        }

        @Override
        public int size() {
            return this.data.count() - this.offset;
        }

        @Override
        public int length() {
            return this.data.count() - this.offset;
        }

        @Override
        public Object get(int n) {
            return this.data.get(n + this.offset);
        }

        @Override
        public SubList cons(Object object) {
            return new SubList(this.offset, this.data.cons(object));
        }

        public SubList assocN(int n, Object object) {
            return new SubList(this.offset, this.data.assocN(n, object));
        }

        public IPersistentVector pop() {
            int n = this.count();
            if (n == 0) {
                throw new UnsupportedOperationException("Underflow");
            }
            if (n == 1) {
                return TreeList.EMPTY;
            }
            return new SubList(this.offset, this.data.pop());
        }

        public Object peek() {
            return this.data.peek();
        }

        @Override
        public IMutList subList(int n, int n2) {
            TreeListBase.sublistCheck(n, n2, this.size());
            return this.data.subList(n + this.offset, n2 + this.offset);
        }

        @Override
        public Object[] fillArray(Object[] objectArray) {
            return this.data.fillArray(this.offset, this.data.count(), objectArray);
        }

        @Override
        public Object reduce(IFn iFn, Object object) {
            return this.data.reduce(this.offset, this.data.count(), iFn, object);
        }

        public static IMutList create(int n, TreeList treeList) {
            if (n == 0) {
                return treeList;
            }
            return new SubList(n, treeList);
        }
    }

    public static class ConsAllResult {
        public final Object[] nodes;
        public final Iter nextData;
        public final Object[] tail;
        public final int added;

        public ConsAllResult(Object[] objectArray, Iter iter, Object[] objectArray2, int n) {
            this.nodes = objectArray;
            this.nextData = iter;
            this.tail = objectArray2;
            this.added = n;
        }
    }
}

