/*
 * Decompiled with CFR 0.152.
 */
package ham_fisted;

import clojure.lang.ArrayChunk;
import clojure.lang.Associative;
import clojure.lang.ChunkedCons;
import clojure.lang.IChunk;
import clojure.lang.IChunkedSeq;
import clojure.lang.IDeref;
import clojure.lang.IFn;
import clojure.lang.IHashEq;
import clojure.lang.IKVReduce;
import clojure.lang.IMapEntry;
import clojure.lang.IObj;
import clojure.lang.IPersistentMap;
import clojure.lang.IPersistentVector;
import clojure.lang.IReduce;
import clojure.lang.ISeq;
import clojure.lang.Indexed;
import clojure.lang.MapEntry;
import clojure.lang.RT;
import clojure.lang.Reversible;
import clojure.lang.Seqable;
import clojure.lang.Sequential;
import clojure.lang.Util;
import ham_fisted.ArrayImmutList;
import ham_fisted.ArrayLists;
import ham_fisted.Casts;
import ham_fisted.ChunkedList;
import ham_fisted.CljHash;
import ham_fisted.IFnDef;
import ham_fisted.ITypedReduce;
import ham_fisted.ImmutSort;
import ham_fisted.LazyChunkedSeq;
import ham_fisted.ParallelOptions;
import ham_fisted.RandomAccessSpliterator;
import ham_fisted.RangeList;
import ham_fisted.Reductions;
import ham_fisted.ReindexList;
import ham_fisted.ReverseList;
import it.unimi.dsi.fastutil.doubles.DoubleComparator;
import it.unimi.dsi.fastutil.floats.FloatComparator;
import it.unimi.dsi.fastutil.ints.IntArrays;
import it.unimi.dsi.fastutil.ints.IntComparator;
import it.unimi.dsi.fastutil.longs.LongComparator;
import it.unimi.dsi.fastutil.objects.ObjectArrays;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Random;
import java.util.RandomAccess;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.stream.DoubleStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;

public interface IMutList<E>
extends List<E>,
RandomAccess,
Indexed,
IFnDef,
ITypedReduce<E>,
IKVReduce,
IReduce,
IHashEq,
Seqable,
Reversible,
IObj,
ImmutSort<E>,
RangeList,
Cloneable,
Sequential,
Associative,
Comparable {
    default public IMutList cloneList() {
        return ArrayLists.toList(this.toArray());
    }

    @Override
    default public void clear() {
        throw new UnsupportedOperationException("Unimplemented");
    }

    @Override
    default public boolean add(E e) {
        throw new UnsupportedOperationException("Unimplemented");
    }

    @Override
    default public void add(int n, E e) {
        this.add(n, 1, e);
    }

    default public void add(int n, int n2, E e) {
        int n3 = n + n2;
        if (n == this.size()) {
            while (n < n3) {
                this.add(e);
                ++n;
            }
        } else {
            while (n < n3) {
                this.add(n, e);
                ++n;
            }
        }
    }

    default public void addLong(long l) {
        this.add(l);
    }

    default public void addDouble(double d) {
        this.add(d);
    }

    @Override
    default public void removeRange(long l, long l2) {
        ChunkedList.checkIndexRange(0L, (long)this.size(), l, l2);
        int n = (int)l;
        while (l < l2) {
            this.remove(n);
            ++l;
        }
    }

    @Override
    default public void fillRange(long l, long l2, Object object) {
        int n = this.size();
        ChunkedList.checkIndexRange(0L, (long)n, l, l2);
        int n2 = (int)l2;
        for (int i = (int)l; i < n2; ++i) {
            this.set(i, object);
        }
    }

    @Override
    default public void fillRangeReducible(long l, Object object) {
        int n = this.size();
        if (object instanceof RandomAccess) {
            ChunkedList.checkIndexRange(0L, (long)n, l, l + (long)((List)object).size());
        }
        final int n2 = (int)l;
        Reductions.serialReduction(new Reductions.IndexedAccum(new IFnDef.OLOO(){

            public Object invokePrim(Object object, long l, Object object2) {
                ((List)object).set((int)l + n2, object2);
                return object;
            }
        }), this, object);
    }

    @Override
    default public E remove(int n) {
        Object e = this.get(n);
        this.removeRange(n, n + 1);
        return e;
    }

    @Override
    default public boolean remove(Object object) {
        int n = this.indexOf(object);
        if (n == -1) {
            return false;
        }
        this.remove(n);
        return true;
    }

    @Override
    default public boolean addAll(Collection<? extends E> collection) {
        return this.addAllReducible(collection);
    }

    default public boolean addAllReducible(Object object) {
        int n = this.size();
        Reductions.serialReduction(new IFnDef(){

            @Override
            public Object invoke(Object object, Object object2) {
                ((IMutList)object).add(object2);
                return object;
            }
        }, this, object);
        return n != this.size();
    }

    @Override
    default public boolean addAll(int n, Collection<? extends E> collection) {
        if (collection.isEmpty()) {
            return false;
        }
        int n2 = this.size();
        if (n == n2) {
            return this.addAll(collection);
        }
        for (E e : collection) {
            this.add(n++, e);
        }
        return true;
    }

    @Override
    default public boolean removeAll(Collection<?> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    default public boolean retainAll(Collection<?> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    default public IMutList<E> subList(int n, int n2) {
        int n3 = this.size();
        if (n == 0 && n2 == n3) {
            return this;
        }
        ChunkedList.sublistCheck(n, n2, this.size());
        return new MutSubList(this, n, n2);
    }

    @Override
    default public int indexOf(Object object) {
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            if (!Objects.equals(object, this.get(i))) continue;
            return i;
        }
        return -1;
    }

    @Override
    default public int lastIndexOf(Object object) {
        int n = this.size();
        int n2 = n - 1;
        for (int i = 0; i < n; ++i) {
            int n3 = n2 - i;
            if (!Objects.equals(object, this.get(n3))) continue;
            return n3;
        }
        return -1;
    }

    @Override
    default public boolean contains(Object object) {
        return this.indexOf(object) != -1;
    }

    @Override
    default public boolean isEmpty() {
        return this.size() == 0;
    }

    default public int compareTo(Object object) {
        int n;
        List list = (List)object;
        int n2 = this.size();
        if (n2 < (n = list.size())) {
            return -1;
        }
        if (n2 > n) {
            return 1;
        }
        for (int i = 0; i < n2; ++i) {
            int n3 = Util.compare(this.get(i), list.get(i));
            if (n3 == 0) continue;
            return n3;
        }
        return 0;
    }

    @Override
    default public ListIterator<E> listIterator(int n) {
        if (n < 0 || n > this.size()) {
            throw new NoSuchElementException("Index(" + String.valueOf(n) + ") out of range 0-" + this.size());
        }
        return new ListIter(this, n);
    }

    @Override
    default public ListIterator<E> listIterator() {
        return this.listIterator(0);
    }

    @Override
    default public Iterator<E> iterator() {
        return this.listIterator(0);
    }

    default public Iterator<E> riterator() {
        return new RIter(this);
    }

    @Override
    default public Spliterator<E> spliterator() {
        return new RandomAccessSpliterator(this);
    }

    default public Object[] fillArray(Object[] objectArray) {
        Reductions.serialReduction(new Reductions.IndexedAccum(new IFnDef.OLOO(){

            public Object invokePrim(Object object, long l, Object object2) {
                ((Object[])object)[(int)l] = object2;
                return object;
            }
        }), objectArray, this);
        return objectArray;
    }

    @Override
    default public Object[] toArray() {
        return this.fillArray(new Object[this.size()]);
    }

    @Override
    default public <T> T[] toArray(T[] TArray) {
        Object[] objectArray = Arrays.copyOf(TArray, this.size());
        this.fillArray(objectArray);
        return objectArray;
    }

    default public Object toNativeArray() {
        return this.toArray();
    }

    default public int[] toIntArray() {
        int[] nArray = new int[this.size()];
        ArrayLists.toList(nArray).fillRange(0L, this);
        return nArray;
    }

    default public long[] toLongArray() {
        long[] lArray = new long[this.size()];
        ArrayLists.toList(lArray).fillRange(0L, this);
        return lArray;
    }

    default public float[] toFloatArray() {
        float[] fArray = new float[this.size()];
        ArrayLists.toList(fArray).fillRange(0L, this);
        return fArray;
    }

    default public double[] toDoubleArray() {
        double[] dArray = new double[this.size()];
        ArrayLists.toList(dArray).fillRange(0L, this);
        return dArray;
    }

    default public IntComparator indexComparator() {
        return new IntComparator(){

            public int compare(int n, int n2) {
                return ((Comparable)IMutList.this.get(n)).compareTo(IMutList.this.get(n2));
            }
        };
    }

    default public IntComparator indexComparator(final Comparator comparator) {
        if (comparator instanceof DoubleComparator) {
            final DoubleComparator doubleComparator = (DoubleComparator)comparator;
            return new IntComparator(){

                public int compare(int n, int n2) {
                    return doubleComparator.compare(IMutList.this.getDouble(n), IMutList.this.getDouble(n2));
                }
            };
        }
        if (comparator instanceof IntComparator) {
            final IntComparator intComparator = (IntComparator)comparator;
            return new IntComparator(){

                public int compare(int n, int n2) {
                    return intComparator.compare((int)IMutList.this.getLong(n), (int)IMutList.this.getLong(n2));
                }
            };
        }
        if (comparator instanceof LongComparator) {
            final LongComparator longComparator = (LongComparator)comparator;
            return new IntComparator(){

                public int compare(int n, int n2) {
                    return longComparator.compare(IMutList.this.getLong(n), IMutList.this.getLong(n2));
                }
            };
        }
        if (comparator instanceof FloatComparator) {
            final FloatComparator floatComparator = (FloatComparator)comparator;
            return new IntComparator(){

                public int compare(int n, int n2) {
                    return floatComparator.compare((float)IMutList.this.getDouble(n), (float)IMutList.this.getDouble(n2));
                }
            };
        }
        return new IntComparator(){

            public int compare(int n, int n2) {
                return comparator.compare(IMutList.this.get(n), IMutList.this.get(n2));
            }
        };
    }

    default public int[] sortIndirect(final Comparator comparator) {
        int n = this.size();
        int[] nArray = ArrayLists.iarange(0, n, 1);
        final Object[] objectArray = this.toArray();
        if (comparator == null) {
            ObjectArrays.parallelQuickSortIndirect((int[])nArray, (Object[])objectArray);
        } else {
            IntArrays.parallelQuickSort((int[])nArray, (IntComparator)new IntComparator(){

                public int compare(int n, int n2) {
                    return comparator.compare(objectArray[n], objectArray[n2]);
                }
            });
        }
        return nArray;
    }

    default public Object nth(int n) {
        int n2 = this.size();
        if (n < 0) {
            n += n2;
        }
        return this.get(n);
    }

    default public Object nth(int n, Object object) {
        int n2 = this.size();
        if (n < 0) {
            n += n2;
        }
        return n < n2 && n > -1 ? this.get(n) : object;
    }

    @Override
    default public E set(int n, E e) {
        throw new UnsupportedOperationException("Unimplemented");
    }

    default public void setLong(int n, long l) {
        this.set(n, l);
    }

    default public void setDouble(int n, double d) {
        this.set(n, d);
    }

    default public long getLong(int n) {
        return Casts.longCast(this.get(n));
    }

    default public double getDouble(int n) {
        Object e = this.get(n);
        return e != null ? Casts.doubleCast(e) : Double.NaN;
    }

    default public void accPlusLong(int n, long l) {
        this.setLong(n, this.getLong(n) + l);
    }

    default public void accPlusDouble(int n, double d) {
        this.setDouble(n, this.getDouble(n) + d);
    }

    @Override
    default public Object invoke(Object object) {
        return this.nth(RT.intCast((long)Casts.longCast(object)));
    }

    @Override
    default public Object invoke(Object object, Object object2) {
        if (Util.isInteger((Object)object)) {
            return this.nth(RT.intCast((long)Casts.longCast(object)), object2);
        }
        return object2;
    }

    default public Object valAt(Object object) {
        return this.invoke(object);
    }

    default public Object valAt(Object object, Object object2) {
        return this.invoke(object, object2);
    }

    default public IMapEntry entryAt(Object object) {
        int n;
        if (Util.isInteger((Object)object) && (n = RT.intCast((Object)object)) >= 0 && n < this.size()) {
            return MapEntry.create((Object)n, this.get(n));
        }
        return null;
    }

    @Override
    default public boolean containsAll(Collection<?> collection) {
        throw new UnsupportedOperationException();
    }

    default public boolean containsKey(Object object) {
        int n;
        return Util.isInteger((Object)object) && (n = RT.intCast((Object)object)) >= 0 && n < this.size();
    }

    default public int count() {
        return this.size();
    }

    default public int length() {
        return this.size();
    }

    @Override
    default public Object reduce(IFn iFn) {
        int n = this.size();
        if (n == 0) {
            return iFn.invoke();
        }
        Object object = this.get(0);
        for (int i = 1; i < n && !RT.isReduced(object); ++i) {
            object = iFn.invoke(object, this.get(i));
        }
        return Reductions.unreduce(object);
    }

    default public Object reduce(IFn iFn, Object object) {
        int n = this.size();
        for (int i = 0; i < n && !RT.isReduced((Object)object); ++i) {
            object = iFn.invoke(object, this.get(i));
        }
        return Reductions.unreduce(object);
    }

    default public Object kvreduce(IFn iFn, Object object) {
        int n = this.size();
        for (int i = 0; i < n && !RT.isReduced((Object)object); ++i) {
            object = iFn.invoke(object, (Object)i, this.get(i));
        }
        return Reductions.unreduce(object);
    }

    @Override
    default public Object parallelReduction(IFn iFn, IFn iFn2, IFn iFn3, ParallelOptions parallelOptions) {
        return Reductions.parallelRandAccessReduction(iFn, iFn2, iFn3, this, parallelOptions);
    }

    @Override
    default public void forEach(Consumer consumer) {
        ITypedReduce.super.forEach(consumer);
    }

    default public int hasheq() {
        return CljHash.listHasheq(this);
    }

    default public boolean equiv(Object object) {
        return CljHash.listEquiv(this, object);
    }

    public static IChunk sublistAsChunk(final List list, final int n) {
        int n2 = list.size();
        final int n3 = n2 - n;
        if (n3 > 0) {
            return new IChunk(){

                public int count() {
                    return n3;
                }

                public Object nth(int n2, Object object) {
                    return n2 < n3 ? list.get(n2 + n) : object;
                }

                public Object nth(int n2) {
                    if (n2 < n3) {
                        return list.get(n2 + n);
                    }
                    throw new IndexOutOfBoundsException();
                }

                public IChunk dropFirst() {
                    return n3 > 1 ? IMutList.sublistAsChunk(list, n + 1) : null;
                }

                public Object reduce(IFn iFn, Object object) {
                    int n2 = n3;
                    for (int i = 0; i < n2; ++i) {
                        if (!RT.isReduced((Object)(object = iFn.invoke(object, list.get(i + n))))) continue;
                        return ((IDeref)object).deref();
                    }
                    return object;
                }
            };
        }
        return null;
    }

    public static IChunkedSeq inplaceSublistSeq(final List list, final int n, final int n2) {
        final int n3 = n2 - n;
        if (n3 > 0) {
            final int n4 = Math.min(32, n3);
            return new LazyChunkedSeq(new IFnDef(){

                @Override
                public Object invoke() {
                    return new ChunkedCons(IMutList.sublistAsChunk(list.subList(n, n + n4), 0), n3 - n4 <= 0 ? null : IMutList.inplaceSublistSeq(list, n + n4, n2));
                }
            });
        }
        return null;
    }

    default public IChunkedSeq inplaceSublistSeq() {
        if (this.isEmpty()) {
            return null;
        }
        return IMutList.inplaceSublistSeq(this, 0, this.size());
    }

    public static IChunkedSeq copyingArraySeq(final List list, final int n, final int n2) {
        final int n3 = n2 - n;
        if (n3 > 0) {
            final int n4 = Math.min(32, n3);
            return new LazyChunkedSeq(new IFnDef(){

                @Override
                public Object invoke() {
                    return new ChunkedCons((IChunk)new ArrayChunk(list.subList(n, n + n4).toArray()), n3 - n4 <= 0 ? null : IMutList.inplaceSublistSeq(list, n + n4, n2));
                }
            });
        }
        return null;
    }

    default public IChunkedSeq copyingArraySeq() {
        if (this.isEmpty()) {
            return null;
        }
        return IMutList.copyingArraySeq(this, 0, this.size());
    }

    default public ISeq seq() {
        return this.copyingArraySeq();
    }

    default public ISeq rseq() {
        return this.isEmpty() ? null : new ReverseList(this, this.meta()).seq();
    }

    default public IPersistentMap meta() {
        return null;
    }

    default public IObj withMeta(IPersistentMap iPersistentMap) {
        throw new UnsupportedOperationException("Unimplemented");
    }

    @Override
    default public void sort(Comparator<? super E> comparator) {
        Object[] objectArray = this.toArray();
        if (comparator == null) {
            ObjectArrays.parallelQuickSort((Object[])objectArray);
        } else {
            ObjectArrays.parallelQuickSort((Object[])objectArray, comparator);
        }
        this.fillRange(0L, ArrayLists.toList(objectArray));
    }

    @Override
    default public List immutSort(Comparator comparator) {
        IMutList iMutList = this.cloneList();
        iMutList.sort(comparator);
        return iMutList;
    }

    default public void shuffle(Random random) {
        Collections.shuffle(this, random);
    }

    default public List reindex(int[] nArray) {
        return ReindexList.create(nArray, this, this.meta());
    }

    default public List immutShuffle(Random random) {
        Object[] objectArray = this.toArray();
        ObjectArrays.shuffle((Object[])objectArray, (Random)random);
        return ArrayLists.toList(objectArray, 0, this.size(), this.meta());
    }

    default public List reverse() {
        return ReverseList.create(this, this.meta());
    }

    default public int binarySearch(E e, Comparator<? super E> comparator) {
        int n = comparator == null ? Collections.binarySearch(this, e, new Comparator<E>(){

            @Override
            public int compare(E e, E e2) {
                return Util.compare(e, e2);
            }
        }) : Collections.binarySearch(this, e, comparator);
        return n < 0 ? -1 - n : n;
    }

    default public int binarySearch(E e) {
        return this.binarySearch(e, null);
    }

    default public IPersistentVector immut() {
        return ArrayImmutList.create(true, this.toArray(), 0, this.size(), this.meta());
    }

    default public Associative assoc(Object object, Object object2) {
        return this.immut().assoc(object, object2);
    }

    default public IPersistentVector cons(Object object) {
        return this.immut().cons(object);
    }

    default public IPersistentVector empty() {
        return ArrayImmutList.EMPTY;
    }

    default public LongStream indexStream(boolean bl) {
        LongStream longStream = LongStream.range(0L, this.size());
        return bl ? longStream.parallel() : longStream;
    }

    default public Stream objStream(boolean bl) {
        return this.indexStream(bl).mapToObj(l -> this.get((int)l));
    }

    default public DoubleStream doubleStream(boolean bl) {
        return this.indexStream(bl).mapToDouble(l -> this.getDouble((int)l));
    }

    default public LongStream longStream(boolean bl) {
        return this.indexStream(bl).map(l -> this.getLong((int)l));
    }

    public static class MutSubList<E>
    implements IMutList<E> {
        final IMutList<E> list;
        final int sidx;
        final int eidx;
        final int nElems;

        public MutSubList(IMutList<E> iMutList, int n, int n2) {
            this.list = iMutList;
            this.sidx = n;
            this.eidx = n2;
            this.nElems = n2 - n;
        }

        @Override
        public int size() {
            return this.nElems;
        }

        @Override
        public E get(int n) {
            ChunkedList.indexCheck(this.sidx, this.nElems, n);
            return this.list.get(this.sidx + n);
        }

        @Override
        public long getLong(int n) {
            ChunkedList.indexCheck(this.sidx, this.nElems, n);
            return this.list.getLong(this.sidx + n);
        }

        @Override
        public double getDouble(int n) {
            ChunkedList.indexCheck(this.sidx, this.nElems, n);
            return this.list.getDouble(this.sidx + n);
        }

        @Override
        public E set(int n, E e) {
            ChunkedList.indexCheck(this.sidx, this.nElems, n);
            return this.list.set(this.sidx + n, e);
        }

        @Override
        public void setLong(int n, long l) {
            ChunkedList.indexCheck(this.sidx, this.nElems, n);
            this.list.setLong(this.sidx + n, l);
        }

        @Override
        public void setDouble(int n, double d) {
            ChunkedList.indexCheck(this.sidx, this.nElems, n);
            this.list.setDouble(this.sidx + n, d);
        }

        @Override
        public Object reduce(IFn iFn, Object object) {
            int n = this.eidx;
            IMutList<E> iMutList = this.list;
            for (int i = this.sidx; i < n && !RT.isReduced((Object)object); ++i) {
                object = iFn.invoke(object, iMutList.get(i));
            }
            return Reductions.unreduce(object);
        }

        @Override
        public IMutList<E> subList(int n, int n2) {
            ChunkedList.sublistCheck(n, n2, this.nElems);
            if (n == 0 && n2 == this.nElems) {
                return this;
            }
            return this.list.subList(n + this.sidx, n2 + this.sidx);
        }

        @Override
        public IPersistentMap meta() {
            return this.list.meta();
        }

        @Override
        public IMutList<E> withMeta(IPersistentMap iPersistentMap) {
            return ((IMutList)this.list.withMeta(iPersistentMap)).subList(this.sidx, this.eidx);
        }
    }

    public static class ListIter<E>
    implements ListIterator<E> {
        List<E> list;
        int idx = 0;
        int previdx = 0;

        ListIter(List<E> list, int n) {
            this.list = list;
            this.idx = n;
            this.previdx = n;
        }

        @Override
        public final boolean hasNext() {
            return this.idx < this.list.size();
        }

        @Override
        public final boolean hasPrevious() {
            return this.idx > 0;
        }

        @Override
        public final E next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            E e = this.list.get(this.idx);
            this.previdx = this.idx++;
            return e;
        }

        @Override
        public final E previous() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            --this.idx;
            this.previdx = this.idx;
            return this.list.get(this.idx);
        }

        @Override
        public final int nextIndex() {
            return this.idx;
        }

        @Override
        public final int previousIndex() {
            return this.idx - 1;
        }

        @Override
        public final void remove() {
            this.list.remove(this.previdx);
        }

        @Override
        public final void set(E e) {
            this.list.set(this.previdx, e);
        }

        @Override
        public final void add(E e) {
            this.list.add(this.previdx, e);
        }
    }

    public static class RIter<E>
    implements Iterator<E> {
        List<E> list;
        int idx;

        public RIter(List<E> list) {
            this.list = list;
            this.idx = 0;
        }

        @Override
        public final boolean hasNext() {
            return this.idx < this.list.size();
        }

        @Override
        public final E next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            int n = this.list.size() - this.idx - 1;
            ++this.idx;
            return this.list.get(n);
        }
    }
}

