/*
 * Decompiled with CFR 0.152.
 */
package ham_fisted;

import clojure.lang.AFn;
import clojure.lang.IFn;
import clojure.lang.Keyword;
import java.util.HashMap;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;

public final class MethodImplCache {
    final ReentrantLock extLock = new ReentrantLock();
    final HashMap<Class, IFn> extensions = new HashMap();
    volatile IFn nullExtension = null;
    final ConcurrentHashMap<Class, IFn> lookupCache = new ConcurrentHashMap();
    public static final IFn DEFAULT = new AFn(){

        public Object invoke() {
            return null;
        }
    };
    public final Keyword methodk;
    public final Keyword ns_methodk;
    public final Class iface;
    public final IFn ifaceFn;

    public MethodImplCache(Keyword keyword, Keyword keyword2, Class clazz, IFn iFn) {
        this.methodk = keyword;
        this.ns_methodk = keyword2;
        this.iface = clazz;
        this.ifaceFn = iFn;
    }

    public void extend(Class clazz, IFn iFn) {
        this.extLock.lock();
        try {
            if (clazz == null) {
                this.nullExtension = iFn;
            } else if (iFn == null) {
                this.extensions.remove(clazz);
            } else {
                this.extensions.put(clazz, iFn);
            }
        }
        finally {
            this.extLock.unlock();
        }
        this.lookupCache.clear();
    }

    public Set registeredClasses() {
        return this.extensions.keySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IFn findFnFor(Class clazz) {
        if (clazz == null) {
            return this.nullExtension;
        }
        IFn iFn = DEFAULT;
        IFn iFn2 = this.lookupCache.getOrDefault(clazz, iFn);
        if (iFn2 != iFn) {
            return iFn2;
        }
        this.extLock.lock();
        try {
            for (Class clazz2 = clazz; clazz2 != null && iFn2 == iFn; clazz2 = clazz2.getSuperclass()) {
                iFn2 = this.extensions.getOrDefault(clazz2, iFn);
                if (iFn2 != iFn) continue;
                Class<?>[] classArray = clazz2.getInterfaces();
                int n = classArray.length;
                for (int i = 0; i < n && iFn2 == iFn; ++i) {
                    iFn2 = this.extensions.getOrDefault(classArray[i], iFn);
                }
            }
        }
        finally {
            this.extLock.unlock();
        }
        if (iFn2 != iFn) {
            this.lookupCache.put(clazz, iFn2);
        }
        return iFn2 == iFn ? null : iFn2;
    }
}

