/*
 * Decompiled with CFR 0.152.
 */
package ham_fisted;

import clojure.lang.IFn;
import clojure.lang.IPersistentMap;
import clojure.lang.ISeq;
import clojure.lang.RT;
import clojure.lang.Reduced;
import clojure.lang.Util;
import ham_fisted.ArrayLists;
import ham_fisted.Casts;
import ham_fisted.ChunkedList;
import ham_fisted.DoubleMutList;
import ham_fisted.IFnDef;
import ham_fisted.IMutList;
import ham_fisted.LongMutList;
import ham_fisted.ParallelOptions;
import ham_fisted.Reductions;
import ham_fisted.Transformables;
import ham_fisted.TypedList;

public class Ranges {

    public static class DoubleRange
    implements DoubleMutList,
    TypedList {
        public final double start;
        public final double end;
        public final double step;
        public final long nElems;
        public final IPersistentMap meta;
        int _hash = 0;

        public DoubleRange(double d, double d2, double d3, IPersistentMap iPersistentMap) {
            this.start = d;
            this.end = d2;
            this.step = d3;
            this.meta = iPersistentMap;
            this.nElems = Math.max(0L, (long)((d2 - d) / d3));
            if (this.nElems < 0L) {
                throw new IndexOutOfBoundsException("Invalid Range - start: " + String.valueOf(d) + " end: " + String.valueOf(d2) + " step: " + String.valueOf(d3));
            }
        }

        @Override
        public IMutList cloneList() {
            return this;
        }

        @Override
        public boolean equals(Object object) {
            return this.equiv(object);
        }

        @Override
        public int hashCode() {
            return this.hasheq();
        }

        @Override
        public int hasheq() {
            if (this._hash == 0) {
                this._hash = DoubleMutList.super.hasheq();
            }
            return this._hash;
        }

        public String toString() {
            return Transformables.sequenceToString(this);
        }

        @Override
        public Class containedType() {
            return Double.TYPE;
        }

        @Override
        public int size() {
            return RT.intCast((long)this.nElems);
        }

        public double lgetDouble(long l) {
            long l2 = this.nElems;
            if (l < 0L) {
                l += l2;
            }
            if (l < 0L || l >= l2) {
                throw new IndexOutOfBoundsException("Index out of range: " + String.valueOf(l) + " size: " + String.valueOf(l2));
            }
            return this.start + this.step * (double)l;
        }

        @Override
        public ISeq seq() {
            return new IMutList.SublistSeq(this, 0, null);
        }

        @Override
        public double getDouble(int n) {
            return this.lgetDouble(n);
        }

        @Override
        public int[] toIntArray() {
            int n = RT.intCast((double)this.step);
            if (n != 0) {
                return ArrayLists.iarange(RT.intCast((double)this.start), RT.intCast((double)this.end), RT.intCast((double)this.step));
            }
            throw new IndexOutOfBoundsException("Infinite range: " + String.valueOf(this.step) + " : " + String.valueOf(n));
        }

        @Override
        public long[] toLongArray() {
            long l = Casts.longCast(this.step);
            if (l != 0L) {
                return ArrayLists.larange(Casts.longCast(this.start), Casts.longCast(this.end), Casts.longCast(this.step));
            }
            throw new IndexOutOfBoundsException("Infinite range: " + String.valueOf(this.step) + " : " + String.valueOf(l));
        }

        @Override
        public double[] toDoubleArray() {
            return ArrayLists.darange(this.start, this.end, this.step);
        }

        public DoubleMutList subList(long l, long l2) {
            ChunkedList.sublistCheck(l, l2, this.size());
            return new DoubleRange(this.start + (double)l * this.step, this.start + (double)l2 * this.step, this.step, this.meta);
        }

        @Override
        public DoubleMutList subList(int n, int n2) {
            return this.subList((long)n, (long)n2);
        }

        @Override
        public Object reduce(final IFn iFn, Object object) {
            IFn.ODO oDO = iFn instanceof IFn.ODO ? (IFn.ODO)iFn : new IFn.ODO(){

                public Object invokePrim(Object object, double d) {
                    return iFn.invoke(object, (Object)d);
                }
            };
            return this.doubleReduction(oDO, object);
        }

        @Override
        public Object doubleReduction(IFn.ODO oDO, Object object) {
            long l = this.nElems;
            double d = this.step;
            double d2 = this.start;
            for (long i = 0L; i < l && !RT.isReduced((Object)object); ++i) {
                object = oDO.invokePrim(object, d2 + d * (double)i);
            }
            return Reductions.unreduce(object);
        }

        @Override
        public Object parallelReduction(final IFn iFn, final IFn iFn2, IFn iFn3, ParallelOptions parallelOptions) {
            if (this.nElems > parallelOptions.minN) {
                return Reductions.parallelIndexGroupReduce(new IFnDef.LLO(){

                    public Object invokePrim(long l, long l2) {
                        return Reductions.serialReduction(iFn2, iFn.invoke(), this.subList(l, l2));
                    }
                }, this.nElems, iFn3, parallelOptions);
            }
            return Reductions.serialReduction(iFn2, iFn.invoke(), this);
        }

        public Object lnth(long l) {
            long l2 = this.nElems;
            if (l < 0L) {
                l += l2;
            }
            return this.lgetDouble(l);
        }

        public Object lnth(long l, Object object) {
            long l2 = this.nElems;
            if (l < 0L) {
                l += l2;
            }
            return l < l2 && l > -1L ? Double.valueOf(this.lgetDouble(l)) : object;
        }

        @Override
        public Object invoke(Object object) {
            return this.lnth(Casts.longCast(object));
        }

        @Override
        public Object invoke(Object object, Object object2) {
            if (Util.isInteger((Object)object)) {
                return this.lnth(Casts.longCast(object), object2);
            }
            return object2;
        }

        @Override
        public IPersistentMap meta() {
            return this.meta;
        }

        @Override
        public DoubleRange withMeta(IPersistentMap iPersistentMap) {
            return new DoubleRange(this.start, this.end, this.step, iPersistentMap);
        }
    }

    public static class LongRange
    implements LongMutList,
    TypedList {
        public final long start;
        public final long end;
        public final long step;
        public final long nElems;
        public final IPersistentMap meta;
        int _hash = 0;

        public LongRange(long l, long l2, long l3, IPersistentMap iPersistentMap) {
            this.start = l;
            this.end = l2;
            this.step = l3;
            this.nElems = (l2 - l) / l3;
            if (this.nElems < 0L) {
                throw new RuntimeException("Invalid Range - start: " + String.valueOf(l) + " end: " + String.valueOf(l2) + " step: " + String.valueOf(l3));
            }
            this.meta = iPersistentMap;
        }

        @Override
        public IMutList cloneList() {
            return this;
        }

        @Override
        public boolean equals(Object object) {
            return this.equiv(object);
        }

        @Override
        public int hashCode() {
            return this.hasheq();
        }

        @Override
        public int hasheq() {
            if (this._hash == 0) {
                this._hash = LongMutList.super.hasheq();
            }
            return this._hash;
        }

        public String toString() {
            return Transformables.sequenceToString(this);
        }

        @Override
        public Class containedType() {
            return Long.TYPE;
        }

        @Override
        public int size() {
            return RT.intCast((long)this.nElems);
        }

        public long lgetLong(long l) {
            long l2 = this.nElems;
            if (l < 0L || l >= l2) {
                throw new IndexOutOfBoundsException("Index out of range: " + String.valueOf(l) + " size: " + String.valueOf(l2));
            }
            return this.start + this.step * l;
        }

        @Override
        public long getLong(int n) {
            return this.lgetLong(n);
        }

        @Override
        public int[] toIntArray() {
            return ArrayLists.iarange(RT.intCast((long)this.start), RT.intCast((long)this.end), RT.intCast((long)this.step));
        }

        @Override
        public long[] toLongArray() {
            return ArrayLists.larange(this.start, this.end, this.step);
        }

        @Override
        public double[] toDoubleArray() {
            return ArrayLists.darange(this.start, this.end, this.step);
        }

        @Override
        public Object[] toArray() {
            int n = this.size();
            Object[] objectArray = new Object[n];
            long l = this.start;
            long l2 = this.step;
            int n2 = 0;
            while (n2 < n) {
                objectArray[n2] = l;
                ++n2;
                l += l2;
            }
            return objectArray;
        }

        public LongMutList subList(long l, long l2) {
            ChunkedList.sublistCheck(l, l2, this.nElems);
            return new LongRange(this.start + l * this.step, this.start + l2 * this.step, this.step, this.meta);
        }

        @Override
        public ISeq seq() {
            return new IMutList.SublistSeq(this, 0, null);
        }

        @Override
        public LongMutList subList(int n, int n2) {
            return this.subList((long)n, (long)n2);
        }

        @Override
        public Object reduce(IFn iFn, Object object) {
            if (this.nElems == 0L) {
                return object;
            }
            Object object2 = object;
            long l = this.nElems;
            long l2 = this.start;
            if (!(iFn instanceof IFn.OLO)) {
                do {
                    if (RT.isReduced((Object)(object2 = iFn.invoke(object2, (Object)l2)))) {
                        return ((Reduced)object2).deref();
                    }
                    l2 += this.step;
                } while (--l > 0L);
            } else {
                IFn.OLO oLO = (IFn.OLO)iFn;
                do {
                    if (RT.isReduced((Object)(object2 = oLO.invokePrim(object2, l2)))) {
                        return ((Reduced)object2).deref();
                    }
                    l2 += this.step;
                } while (--l > 0L);
            }
            return object2;
        }

        @Override
        public Object parallelReduction(final IFn iFn, final IFn iFn2, IFn iFn3, ParallelOptions parallelOptions) {
            return Reductions.parallelIndexGroupReduce(new IFnDef.LLO(){

                public Object invokePrim(long l, long l2) {
                    return Reductions.serialReduction(iFn2, iFn.invoke(), this.subList(l, l2));
                }
            }, this.nElems, iFn3, parallelOptions);
        }

        public Object lnth(long l) {
            long l2 = this.nElems;
            if (l < 0L) {
                l += l2;
            }
            return this.lgetLong(l);
        }

        public Object lnth(long l, Object object) {
            long l2 = this.nElems;
            if (l < 0L) {
                l += l2;
            }
            return l < l2 && l > -1L ? Long.valueOf(this.lgetLong(l)) : object;
        }

        @Override
        public Object invoke(Object object) {
            return this.lnth(Casts.longCast(object));
        }

        @Override
        public Object invoke(Object object, Object object2) {
            if (Util.isInteger((Object)object)) {
                return this.lnth(Casts.longCast(object), object2);
            }
            return object2;
        }

        @Override
        public IPersistentMap meta() {
            return this.meta;
        }

        @Override
        public LongRange withMeta(IPersistentMap iPersistentMap) {
            return new LongRange(this.start, this.end, this.step, iPersistentMap);
        }
    }
}

