/*
 * Decompiled with CFR 0.152.
 */
package ham_fisted;

import clojure.lang.IDeref;
import clojure.lang.IFn;
import clojure.lang.IKVReduce;
import clojure.lang.IMapEntry;
import clojure.lang.IPersistentMap;
import clojure.lang.IReduceInit;
import clojure.lang.MapEntry;
import clojure.lang.RT;
import ham_fisted.CljHash;
import ham_fisted.HashBase;
import ham_fisted.HashNode;
import ham_fisted.HashSet;
import ham_fisted.IFnDef;
import ham_fisted.IMap;
import ham_fisted.MapSetOps;
import ham_fisted.ParallelOptions;
import ham_fisted.PersistentHashSet;
import ham_fisted.Reductions;
import ham_fisted.SetOps;
import ham_fisted.UpdateValues;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Spliterator;
import java.util.function.BiFunction;
import java.util.function.Function;

public class HashMap
extends HashBase
implements IMap,
MapSetOps,
UpdateValues {
    Set keySet;

    public HashMap(float f, int n, int n2, HashNode[] hashNodeArray, IPersistentMap iPersistentMap) {
        super(f, n, n2, hashNodeArray, iPersistentMap);
    }

    public HashMap() {
        this(0.75f, 0, 0, null, null);
    }

    public HashMap(IPersistentMap iPersistentMap) {
        this(0.75f, 0, 0, null, iPersistentMap);
    }

    public HashMap(HashMap hashMap, IPersistentMap iPersistentMap) {
        super(hashMap, iPersistentMap);
    }

    public HashMap shallowClone() {
        return new HashMap(this.loadFactor, this.capacity, this.length, (HashNode[])this.data.clone(), this.meta);
    }

    public HashMap clone() {
        int n = this.data.length;
        HashNode[] hashNodeArray = new HashNode[n];
        HashMap hashMap = new HashMap(this.loadFactor, this.capacity, this.length, hashNodeArray, this.meta);
        for (int i = 0; i < n; ++i) {
            HashNode hashNode = this.data[i];
            if (hashNode == null) continue;
            hashNodeArray[i] = hashNode.clone(hashMap);
        }
        return hashMap;
    }

    @Override
    public int hashCode() {
        return this.hasheq();
    }

    public int hasheq() {
        return CljHash.mapHashcode(this);
    }

    @Override
    public boolean equals(Object object) {
        return this.equiv(object);
    }

    public boolean equiv(Object object) {
        return CljHash.mapEquiv(this, object);
    }

    @Override
    public int size() {
        return this.length;
    }

    @Override
    public boolean isEmpty() {
        return this.length == 0;
    }

    public String toString() {
        StringBuilder stringBuilder = (StringBuilder)this.reduce(new IFnDef(){

            @Override
            public Object invoke(Object object, Object object2) {
                StringBuilder stringBuilder = (StringBuilder)object;
                Map.Entry entry = (Map.Entry)object2;
                if (stringBuilder.length() > 2) {
                    stringBuilder.append(",");
                }
                return stringBuilder.append(entry.getKey()).append(" ").append(entry.getValue());
            }
        }, new StringBuilder().append("{"));
        return stringBuilder.append("}").toString();
    }

    public Object put(Object object, Object object2) {
        HashNode hashNode;
        int n = this.hash(object);
        int n2 = n & this.mask;
        HashNode hashNode2 = this.data[n2];
        if (hashNode2 != null) {
            hashNode = hashNode2;
            do {
                if (hashNode.k != object && !this.equals(hashNode.k, object)) continue;
                Object object3 = hashNode.v;
                hashNode.v = object2;
                this.modify(hashNode);
                return object3;
            } while ((hashNode = hashNode.nextNode) != null);
        }
        hashNode = this.newNode(object, n, object2);
        hashNode.nextNode = hashNode2;
        this.data[n2] = hashNode;
        return this.checkResize(null);
    }

    @Override
    public void putAll(Map map) {
        HashNode[] hashNodeArray = this.data;
        int n = this.mask;
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry;
            Map.Entry entry2 = entry = iterator.next();
            Object k = entry2.getKey();
            int n2 = this.hash(k);
            int n3 = n2 & n;
            HashNode hashNode = hashNodeArray[n3];
            while (hashNode != null && k != hashNode.k && !this.equals(k, hashNode.k)) {
                hashNode = hashNode.nextNode;
            }
            if (hashNode != null) {
                hashNode.v = entry2.getValue();
                continue;
            }
            HashNode hashNode2 = this.newNode(k, n2, entry2.getValue());
            hashNode2.nextNode = hashNodeArray[n3];
            hashNodeArray[n3] = hashNode2;
            this.checkResize(null);
            hashNodeArray = this.data;
            n = this.mask;
        }
    }

    public Object getOrDefault(Object object, Object object2) {
        HashNode hashNode = this.data[this.hash(object) & this.mask];
        while (hashNode != null) {
            Object object3 = hashNode.k;
            if (object3 == object || this.equals(object3, object)) {
                return hashNode.v;
            }
            hashNode = hashNode.nextNode;
        }
        return object2;
    }

    public Object get(Object object) {
        HashNode hashNode = this.data[this.hash(object) & this.mask];
        while (hashNode != null) {
            Object object2 = hashNode.k;
            if (object2 == object || this.equals(object2, object)) {
                return hashNode.v;
            }
            hashNode = hashNode.nextNode;
        }
        return null;
    }

    public IMapEntry entryAt(Object object) {
        HashNode hashNode = this.data[this.hash(object) & this.mask];
        while (hashNode != null) {
            Object object2 = hashNode.k;
            if (object2 == object || this.equals(object2, object)) {
                return MapEntry.create((Object)hashNode.k, (Object)hashNode.v);
            }
            hashNode = hashNode.nextNode;
        }
        return null;
    }

    @Override
    public boolean containsKey(Object object) {
        return this.containsNodeKey(object);
    }

    public Object compute(Object object, BiFunction biFunction) {
        int n = this.hash(object);
        HashNode[] hashNodeArray = this.data;
        int n2 = n & this.mask;
        HashNode hashNode = hashNodeArray[n2];
        HashNode hashNode2 = null;
        while (hashNode != null && hashNode.k != object && !this.equals(hashNode.k, object)) {
            hashNode2 = hashNode;
            hashNode = hashNode.nextNode;
        }
        Object r = biFunction.apply(object, hashNode == null ? null : hashNode.v);
        if (hashNode != null) {
            if (r != null) {
                hashNode.v = r;
                this.modify(hashNode);
            } else {
                this.remove(object, null);
            }
        } else if (r != null) {
            HashNode hashNode3 = this.newNode(object, n, r);
            if (hashNode2 != null) {
                hashNode2.nextNode = hashNode3;
            } else {
                hashNodeArray[n2] = hashNode3;
            }
            this.checkResize(null);
        }
        return r;
    }

    public Object computeIfAbsent(Object object, Function function) {
        int n = this.hash(object);
        HashNode[] hashNodeArray = this.data;
        int n2 = n & this.mask;
        HashNode hashNode = hashNodeArray[n2];
        HashNode hashNode2 = null;
        while (hashNode != null && hashNode.k != object && !this.equals(hashNode.k, object)) {
            hashNode2 = hashNode;
            hashNode = hashNode.nextNode;
        }
        if (hashNode != null) {
            return hashNode.v;
        }
        Object r = function.apply(object);
        if (r != null) {
            HashNode hashNode3 = this.newNode(object, n, r);
            if (hashNode2 != null) {
                hashNode2.nextNode = hashNode3;
            } else {
                hashNodeArray[n2] = hashNode3;
            }
            this.checkResize(null);
        }
        return r;
    }

    public Object remove(Object object) {
        HashNode hashNode = null;
        int n = this.hash(object) & this.mask;
        HashNode hashNode2 = this.data[n];
        while (hashNode2 != null) {
            Object object2 = hashNode2.k;
            if (object2 == object || this.equals(object2, object)) {
                this.dec(hashNode2);
                if (hashNode != null) {
                    hashNode.nextNode = hashNode2.nextNode;
                } else {
                    this.data[n] = hashNode2.nextNode;
                }
                return hashNode2.getValue();
            }
            hashNode = hashNode2;
            hashNode2 = hashNode2.nextNode;
        }
        return null;
    }

    public Object reduce(IFn iFn, Object object) {
        int n = this.data.length;
        HashNode[] hashNodeArray = this.data;
        for (int i = 0; i < n; ++i) {
            HashNode hashNode = hashNodeArray[i];
            while (hashNode != null) {
                if (RT.isReduced((Object)(object = iFn.invoke(object, (Object)hashNode)))) {
                    return ((IDeref)object).deref();
                }
                hashNode = hashNode.nextNode;
            }
        }
        return object;
    }

    @Override
    public Object kvreduce(IFn iFn, Object object) {
        int n = this.data.length;
        HashNode[] hashNodeArray = this.data;
        for (int i = 0; i < n; ++i) {
            HashNode hashNode = hashNodeArray[i];
            while (hashNode != null) {
                if (RT.isReduced((Object)(object = iFn.invoke(object, hashNode.k, hashNode.v)))) {
                    return ((IDeref)object).deref();
                }
                hashNode = hashNode.nextNode;
            }
        }
        return object;
    }

    @Override
    public Object parallelReduction(IFn iFn, IFn iFn2, IFn iFn3, ParallelOptions parallelOptions) {
        return Reductions.parallelCollectionReduction(iFn, iFn2, iFn3, this.entrySet(), parallelOptions);
    }

    public void replaceAll(BiFunction biFunction) {
        int n = this.data.length;
        for (int i = 0; i < n; ++i) {
            HashNode hashNode = null;
            HashNode hashNode2 = this.data[i];
            while (hashNode2 != null) {
                Object r = biFunction.apply(hashNode2.k, hashNode2.v);
                if (r != null) {
                    hashNode2.v = r;
                    hashNode = hashNode2;
                } else {
                    this.dec(hashNode2);
                    if (hashNode != null) {
                        hashNode.nextNode = hashNode2.nextNode;
                    } else {
                        this.data[i] = hashNode2.nextNode;
                    }
                }
                hashNode2 = hashNode2.nextNode;
            }
        }
    }

    @Override
    public Set keySet() {
        if (this.keySet == null) {
            this.keySet = new HashSetKeySet(this);
        }
        return this.keySet;
    }

    public static HashMap hashMapUnion(HashMap hashMap, HashMap hashMap2, BiFunction biFunction) {
        HashNode[] hashNodeArray = hashMap2.data;
        int n = hashNodeArray.length;
        HashNode[] hashNodeArray2 = hashMap.data;
        int n2 = hashMap.mask;
        for (int i = 0; i < n; ++i) {
            HashNode hashNode = hashNodeArray[i];
            while (hashNode != null) {
                HashNode hashNode2;
                Object object = hashNode.k;
                int n3 = hashNode.hashcode;
                int n4 = n3 & n2;
                HashNode hashNode3 = hashNode2 = hashNodeArray2[n4];
                Object object2 = hashNode.v;
                while (hashNode3 != null && hashNode3.k != object && !hashMap.equals(hashNode3.k, object)) {
                    hashNode3 = hashNode3.nextNode;
                }
                if (hashNode3 != null) {
                    hashNodeArray2[n4] = hashNode2.assoc(hashMap, hashNode3.k, n3, biFunction.apply(hashNode3.v, object2));
                } else {
                    hashNodeArray2[n4] = hashNode2 != null ? hashNode2.assoc(hashMap, object, n3, object2) : hashMap.newNode(object, n3, object2);
                    hashMap.checkResize(null);
                    n2 = hashMap.mask;
                    hashNodeArray2 = hashMap.data;
                }
                hashNode = hashNode.nextNode;
            }
        }
        return hashMap;
    }

    public static HashMap reduceUnion(final HashMap hashMap, IReduceInit iReduceInit, final BiFunction biFunction) {
        return (HashMap)iReduceInit.reduce((IFn)new IFnDef(){

            @Override
            public Object invoke(Object object, Object object2) {
                HashNode hashNode;
                Map.Entry entry = (Map.Entry)object2;
                Object k = entry.getKey();
                int n = hashMap.hash(k);
                int n2 = n & hashMap.mask;
                HashNode[] hashNodeArray = hashMap.data;
                HashNode hashNode2 = hashNode = hashNodeArray[n2];
                while (hashNode2 != null && hashNode2.k != k && !hashMap.equals(hashNode2.k, k)) {
                    hashNode2 = hashNode2.nextNode;
                }
                if (hashNode2 != null) {
                    hashNodeArray[n2] = hashNode.assoc(hashMap, hashNode2.k, n, biFunction.apply(hashNode2.v, entry.getValue()));
                } else {
                    hashNodeArray[n2] = hashNode != null ? hashNode.assoc(hashMap, k, n, entry.getValue()) : hashMap.newNode(k, n, entry.getValue());
                    hashMap.checkResize(null);
                }
                return hashMap;
            }
        }, (Object)hashMap);
    }

    public static HashMap kvReduceUnion(final HashMap hashMap, IKVReduce iKVReduce, final BiFunction biFunction) {
        return (HashMap)iKVReduce.kvreduce((IFn)new IFnDef(){

            @Override
            public Object invoke(Object object, Object object2, Object object3) {
                HashNode hashNode;
                int n = hashMap.hash(object2);
                int n2 = n & hashMap.mask;
                HashNode[] hashNodeArray = hashMap.data;
                HashNode hashNode2 = hashNode = hashNodeArray[n2];
                while (hashNode2 != null && hashNode2.k != object2 && !hashMap.equals(hashNode2.k, object2)) {
                    hashNode2 = hashNode2.nextNode;
                }
                if (hashNode2 != null) {
                    hashNodeArray[n2] = hashNode.assoc(hashMap, hashNode2.k, n, biFunction.apply(hashNode2.v, object3));
                } else {
                    hashNodeArray[n2] = hashNode != null ? hashNode.assoc(hashMap, object2, n, object3) : hashMap.newNode(object2, n, object3);
                    hashMap.checkResize(null);
                }
                return hashMap;
            }
        }, (Object)hashMap);
    }

    public static HashMap entrySetUnion(HashMap hashMap, Map map, BiFunction biFunction) {
        int n = hashMap.mask;
        HashNode[] hashNodeArray = hashMap.data;
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            HashNode hashNode;
            Map.Entry entry;
            Map.Entry entry2 = entry = iterator.next();
            Object k = entry2.getKey();
            int n2 = hashMap.hash(k);
            int n3 = n2 & n;
            HashNode hashNode2 = hashNode = hashNodeArray[n3];
            while (hashNode2 != null && hashNode2.k != k && !hashMap.equals(hashNode2.k, k)) {
                hashNode2 = hashNode2.nextNode;
            }
            if (hashNode2 != null) {
                hashNodeArray[n3] = hashNode.assoc(hashMap, hashNode2.k, n2, biFunction.apply(hashNode2.v, entry2.getValue()));
                continue;
            }
            hashNodeArray[n3] = hashNode != null ? hashNode.assoc(hashMap, k, n2, entry2.getValue()) : hashMap.newNode(k, n2, entry2.getValue());
            hashMap.checkResize(null);
            n = hashMap.mask;
            hashNodeArray = hashMap.data;
        }
        return hashMap;
    }

    public static HashMap union(HashMap hashMap, Map map, BiFunction biFunction) {
        if (map instanceof HashMap) {
            return HashMap.hashMapUnion(hashMap, (HashMap)map, biFunction);
        }
        if (map instanceof IReduceInit) {
            return HashMap.reduceUnion(hashMap, (IReduceInit)map, biFunction);
        }
        if (map instanceof IKVReduce) {
            return HashMap.kvReduceUnion(hashMap, (IKVReduce)map, biFunction);
        }
        return HashMap.entrySetUnion(hashMap, map, biFunction);
    }

    @Override
    public HashMap union(Map map, BiFunction biFunction) {
        return HashMap.union(this, map, biFunction);
    }

    static HashMap intersection(HashMap hashMap, Map map, BiFunction biFunction) {
        HashNode[] hashNodeArray = hashMap.data;
        int n = hashNodeArray.length;
        for (int i = 0; i < n; ++i) {
            HashNode hashNode = hashNodeArray[i];
            while (hashNode != null) {
                HashNode hashNode2 = hashNode;
                hashNode = hashNode.nextNode;
                Object v = map.get(hashNode2.k);
                hashNodeArray[i] = v != null ? hashNodeArray[i].assoc(hashMap, hashNode2.k, hashNode2.hashcode, biFunction.apply(hashNode2.v, v)) : hashNodeArray[i].dissoc(hashMap, hashNode2.k);
            }
        }
        return hashMap;
    }

    @Override
    public HashMap intersection(Map map, BiFunction biFunction) {
        return HashMap.intersection(this, map, biFunction);
    }

    public static HashMap intersection(HashMap hashMap, Set set) {
        HashNode[] hashNodeArray = hashMap.data;
        int n = hashNodeArray.length;
        for (int i = 0; i < n; ++i) {
            HashNode hashNode = hashNodeArray[i];
            while (hashNode != null) {
                HashNode hashNode2 = hashNode;
                Object object = hashNode2.k;
                hashNode = hashNode.nextNode;
                if (set.contains(object)) continue;
                hashNodeArray[i] = hashNodeArray[i].dissoc(hashMap, object);
            }
        }
        return hashMap;
    }

    @Override
    public HashMap intersection(Set set) {
        return HashMap.intersection(this, set);
    }

    static HashMap difference(HashMap hashMap, Collection collection) {
        HashNode[] hashNodeArray = hashMap.data;
        int n = hashMap.mask;
        for (Object e : collection) {
            int n2 = hashMap.hash(e);
            int n3 = n2 & n;
            HashNode hashNode = hashNodeArray[n3];
            while (hashNode != null && hashNode.k != e && !hashMap.equals(hashNode.k, e)) {
                hashNode = hashNode.nextNode;
            }
            if (hashNode == null) continue;
            hashNodeArray[n3] = hashNodeArray[n3].dissoc(hashMap, hashNode.k);
        }
        return hashMap;
    }

    @Override
    public HashMap difference(Collection collection) {
        return HashMap.difference(this, collection);
    }

    static HashMap updateValues(HashMap hashMap, BiFunction biFunction) {
        HashNode[] hashNodeArray = hashMap.data;
        int n = hashNodeArray.length;
        for (int i = 0; i < n; ++i) {
            HashNode hashNode = hashNodeArray[i];
            while (hashNode != null) {
                HashNode hashNode2 = hashNode;
                hashNode = hashNode.nextNode;
                Object r = biFunction.apply(hashNode2.k, hashNode2.v);
                hashNodeArray[i] = r == null ? hashNodeArray[i].dissoc(hashMap, hashNode2.k) : hashNodeArray[i].assoc(hashMap, hashNode2.k, hashNode2.hashcode, r);
            }
        }
        return hashMap;
    }

    @Override
    public HashMap updateValues(BiFunction biFunction) {
        return HashMap.updateValues(this, biFunction);
    }

    static HashMap updateValue(HashMap hashMap, Object object, Function function) {
        int n = hashMap.hash(object);
        int n2 = n & hashMap.mask;
        HashNode[] hashNodeArray = hashMap.data;
        HashNode hashNode = hashNodeArray[n2];
        while (hashNode != null && hashNode.k != object && !hashMap.equals(hashNode.k, object)) {
            hashNode = hashNode.nextNode;
        }
        Object r = hashNode != null ? function.apply(hashNode.v) : function.apply(null);
        HashNode hashNode2 = hashNodeArray[n2] = r == null ? hashNodeArray[n2].dissoc(hashMap, object) : hashNodeArray[n2].assoc(hashMap, object, n, r);
        if (r != null && hashNode == null) {
            hashMap.checkResize(null);
        }
        return hashMap;
    }

    @Override
    public HashMap updateValue(Object object, Function function) {
        return this.updateValue(this, function);
    }

    @Override
    public Iterator iterator(Function<Map.Entry, Object> function) {
        return new HashBase.HTIter(this.data, function);
    }

    @Override
    public Spliterator spliterator(Function<Map.Entry, Object> function) {
        return new HashBase.HTSpliterator(this.data, this.length, function);
    }

    public static class HashSetKeySet
    extends IMap.MapKeySet
    implements SetOps {
        public HashSetKeySet(HashMap hashMap) {
            super(hashMap);
        }

        @Override
        public PersistentHashSet union(Collection collection) {
            return new PersistentHashSet(new HashSet(((HashMap)this.data).shallowClone()).union(collection));
        }

        @Override
        public PersistentHashSet intersection(Set set) {
            return new PersistentHashSet(new HashSet(((HashMap)this.data).shallowClone()).intersection(set));
        }

        @Override
        public PersistentHashSet difference(Set set) {
            return new PersistentHashSet(new HashSet(((HashMap)this.data).shallowClone()).difference(set));
        }
    }
}

