/*
 * Decompiled with CFR 0.152.
 */
package ham_fisted;

import clojure.lang.IFn;
import clojure.lang.IObj;
import clojure.lang.IPersistentMap;
import clojure.lang.IReduceInit;
import clojure.lang.RT;
import ham_fisted.BitmapTrieCommon;
import ham_fisted.FMapEntry;
import ham_fisted.IFnDef;
import ham_fisted.ITypedReduce;
import ham_fisted.IntegerOps;
import ham_fisted.LeafNode;
import ham_fisted.MapData;
import ham_fisted.ParallelOptions;
import ham_fisted.Reductions;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Spliterator;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;

class BitmapTrie
implements IObj,
BitmapTrieCommon.TrieBase,
MapData {
    protected final BitmapTrieCommon.HashProvider hp;
    protected int count;
    protected BitmapNode root;
    protected LeafNode nullEntry;
    protected final IPersistentMap meta;

    public BitmapTrie(BitmapTrieCommon.HashProvider hashProvider, int n, BitmapNode bitmapNode, LeafNode leafNode, IPersistentMap iPersistentMap) {
        this.hp = hashProvider;
        this.count = n;
        this.root = bitmapNode;
        this.nullEntry = leafNode;
        this.meta = iPersistentMap;
    }

    public BitmapTrie(BitmapTrieCommon.HashProvider hashProvider, IPersistentMap iPersistentMap, int n) {
        this.count = 0;
        this.nullEntry = null;
        this.root = new BitmapNode(this, 0, 0, new BitmapTrieCommon.INode[Math.max(32, IntegerOps.nextPow2(n))]);
        this.hp = hashProvider;
        this.meta = iPersistentMap;
    }

    public BitmapTrie(BitmapTrieCommon.HashProvider hashProvider, IPersistentMap iPersistentMap) {
        this(hashProvider, iPersistentMap, 4);
    }

    public BitmapTrie(BitmapTrieCommon.HashProvider hashProvider) {
        this.count = 0;
        this.nullEntry = null;
        this.root = new BitmapNode(this, 0, 0, new BitmapTrieCommon.INode[4]);
        this.hp = hashProvider;
        this.meta = null;
    }

    public BitmapTrie(BitmapTrieCommon.HashProvider hashProvider, IPersistentMap iPersistentMap, Object object, Object object2) {
        this.hp = hashProvider;
        this.meta = iPersistentMap;
        LeafNode leafNode = new LeafNode(this, object, hashProvider.hash(object), object2);
        if (object == null) {
            this.nullEntry = leafNode;
            this.root = new BitmapNode(this, 0, 0, new BitmapTrieCommon.INode[4]);
        } else {
            this.nullEntry = null;
            this.root = new BitmapNode((BitmapTrieCommon.TrieBase)this, 0, leafNode);
        }
    }

    public BitmapTrie() {
        this(BitmapTrieCommon.defaultHashProvider);
    }

    BitmapTrie(BitmapTrie bitmapTrie, boolean bl) {
        this.hp = bitmapTrie.hp;
        this.count = bitmapTrie.count;
        this.root = bitmapTrie.root;
        this.nullEntry = bitmapTrie.nullEntry;
        this.meta = bitmapTrie.meta;
    }

    public BitmapTrie(BitmapTrie bitmapTrie) {
        this.hp = bitmapTrie.hp;
        this.count = 0;
        this.nullEntry = this.nullEntry != null ? bitmapTrie.nullEntry.clone(this) : null;
        this.root = bitmapTrie.root != null ? bitmapTrie.root.clone(this) : null;
        this.meta = bitmapTrie.meta;
    }

    public BitmapTrie(BitmapTrie bitmapTrie, Iterator iterator) {
        this.hp = bitmapTrie.hp;
        this.count = 0;
        this.nullEntry = this.nullEntry != null ? bitmapTrie.nullEntry.valueClone(this, iterator) : null;
        this.root = bitmapTrie.root != null ? bitmapTrie.root.valueClone(this, iterator) : null;
        this.meta = bitmapTrie.meta;
    }

    @Override
    public BitmapTrieCommon.HashProvider hashProvider() {
        return this.hp;
    }

    BitmapTrie shallowClone(IPersistentMap iPersistentMap) {
        return new BitmapTrie(this, true);
    }

    @Override
    public BitmapTrie shallowClone() {
        return this.shallowClone(this.meta);
    }

    BitmapTrie deepClone() {
        return new BitmapTrie(this);
    }

    @Override
    public boolean isEmpty() {
        return this.count == 0;
    }

    @Override
    public BitmapTrie clone() {
        return this.deepClone();
    }

    @Override
    public final void inc() {
        ++this.count;
    }

    @Override
    public final void dec() {
        --this.count;
    }

    @Override
    public final int hash(Object object) {
        return this.hp.hash(object);
    }

    @Override
    public final boolean equals(Object object, Object object2) {
        return this.hp.equals(object, object2);
    }

    @Override
    public final int size() {
        if (this.count == -1) {
            int n = this.nullEntry != null ? 1 : 0;
            this.count = n + this.root.countLeaves();
        }
        return this.count;
    }

    @Override
    public final LeafNode getNode(Object object) {
        if (object == null) {
            return this.nullEntry;
        }
        return this.root.get(object, this.hp.hash(object), 0, this.hp);
    }

    public final LeafNode getOrCreate(Object object, int n) {
        if (object == null) {
            if (this.nullEntry == null) {
                this.nullEntry = new LeafNode(this, null, 0);
            }
            return this.nullEntry;
        }
        return this.root.getOrCreate(object, n);
    }

    @Override
    public LeafNode getOrCreate(Object object) {
        return this.getOrCreate(object, this.hp.hash(object));
    }

    @Override
    public void clear() {
        this.count = 0;
        this.nullEntry = null;
        this.root.bitmap = 0;
        this.root.data = new BitmapTrieCommon.INode[4];
    }

    @Override
    public final BitmapTrieCommon.LeafNodeIterator iterator(Function<BitmapTrieCommon.ILeaf, Object> function) {
        return new HTIterator(function, this.nullEntry, this.root.iterator());
    }

    @Override
    public final Spliterator spliterator(Function<BitmapTrieCommon.ILeaf, Object> function) {
        return new TrieSpliterator(this, function);
    }

    final <K, V> Set<Map.Entry<K, V>> entrySet(Map.Entry<K, V> entry, boolean bl) {
        return new EntrySet(bl);
    }

    final <K> Set<K> keySet(K k, boolean bl) {
        return new KeySet(bl);
    }

    final <V> Collection<V> values(V v, boolean bl) {
        return new ValueCollection(bl);
    }

    Object reduceLeaves(IFn iFn, Object object) {
        if (this.nullEntry != null && !RT.isReduced((Object)object)) {
            object = iFn.invoke(object, (Object)this.nullEntry);
        }
        return Reductions.unreduce(this.root != null ? this.root.reduce(iFn, object) : object);
    }

    @Override
    public Object reduce(final Function<BitmapTrieCommon.ILeaf, Object> function, final IFn iFn, Object object) {
        return this.reduceLeaves(new IFnDef(){

            @Override
            public Object invoke(Object object, Object object2) {
                return iFn.invoke(object, function.apply((BitmapTrieCommon.ILeaf)object2));
            }
        }, object);
    }

    public Object reduceEntries(final IFn iFn, Object object) {
        return this.reduceLeaves(new IFnDef(){

            @Override
            public Object invoke(Object object, Object object2) {
                BitmapTrieCommon.ILeaf iLeaf = (BitmapTrieCommon.ILeaf)object2;
                return iFn.invoke(object, new FMapEntry<Object, Object>(iLeaf.key(), iLeaf.val()));
            }
        }, object);
    }

    public Object reduceKeys(final IFn iFn, Object object) {
        return this.reduceLeaves(new IFnDef(){

            @Override
            public Object invoke(Object object, Object object2) {
                BitmapTrieCommon.ILeaf iLeaf = (BitmapTrieCommon.ILeaf)object2;
                return iFn.invoke(object, iLeaf.key());
            }
        }, object);
    }

    public Object reduceValues(final IFn iFn, Object object) {
        return this.reduceLeaves(new IFnDef(){

            @Override
            public Object invoke(Object object, Object object2) {
                BitmapTrieCommon.ILeaf iLeaf = (BitmapTrieCommon.ILeaf)object2;
                return iFn.invoke(object, iLeaf.val());
            }
        }, object);
    }

    @Override
    public boolean containsKey(Object object) {
        return this.getNode(object) != null;
    }

    public boolean containsValue(Object object) {
        HTIterator hTIterator = new HTIterator(BitmapTrieCommon.identityIterFn, this.nullEntry, this.root.iterator());
        while (hTIterator.hasNext()) {
            LeafNode leafNode = (LeafNode)hTIterator.next();
            if (!Objects.equals(leafNode.val(), object)) continue;
            return true;
        }
        return false;
    }

    final BitmapTrie keyspaceSplit(int n, int n2) {
        BitmapTrie bitmapTrie = new BitmapTrie(this.hp);
        bitmapTrie.count = -1;
        int n3 = 0;
        BitmapTrieCommon.INode[] iNodeArray = bitmapTrie.root.data;
        int n4 = this.root.bitmap;
        BitmapTrieCommon.INode[] iNodeArray2 = this.root.data;
        if (n == 0 && this.nullEntry != null) {
            bitmapTrie.nullEntry = this.nullEntry;
        }
        for (int i = n; i < n2; ++i) {
            int n5;
            int n6;
            int n7 = i / 32;
            int n8 = i % 32;
            int n9 = 1 << n7;
            if ((n4 & n9) == 0) continue;
            BitmapTrieCommon.INode iNode = iNodeArray2[IntegerOps.index(n4, n9)];
            if (n8 == 0 && (i + 32 <= n2 || iNode instanceof LeafNode)) {
                n6 = IntegerOps.index(n3 |= n9, n9);
                n5 = Integer.bitCount(n3);
                iNodeArray = BitmapTrieCommon.insert(iNodeArray, iNode, n6, n5, false);
                i += 31;
                continue;
            }
            if (!(iNode instanceof BitmapNode)) continue;
            n6 = Math.min(31 - n8, n2 - i - 1);
            n5 = n8 + n6;
            BitmapNode bitmapNode = ((BitmapNode)iNode).refIndexes(bitmapTrie, n8, n5);
            i += n6;
            if (bitmapNode == null) continue;
            int n10 = IntegerOps.index(n3 |= n9, n9);
            int n11 = Integer.bitCount(n3);
            iNodeArray = BitmapTrieCommon.insert(iNodeArray, bitmapNode, n10, n11, false);
        }
        bitmapTrie.root.bitmap = n3;
        bitmapTrie.root.data = iNodeArray;
        bitmapTrie.count = -1;
        return bitmapTrie;
    }

    final void serialTraversal(Consumer<BitmapTrieCommon.ILeaf> consumer) {
        HTIterator hTIterator = new HTIterator(BitmapTrieCommon.identityIterFn, this.nullEntry, this.root.iterator());
        while (hTIterator.hasNext()) {
            consumer.accept(hTIterator.nextLeaf());
        }
    }

    final void forEach(BiConsumer biConsumer) {
        this.serialTraversal(iLeaf -> biConsumer.accept(iLeaf.key(), iLeaf.val()));
    }

    @Override
    public final void mutUpdateValues(BiFunction biFunction) {
        if (this.nullEntry != null) {
            this.nullEntry = this.nullEntry.immutUpdate(this, biFunction);
        }
        this.root = this.root.immutUpdate(this, biFunction);
    }

    final BitmapTrie immutUpdate(BiFunction biFunction) {
        BitmapTrie bitmapTrie = this.shallowClone();
        bitmapTrie.mutUpdateValues(biFunction);
        return bitmapTrie;
    }

    @Override
    public MapData mutUpdateValue(Object object, IFn iFn) {
        if (object == null) {
            this.nullEntry = this.nullEntry != null ? this.nullEntry.immutUpdate(this, object, 0, iFn) : new LeafNode(this, null, 0, iFn.invoke(null));
        } else {
            this.root = this.root.immutUpdate(this, object, this.hp.hash(object), iFn);
        }
        return this;
    }

    final BitmapTrie immutUpdate(Object object, IFn iFn) {
        BitmapTrie bitmapTrie = this.shallowClone();
        bitmapTrie.mutUpdateValue(object, iFn);
        return bitmapTrie;
    }

    @Override
    public void remove(Object object, BitmapTrieCommon.Box box) {
        if (object == null) {
            if (this.nullEntry != null) {
                if (box != null) {
                    box.obj = this.nullEntry.v;
                }
                this.nullEntry = null;
                this.dec();
            }
        } else {
            this.root.remove(object, this.hp.hash(object), box, false);
        }
    }

    final Object remove(Object object) {
        BitmapTrieCommon.Box box = new BitmapTrieCommon.Box();
        this.remove(object, box);
        return box.obj;
    }

    @Override
    public MapData mutAssoc(Object object, Object object2) {
        if (object == null) {
            this.nullEntry = this.nullEntry == null ? new LeafNode(this, object, 0, object2) : this.nullEntry.assoc(this, object, 0, object2);
        } else {
            this.root = this.root.assoc(this, object, this.hp.hash(object), object2);
        }
        return this;
    }

    final BitmapTrie assoc(Object object, Object object2) {
        this.mutAssoc(object, object2);
        return this;
    }

    @Override
    public BitmapTrie mutDissoc(Object object) {
        if (object == null) {
            if (this.nullEntry != null) {
                this.nullEntry = null;
                this.dec();
            }
        } else {
            this.root = (BitmapNode)this.root.dissoc(this, object, this.hp.hash(object), false);
        }
        return this;
    }

    final BitmapTrie dissoc(Object object) {
        this.mutDissoc(object);
        return this;
    }

    final BitmapTrie union(BitmapTrie bitmapTrie, BiFunction biFunction, boolean bl) {
        BitmapTrie bitmapTrie2;
        BitmapTrie bitmapTrie3 = bitmapTrie2 = bl ? this : this.shallowClone();
        if (bitmapTrie.nullEntry != null) {
            bitmapTrie2.nullEntry = this.nullEntry != null ? new LeafNode(bitmapTrie2, null, 0, biFunction.apply(this.nullEntry.val(), bitmapTrie.nullEntry.val())) : bitmapTrie.nullEntry;
        } else if (this.nullEntry != null) {
            bitmapTrie2.nullEntry = this.nullEntry;
        }
        bitmapTrie2.root = bitmapTrie2.root.union(bitmapTrie2, bitmapTrie.root, biFunction);
        bitmapTrie2.count = -1;
        return bitmapTrie2;
    }

    final BitmapTrie union(BitmapTrie bitmapTrie, BiFunction biFunction) {
        return this.union(bitmapTrie, biFunction, false);
    }

    final BitmapTrie difference(BitmapTrie bitmapTrie) {
        BitmapTrie bitmapTrie2 = this.shallowClone();
        if (this.nullEntry != null && bitmapTrie.nullEntry != null) {
            bitmapTrie2.nullEntry = null;
        }
        bitmapTrie2.root = (BitmapNode)bitmapTrie2.root.difference(bitmapTrie2, bitmapTrie.root, false);
        bitmapTrie2.count = -1;
        return bitmapTrie2;
    }

    final BitmapTrie intersection(BitmapTrie bitmapTrie, BiFunction biFunction) {
        BitmapTrie bitmapTrie2 = this.shallowClone();
        bitmapTrie2.count = 0;
        if (this.nullEntry != null && bitmapTrie.nullEntry != null) {
            bitmapTrie2.nullEntry = new LeafNode(bitmapTrie2, null, 0, biFunction.apply(this.nullEntry.v, bitmapTrie.nullEntry.v));
        }
        bitmapTrie2.root = (BitmapNode)this.root.intersection(bitmapTrie2, bitmapTrie.root, biFunction, false);
        return bitmapTrie2;
    }

    @Override
    public BitmapTrie withMeta(IPersistentMap iPersistentMap) {
        return this.shallowClone(iPersistentMap);
    }

    @Override
    public IPersistentMap meta() {
        return this.meta;
    }

    public void printNodes() {
        if (this.nullEntry != null) {
            System.out.println("nullEntry: " + String.valueOf(this.nullEntry.val()));
        }
        this.root.print();
    }

    public static Function<Object[], BitmapTrie> makeFactory(BitmapTrieCommon.HashProvider hashProvider, Object[] objectArray) {
        Object object;
        final int n = objectArray.length;
        final BitmapTrie bitmapTrie = new BitmapTrie(hashProvider);
        for (int i = 0; i < n; ++i) {
            object = bitmapTrie.getOrCreate(objectArray[i]);
            if (((LeafNode)object).v != null) {
                throw new RuntimeException("Duplicate key detected: " + String.valueOf(objectArray[i]));
            }
            ((LeafNode)object).v = i;
        }
        final int[] nArray = new int[n];
        object = bitmapTrie.iterator((Function)BitmapTrieCommon.identityIterFn);
        for (int i = 0; i < n; ++i) {
            BitmapTrieCommon.ILeaf iLeaf = object.nextLeaf();
            nArray[i] = (Integer)iLeaf.val();
        }
        return new Function<Object[], BitmapTrie>(){

            @Override
            public BitmapTrie apply(Object[] objectArray) {
                if (objectArray.length != n) {
                    throw new RuntimeException("Value array len != key array len");
                }
                return new BitmapTrie(bitmapTrie, new IndexedIter(nArray, objectArray));
            }
        };
    }

    static class IndexedIter
    implements Iterator {
        final int[] indexes;
        int idx;
        final Object[] values;
        final int nvals;

        IndexedIter(int[] nArray, Object[] objectArray) {
            this.indexes = nArray;
            this.idx = 0;
            this.values = objectArray;
            this.nvals = nArray.length;
        }

        @Override
        public boolean hasNext() {
            return this.idx < this.nvals;
        }

        public Object next() {
            Object object = this.values[this.indexes[this.idx]];
            ++this.idx;
            return object;
        }
    }

    class ValueCollection<V>
    extends AbstractCollection<V>
    implements ITypedReduce {
        boolean allowsClear;

        ValueCollection(boolean bl) {
            this.allowsClear = bl;
        }

        @Override
        public final int size() {
            return BitmapTrie.this.size();
        }

        @Override
        public final void clear() {
            if (!this.allowsClear) {
                throw new RuntimeException("Unimplemented");
            }
            BitmapTrie.this.clear();
        }

        @Override
        public final Iterator<V> iterator() {
            Iterator iterator = BitmapTrie.this.iterator((Function)BitmapTrieCommon.valIterFn);
            return iterator;
        }

        @Override
        public final Spliterator<V> spliterator() {
            return BitmapTrie.this.spliterator(BitmapTrieCommon.valIterFn);
        }

        public Object reduce(IFn iFn, Object object) {
            return BitmapTrie.this.reduceValues(iFn, object);
        }

        @Override
        public Object parallelReduction(IFn iFn, IFn iFn2, IFn iFn3, ParallelOptions parallelOptions) {
            return Reductions.parallelCollectionReduction(iFn, iFn2, iFn3, this, parallelOptions);
        }

        @Override
        public void forEach(final Consumer consumer) {
            this.reduce(new IFnDef(){

                @Override
                public Object invoke(Object object, Object object2) {
                    consumer.accept(object2);
                    return consumer;
                }
            }, consumer);
        }
    }

    class KeySet<K>
    extends AbstractSet<K>
    implements ITypedReduce {
        final boolean allowsClear;

        KeySet(boolean bl) {
            this.allowsClear = bl;
        }

        @Override
        public final int size() {
            return BitmapTrie.this.size();
        }

        @Override
        public final void clear() {
            if (!this.allowsClear) {
                throw new RuntimeException("Unimplemented");
            }
            BitmapTrie.this.clear();
        }

        @Override
        public final Iterator<K> iterator() {
            Iterator iterator = BitmapTrie.this.iterator((Function)BitmapTrieCommon.keyIterFn);
            return iterator;
        }

        @Override
        public final Spliterator<K> spliterator() {
            return BitmapTrie.this.spliterator(BitmapTrieCommon.keyIterFn);
        }

        @Override
        public final boolean contains(Object object) {
            return BitmapTrie.this.getNode(object) != null;
        }

        public Object reduce(IFn iFn, Object object) {
            return BitmapTrie.this.reduceKeys(iFn, object);
        }

        @Override
        public Object parallelReduction(IFn iFn, IFn iFn2, IFn iFn3, ParallelOptions parallelOptions) {
            return Reductions.parallelCollectionReduction(iFn, iFn2, iFn3, this, parallelOptions);
        }

        @Override
        public void forEach(final Consumer consumer) {
            this.reduce(new IFnDef(){

                @Override
                public Object invoke(Object object, Object object2) {
                    consumer.accept(object2);
                    return consumer;
                }
            }, consumer);
        }
    }

    class EntrySet<K, V>
    extends AbstractSet<Map.Entry<K, V>>
    implements ITypedReduce {
        final boolean allowsClear;

        EntrySet(boolean bl) {
            this.allowsClear = bl;
        }

        @Override
        public final int size() {
            return BitmapTrie.this.size();
        }

        @Override
        public final void clear() {
            if (!this.allowsClear) {
                throw new RuntimeException("Unimplemented");
            }
            BitmapTrie.this.clear();
        }

        @Override
        public final Iterator<Map.Entry<K, V>> iterator() {
            Iterator iterator = BitmapTrie.this.iterator((Function)BitmapTrieCommon.entryIterFn);
            return iterator;
        }

        @Override
        public final Spliterator<Map.Entry<K, V>> spliterator() {
            return BitmapTrie.this.spliterator(BitmapTrieCommon.entryIterFn);
        }

        @Override
        public final boolean contains(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            Object k = entry.getKey();
            LeafNode leafNode = BitmapTrie.this.getNode(k);
            return leafNode != null && Objects.equals(leafNode.key(), k) && Objects.equals(leafNode.val(), entry.getValue());
        }

        @Override
        public Object reduce(IFn iFn) {
            return Reductions.iterReduce(this, iFn);
        }

        public Object reduce(IFn iFn, Object object) {
            return BitmapTrie.this.reduceEntries(iFn, object);
        }

        @Override
        public Object parallelReduction(IFn iFn, IFn iFn2, IFn iFn3, ParallelOptions parallelOptions) {
            return Reductions.parallelCollectionReduction(iFn, iFn2, iFn3, this, parallelOptions);
        }

        @Override
        public void forEach(final Consumer consumer) {
            this.reduce(new IFnDef(){

                @Override
                public Object invoke(Object object, Object object2) {
                    consumer.accept(object2);
                    return consumer;
                }
            }, consumer);
        }
    }

    static class TrieSpliterator
    implements Spliterator,
    IReduceInit {
        BitmapTrie root;
        BitmapTrie subtree;
        Iterator subtreeIter;
        int sidx;
        int eidx;
        final Function<BitmapTrieCommon.ILeaf, Object> fn;

        public TrieSpliterator(BitmapTrie bitmapTrie, int n, int n2, Function<BitmapTrieCommon.ILeaf, Object> function) {
            this.root = bitmapTrie;
            this.subtree = null;
            this.subtreeIter = null;
            this.sidx = n;
            this.eidx = n2;
            this.fn = function;
        }

        public TrieSpliterator(BitmapTrie bitmapTrie, Function<BitmapTrieCommon.ILeaf, Object> function) {
            this.root = bitmapTrie;
            this.subtree = null;
            this.subtreeIter = null;
            this.sidx = 0;
            this.eidx = 1024;
            this.fn = function;
        }

        BitmapTrie getSubtree() {
            if (this.subtree == null) {
                this.subtree = this.root.keyspaceSplit(this.sidx, this.eidx);
            }
            return this.subtree;
        }

        @Override
        public int characteristics() {
            return 1089;
        }

        @Override
        public long estimateSize() {
            return this.getSubtree().size();
        }

        @Override
        public long getExactSizeIfKnown() {
            return this.estimateSize();
        }

        public boolean tryAdvance(Consumer consumer) {
            boolean bl;
            if (this.subtreeIter == null) {
                this.subtreeIter = this.getSubtree().iterator((Function)this.fn);
            }
            if (bl = this.subtreeIter.hasNext()) {
                consumer.accept(this.subtreeIter.next());
            }
            return bl;
        }

        public Object reduce(final IFn iFn, Object object) {
            return this.getSubtree().reduceLeaves(new IFnDef(){

                @Override
                public Object invoke(Object object, Object object2) {
                    return iFn.invoke(object, fn.apply((BitmapTrieCommon.ILeaf)object2));
                }
            }, object);
        }

        public Spliterator trySplit() {
            int n = (this.eidx - this.sidx) / 2;
            int n2 = this.sidx + n;
            this.subtree = null;
            this.subtreeIter = null;
            TrieSpliterator trieSpliterator = new TrieSpliterator(this.root, n2, this.eidx, this.fn);
            this.eidx = n2;
            return trieSpliterator;
        }
    }

    public static class HTIterator
    implements BitmapTrieCommon.LeafNodeIterator {
        Function<BitmapTrieCommon.ILeaf, Object> tfn;
        LeafNode nullEntry;
        BitmapTrieCommon.LeafNodeIterator rootIter;

        HTIterator(Function<BitmapTrieCommon.ILeaf, Object> function, LeafNode leafNode, BitmapTrieCommon.LeafNodeIterator leafNodeIterator) {
            this.tfn = function;
            this.nullEntry = leafNode;
            this.rootIter = leafNodeIterator;
        }

        @Override
        public boolean hasNext() {
            return this.nullEntry != null || this.rootIter.hasNext();
        }

        @Override
        public BitmapTrieCommon.ILeaf nextLeaf() {
            if (this.nullEntry != null) {
                LeafNode leafNode = this.nullEntry;
                this.nullEntry = null;
                return leafNode;
            }
            return this.rootIter.nextLeaf();
        }

        @Override
        public Object next() {
            return this.tfn.apply(this.nextLeaf());
        }
    }

    public static final class BitmapNode
    implements BitmapTrieCommon.INode {
        public final BitmapTrieCommon.TrieBase owner;
        public final int shift;
        int bitmap;
        BitmapTrieCommon.INode[] data;

        public BitmapNode(BitmapTrieCommon.TrieBase trieBase, int n, int n2, BitmapTrieCommon.INode[] iNodeArray) {
            this.owner = trieBase;
            this.bitmap = n;
            this.shift = n2;
            this.data = iNodeArray;
        }

        public BitmapNode(BitmapTrieCommon.TrieBase trieBase, int n, int n2) {
            this.owner = trieBase;
            this.bitmap = n;
            this.shift = n2;
            this.data = new BitmapTrieCommon.INode[IntegerOps.nextPow2(Integer.bitCount(n))];
        }

        public BitmapNode(BitmapTrieCommon.TrieBase trieBase, int n, LeafNode leafNode) {
            this.owner = trieBase;
            this.shift = n;
            this.bitmap = leafNode != null ? IntegerOps.bitpos(n, leafNode.hashcode) : 0;
            this.data = new BitmapTrieCommon.INode[]{leafNode, null, null, null};
        }

        @Override
        public final BitmapNode clone(BitmapTrieCommon.TrieBase trieBase) {
            trieBase = trieBase == null ? this.owner : trieBase;
            BitmapTrieCommon.INode[] iNodeArray = this.data;
            int n = this.bitmap;
            int n2 = Integer.bitCount(n);
            BitmapTrieCommon.INode[] iNodeArray2 = new BitmapTrieCommon.INode[Math.max(4, IntegerOps.nextPow2(n2))];
            for (int i = 0; i < n2; ++i) {
                iNodeArray2[i] = iNodeArray[i].clone(trieBase);
            }
            return new BitmapNode(trieBase, this.bitmap, this.shift, iNodeArray2);
        }

        @Override
        public final BitmapNode valueClone(BitmapTrieCommon.TrieBase trieBase, Iterator iterator) {
            BitmapTrieCommon.INode[] iNodeArray = this.data;
            int n = this.bitmap;
            int n2 = Integer.bitCount(n);
            BitmapTrieCommon.INode[] iNodeArray2 = new BitmapTrieCommon.INode[Math.max(4, IntegerOps.nextPow2(n2))];
            for (int i = 0; i < n2; ++i) {
                iNodeArray2[i] = iNodeArray[i].valueClone(trieBase, iterator);
            }
            return new BitmapNode(trieBase, this.bitmap, this.shift, iNodeArray2);
        }

        public final BitmapNode refIndexes(BitmapTrieCommon.TrieBase trieBase, int n, int n2) {
            if (n2 > 31) {
                throw new RuntimeException("End idx (inclusive) must be less than 32");
            }
            int n3 = this.bitmap;
            int n4 = IntegerOps.highBits(n, n2);
            int n5 = n3 & n4;
            if (n5 == 0) {
                return null;
            }
            if (n5 == n3) {
                return this;
            }
            int n6 = Integer.bitCount(n5);
            BitmapTrieCommon.INode[] iNodeArray = new BitmapTrieCommon.INode[Math.max(4, IntegerOps.nextPow2(n6))];
            BitmapTrieCommon.INode[] iNodeArray2 = this.data;
            int n7 = 0;
            for (int i = n; i <= n2; ++i) {
                int n8 = 1 << i;
                if ((n5 & n8) == 0) continue;
                iNodeArray[n7] = iNodeArray2[IntegerOps.index(n3, n8)];
                ++n7;
            }
            return new BitmapNode(trieBase, n5, this.shift, iNodeArray);
        }

        public final LeafNode getOrCreate(Object object, int n) {
            int n2 = IntegerOps.bitpos(this.shift, n);
            BitmapTrieCommon.INode[] iNodeArray = this.data;
            int n3 = iNodeArray.length;
            int n4 = this.bitmap;
            int n5 = IntegerOps.index(n4, n2);
            if ((n4 & n2) == 0) {
                LeafNode leafNode = new LeafNode(this.owner, object, n);
                this.data = BitmapTrieCommon.insert(iNodeArray, leafNode, n5, Integer.bitCount(n4 |= n2), false);
                this.bitmap = n4;
                return leafNode;
            }
            BitmapTrieCommon.INode iNode = iNodeArray[n5];
            if (iNode instanceof BitmapNode) {
                return ((BitmapNode)iNode).getOrCreate(object, n);
            }
            LeafNode leafNode = (LeafNode)iNode;
            if (n == leafNode.hashcode) {
                return leafNode.getOrCreate(object, n);
            }
            BitmapNode bitmapNode = new BitmapNode(this.owner, IntegerOps.incShift(this.shift), leafNode);
            iNodeArray[n5] = bitmapNode;
            return bitmapNode.getOrCreate(object, n);
        }

        public final LeafNode get(Object object, int n, int n2, BitmapTrieCommon.HashProvider hashProvider) {
            int n3 = this.bitmap;
            int n4 = IntegerOps.bitpos(n2, n);
            if ((n3 & n4) != 0) {
                BitmapTrieCommon.INode iNode = this.data[IntegerOps.index(n3, n4)];
                if (iNode instanceof BitmapNode) {
                    return ((BitmapNode)iNode).get(object, n, IntegerOps.incShift(n2), hashProvider);
                }
                LeafNode leafNode = (LeafNode)iNode;
                while (leafNode != null) {
                    if (hashProvider.equals(leafNode.k, object)) {
                        return leafNode;
                    }
                    leafNode = leafNode.nextNode;
                }
            }
            return null;
        }

        @Override
        public final LeafNode get(Object object, int n) {
            return this.get(object, n, this.shift, this.owner);
        }

        public final BitmapTrieCommon.INode remove(Object object, int n, BitmapTrieCommon.Box box, boolean bl) {
            boolean bl2;
            LeafNode leafNode;
            int n2 = this.bitmap;
            int n3 = IntegerOps.bitpos(this.shift, n);
            if ((n2 & n3) == 0) {
                return this;
            }
            BitmapTrieCommon.INode[] iNodeArray = this.data;
            int n4 = IntegerOps.index(n2, n3);
            BitmapTrieCommon.INode iNode = iNodeArray[n4];
            BitmapTrieCommon.INode iNode2 = null;
            LeafNode leafNode2 = leafNode = iNode instanceof LeafNode ? (LeafNode)iNode : null;
            if (leafNode != null) {
                if (n != leafNode.hashcode) {
                    return this;
                }
                iNode2 = leafNode.remove(object, box);
            } else {
                iNode2 = ((BitmapNode)iNode).remove(object, n, box, true);
            }
            if (iNode2 == iNode) {
                return this;
            }
            boolean bl3 = bl2 = iNode2 == null;
            if (bl2) {
                n2 ^= n3;
            }
            int n5 = Integer.bitCount(n2);
            if (bl) {
                if (n5 == 0) {
                    return null;
                }
                if (n5 == 1) {
                    if (bl2) {
                        BitmapTrieCommon.INode iNode3;
                        BitmapTrieCommon.INode iNode4 = iNode3 = n4 == 0 ? iNodeArray[1] : iNodeArray[0];
                        if (iNode3 instanceof LeafNode) {
                            return iNode3;
                        }
                    } else if (iNode2 instanceof LeafNode) {
                        return iNode2;
                    }
                }
            }
            this.bitmap = n2;
            if (bl2) {
                this.data = BitmapTrieCommon.remove(iNodeArray, n4, n5, false);
            } else {
                iNodeArray[n4] = iNode2;
            }
            return this;
        }

        static final BitmapTrieCommon.INode unionAssoc(BitmapTrieCommon.TrieBase trieBase, BitmapTrieCommon.INode iNode, Object object, int n, int n2, Object object2) {
            if (iNode == null) {
                return new LeafNode(trieBase, object, n, object2);
            }
            if (iNode instanceof LeafNode) {
                LeafNode leafNode = (LeafNode)iNode;
                if (n == leafNode.hashcode) {
                    return leafNode.assoc(trieBase, object, n, object2);
                }
                iNode = new BitmapNode(trieBase, IntegerOps.incShift(n2), leafNode);
            }
            return ((BitmapNode)iNode).assoc(trieBase, object, n, object2);
        }

        public final BitmapNode assoc(BitmapTrieCommon.TrieBase trieBase, Object object, int n, Object object2) {
            int n2 = IntegerOps.bitpos(this.shift, n);
            boolean bl = trieBase != this.owner;
            int n3 = this.bitmap;
            if ((n3 & n2) == 0) {
                int n4 = n3 | n2;
                BitmapTrieCommon.INode[] iNodeArray = BitmapTrieCommon.insert(this.data, new LeafNode(trieBase, object, n, object2), IntegerOps.index(n4, n2), Integer.bitCount(n4), bl);
                if (trieBase != this.owner) {
                    return new BitmapNode(trieBase, n4, this.shift, iNodeArray);
                }
                this.data = iNodeArray;
                this.bitmap = n4;
                return this;
            }
            BitmapTrieCommon.INode[] iNodeArray = this.data;
            BitmapTrieCommon.INode[] iNodeArray2 = bl ? (BitmapTrieCommon.INode[])iNodeArray.clone() : iNodeArray;
            int n5 = IntegerOps.index(n3, n2);
            iNodeArray2[n5] = BitmapNode.unionAssoc(trieBase, iNodeArray2[n5], object, n, this.shift, object2);
            return bl ? new BitmapNode(trieBase, n3, this.shift, iNodeArray2) : this;
        }

        public BitmapTrieCommon.INode dissoc(BitmapTrieCommon.TrieBase trieBase, Object object, int n, boolean bl) {
            BitmapTrieCommon.INode[] iNodeArray;
            boolean bl2;
            boolean bl3;
            int n2 = this.bitmap;
            int n3 = IntegerOps.bitpos(this.shift, n);
            if ((n2 & n3) == 0) {
                return this;
            }
            BitmapTrieCommon.INode[] iNodeArray2 = this.data;
            int n4 = IntegerOps.index(n2, n3);
            BitmapTrieCommon.INode iNode = iNodeArray2[n4];
            BitmapTrieCommon.INode iNode2 = iNode.dissoc(trieBase, object, n);
            if (iNode2 == iNode) {
                return this;
            }
            boolean bl4 = bl3 = iNode2 == null;
            if (bl3) {
                n2 ^= n3;
            }
            int n5 = Integer.bitCount(n2);
            if (bl) {
                if (n5 == 0) {
                    return null;
                }
                if (n5 == 1) {
                    if (bl3) {
                        BitmapTrieCommon.INode iNode3 = iNodeArray2[n4 == 0 ? 1 : 0];
                        if (iNode3 instanceof LeafNode) {
                            return iNode3;
                        }
                    } else if (iNode2 instanceof LeafNode) {
                        return iNode2;
                    }
                }
            }
            boolean bl5 = bl2 = trieBase != this.owner;
            if (bl3) {
                iNodeArray = BitmapTrieCommon.remove(iNodeArray2, n4, n5, bl2);
            } else {
                iNodeArray = bl2 ? (BitmapTrieCommon.INode[])iNodeArray2.clone() : iNodeArray2;
                iNodeArray[n4] = iNode2;
            }
            if (bl2) {
                return new BitmapNode(trieBase, n2, this.shift, iNodeArray);
            }
            this.data = iNodeArray;
            this.bitmap = n2;
            return this;
        }

        @Override
        public final BitmapTrieCommon.INode dissoc(BitmapTrieCommon.TrieBase trieBase, Object object, int n) {
            return this.dissoc(trieBase, object, n, true);
        }

        @Override
        public final BitmapNode immutUpdate(BitmapTrieCommon.TrieBase trieBase, BiFunction biFunction) {
            boolean bl = this.owner != trieBase;
            BitmapTrieCommon.INode[] iNodeArray = bl ? (BitmapTrieCommon.INode[])this.data.clone() : this.data;
            int n = Integer.bitCount(this.bitmap);
            for (int i = 0; i < n; ++i) {
                iNodeArray[i] = iNodeArray[i].immutUpdate(trieBase, biFunction);
            }
            return bl ? new BitmapNode(trieBase, this.bitmap, this.shift, iNodeArray) : this;
        }

        @Override
        public final BitmapNode immutUpdate(BitmapTrieCommon.TrieBase trieBase, Object object, int n, IFn iFn) {
            int n2 = IntegerOps.bitpos(this.shift, n);
            if ((this.bitmap & n2) != 0) {
                boolean bl = this.owner != trieBase;
                int n3 = IntegerOps.index(this.bitmap, n2);
                BitmapTrieCommon.INode[] iNodeArray = bl ? (BitmapTrieCommon.INode[])this.data.clone() : this.data;
                iNodeArray[n3] = iNodeArray[n3].immutUpdate(trieBase, object, n, iFn);
                return bl ? new BitmapNode(trieBase, this.bitmap, this.shift, iNodeArray) : this;
            }
            return this.assoc(trieBase, object, n, iFn.invoke(null));
        }

        @Override
        public final int countLeaves() {
            BitmapTrieCommon.INode[] iNodeArray = this.data;
            int n = Integer.bitCount(this.bitmap);
            int n2 = 0;
            for (int i = 0; i < n; ++i) {
                n2 += iNodeArray[i].countLeaves();
            }
            return n2;
        }

        @Override
        public final BitmapTrieCommon.LeafNodeIterator iterator() {
            return new BitmapNodeIterator(this.data, this.bitmap);
        }

        @Override
        public Object reduce(IFn iFn, Object object) {
            BitmapTrieCommon.INode[] iNodeArray = this.data;
            int n = Integer.bitCount(this.bitmap);
            for (int i = 0; i < n && !RT.isReduced((Object)object); ++i) {
                object = iNodeArray[i].reduce(iFn, object);
            }
            return object;
        }

        static final Object mapValue(BitmapTrieCommon.ILeaf iLeaf, BitmapTrieCommon.ILeaf iLeaf2, BiFunction biFunction) {
            if (iLeaf == null) {
                return iLeaf2.val();
            }
            if (iLeaf2 == null) {
                return iLeaf.val();
            }
            return biFunction.apply(iLeaf.val(), iLeaf2.val());
        }

        public final BitmapNode union(BitmapTrieCommon.TrieBase trieBase, BitmapNode bitmapNode, BiFunction biFunction) {
            int n = this.bitmap;
            int n2 = bitmapNode.bitmap;
            BitmapTrieCommon.INode[] iNodeArray = this.data;
            BitmapTrieCommon.INode[] iNodeArray2 = bitmapNode.data;
            boolean bl = this.owner != trieBase;
            for (int i = 0; i < 32; ++i) {
                BitmapTrieCommon.ILeaf iLeaf;
                LeafNode leafNode;
                boolean bl2;
                int n3 = 1 << i;
                boolean bl3 = (n & n3) != 0;
                boolean bl4 = bl2 = (n2 & n3) != 0;
                if (!bl2) continue;
                int n4 = IntegerOps.index(n2, n3);
                BitmapTrieCommon.INode iNode = iNodeArray2[n4];
                if (!bl3) {
                    iNodeArray = BitmapTrieCommon.insert(iNodeArray, iNode, IntegerOps.index(n |= n3, n3), Integer.bitCount(n), bl);
                    bl = false;
                    continue;
                }
                int n5 = IntegerOps.index(n, n3);
                BitmapTrieCommon.INode iNode2 = iNodeArray[n5];
                iNodeArray = bl ? (BitmapTrieCommon.INode[])iNodeArray.clone() : iNodeArray;
                bl = false;
                BitmapTrieCommon.INode iNode3 = null;
                if (iNode2 instanceof LeafNode) {
                    iNode3 = iNode;
                    leafNode = (LeafNode)iNode2;
                    while (leafNode != null) {
                        iLeaf = iNode.get(leafNode.k, leafNode.hashcode);
                        iNode3 = BitmapNode.unionAssoc(trieBase, iNode3, leafNode.k, leafNode.hashcode, this.shift, BitmapNode.mapValue(leafNode, iLeaf, biFunction));
                        leafNode = leafNode.nextNode;
                    }
                } else if (iNode instanceof LeafNode) {
                    iNode3 = iNode2;
                    leafNode = (LeafNode)iNode;
                    while (leafNode != null) {
                        iLeaf = iNode2.get(leafNode.k, leafNode.hashcode);
                        iNode3 = BitmapNode.unionAssoc(trieBase, iNode3, leafNode.k, leafNode.hashcode, this.shift, BitmapNode.mapValue(iLeaf, leafNode, biFunction));
                        leafNode = leafNode.nextNode;
                    }
                } else {
                    iNode3 = ((BitmapNode)iNode2).union(trieBase, (BitmapNode)iNode, biFunction);
                }
                iNodeArray[n5] = iNode3;
            }
            return new BitmapNode(trieBase, n, this.shift, iNodeArray);
        }

        public final BitmapTrieCommon.INode difference(BitmapTrie bitmapTrie, BitmapNode bitmapNode, boolean bl) {
            int n;
            int n2 = this.bitmap;
            int n3 = bitmapNode.bitmap;
            int n4 = n2 & n3;
            if (n4 == 0) {
                return this;
            }
            BitmapTrieCommon.INode[] iNodeArray = this.data;
            BitmapTrieCommon.INode[] iNodeArray2 = bitmapNode.data;
            boolean bl2 = this.owner != bitmapTrie;
            for (n = 31; n >= 0 && n2 != 0; --n) {
                BitmapTrieCommon.INode iNode;
                LeafNode leafNode;
                int n5 = 1 << n;
                if ((n4 & n5) == 0) continue;
                BitmapTrieCommon.INode iNode2 = iNodeArray[IntegerOps.index(n2, n5)];
                BitmapTrieCommon.INode iNode3 = iNodeArray2[IntegerOps.index(n3, n5)];
                if (iNode2 instanceof LeafNode) {
                    leafNode = (LeafNode)iNode2;
                    while (leafNode != null && iNode != null) {
                        if (iNode3.get(leafNode.k, leafNode.hashcode) != null) {
                            iNode = iNode.dissoc(bitmapTrie, leafNode.key(), leafNode.hashcode);
                        }
                        leafNode = leafNode.nextNode;
                    }
                } else if (iNode3 instanceof LeafNode) {
                    leafNode = (LeafNode)iNode3;
                    for (iNode = iNode2; leafNode != null && iNode != null; iNode = iNode.dissoc(bitmapTrie, leafNode.key(), leafNode.hashcode)) {
                        leafNode = leafNode.nextNode;
                    }
                } else {
                    iNode = ((BitmapNode)iNode2).difference(bitmapTrie, (BitmapNode)iNode3, true);
                }
                if (iNode == null) {
                    iNodeArray = BitmapTrieCommon.remove(iNodeArray, IntegerOps.index(n2 ^= n5, n5), Integer.bitCount(n2), bl2);
                    bl2 = false;
                    continue;
                }
                iNodeArray = bl2 ? (BitmapTrieCommon.INode[])iNodeArray.clone() : iNodeArray;
                bl2 = false;
                iNodeArray[IntegerOps.index((int)n2, (int)n5)] = iNode;
            }
            if (bl) {
                n = Integer.bitCount(n2);
                if (n == 0) {
                    return null;
                }
                if (n == 1 && iNodeArray[0] instanceof LeafNode) {
                    return iNodeArray[0];
                }
            }
            if (iNodeArray == this.data) {
                this.bitmap = n2;
                return this;
            }
            return new BitmapNode(bitmapTrie, n2, this.shift, iNodeArray);
        }

        public final BitmapTrieCommon.INode intersection(BitmapTrieCommon.TrieBase trieBase, BitmapNode bitmapNode, BiFunction biFunction, boolean bl) {
            int n = this.bitmap;
            if (n == 0) {
                return this;
            }
            int n2 = bitmapNode.bitmap;
            int n3 = n & n2;
            if (n3 == 0) {
                if (bl) {
                    return null;
                }
                return new BitmapNode(trieBase, 0, this.shift, new BitmapTrieCommon.INode[4]);
            }
            BitmapTrieCommon.INode[] iNodeArray = this.data;
            BitmapTrieCommon.INode[] iNodeArray2 = bitmapNode.data;
            BitmapTrieCommon.INode[] iNodeArray3 = null;
            int n4 = 0;
            int n5 = 0;
            for (int i = 0; i < 32; ++i) {
                BitmapTrieCommon.ILeaf iLeaf;
                int n6 = 1 << i;
                if ((n3 & n6) == 0) continue;
                BitmapTrieCommon.INode iNode = iNodeArray[IntegerOps.index(n, n6)];
                BitmapTrieCommon.INode iNode2 = iNodeArray2[IntegerOps.index(n2, n6)];
                BitmapTrieCommon.INode iNode3 = null;
                if (iNode2 instanceof LeafNode) {
                    LeafNode leafNode = (LeafNode)iNode2;
                    while (leafNode != null) {
                        iLeaf = iNode.get(leafNode.k, leafNode.hashcode);
                        if (iLeaf != null) {
                            iNode3 = BitmapNode.unionAssoc(trieBase, iNode3, leafNode.k, leafNode.hashcode, this.shift, biFunction.apply(iLeaf.val(), leafNode.v));
                        }
                        leafNode = leafNode.nextNode;
                    }
                } else if (iNode instanceof LeafNode) {
                    LeafNode leafNode = (LeafNode)iNode;
                    while (leafNode != null) {
                        iLeaf = iNode2.get(leafNode.k, leafNode.hashcode);
                        if (iLeaf != null) {
                            iNode3 = BitmapNode.unionAssoc(trieBase, iNode3, leafNode.k, leafNode.hashcode, this.shift, biFunction.apply(leafNode.v, iLeaf.val()));
                        }
                        leafNode = leafNode.nextNode;
                    }
                } else {
                    iNode3 = ((BitmapNode)iNode).intersection(trieBase, (BitmapNode)iNode2, biFunction, true);
                }
                if (iNode3 == null) continue;
                if (iNodeArray3 == null) {
                    iNodeArray3 = new BitmapTrieCommon.INode[4];
                }
                n4 |= n6;
                int n7 = n5++;
                iNodeArray3 = BitmapTrieCommon.insert(iNodeArray3, iNode3, n7, n5, false);
            }
            if (bl) {
                if (iNodeArray3 == null) {
                    return null;
                }
                if (n5 == 1 && iNodeArray3[0] instanceof LeafNode) {
                    return iNodeArray3[0];
                }
            }
            return new BitmapNode(trieBase, n4, this.shift, iNodeArray3 != null ? iNodeArray3 : new BitmapTrieCommon.INode[4]);
        }

        public void print(int n) {
            int n2;
            for (n2 = 0; n2 < n; ++n2) {
                System.out.print("  ");
            }
            n2 = Integer.bitCount(this.bitmap);
            System.out.println("Shift: " + String.valueOf(this.shift) + " Bitmap: " + String.valueOf(this.bitmap) + " bitcount: " + n2 + " Owner: " + String.valueOf(this.owner));
            ++n;
            for (int i = 0; i < n2; ++i) {
                BitmapTrieCommon.INode iNode = this.data[i];
                if (iNode instanceof BitmapNode) {
                    ((BitmapNode)iNode).print(n);
                    continue;
                }
                ((LeafNode)iNode).print(n);
            }
        }

        public void print() {
            this.print(0);
        }

        static class BitmapNodeIterator
        implements BitmapTrieCommon.LeafNodeIterator {
            final BitmapTrieCommon.INode[] data;
            final int len;
            int idx;
            LeafNode leaf;
            BitmapTrieCommon.LeafNodeIterator nextObj;

            BitmapNodeIterator(BitmapTrieCommon.INode[] iNodeArray, int n) {
                this.data = iNodeArray;
                this.len = Integer.bitCount(n);
                this.idx = -1;
                this.leaf = null;
                this.nextObj = null;
                this.advance();
            }

            final void advance() {
                int n;
                if (this.nextObj != null && this.nextObj.hasNext()) {
                    return;
                }
                if (this.leaf != null) {
                    this.leaf = this.leaf.nextNode;
                }
                if (this.leaf != null) {
                    return;
                }
                this.idx = n = this.idx + 1;
                if (n < this.len) {
                    BitmapTrieCommon.INode iNode = this.data[n];
                    if (iNode instanceof LeafNode) {
                        this.leaf = (LeafNode)iNode;
                    } else {
                        this.nextObj = ((BitmapNode)iNode).iterator();
                    }
                } else {
                    this.nextObj = null;
                    this.leaf = null;
                }
            }

            @Override
            public final boolean hasNext() {
                return this.nextObj != null || this.leaf != null;
            }

            @Override
            public final BitmapTrieCommon.ILeaf nextLeaf() {
                BitmapTrieCommon.ILeaf iLeaf;
                if (this.leaf != null) {
                    iLeaf = this.leaf;
                } else if (this.nextObj != null) {
                    iLeaf = this.nextObj.nextLeaf();
                } else {
                    throw new UnsupportedOperationException();
                }
                this.advance();
                return iLeaf;
            }
        }
    }

    static interface BitmapTrieOwner {
        public BitmapTrie bitmapTrie();
    }
}

