/*
 * Decompiled with CFR 0.152.
 */
package ham_fisted;

import clojure.lang.APersistentVector;
import clojure.lang.IDeref;
import clojure.lang.IEditableCollection;
import clojure.lang.IFn;
import clojure.lang.IHashEq;
import clojure.lang.IKVReduce;
import clojure.lang.IMapEntry;
import clojure.lang.IObj;
import clojure.lang.IPersistentMap;
import clojure.lang.IPersistentVector;
import clojure.lang.IReduce;
import clojure.lang.ISeq;
import clojure.lang.Indexed;
import clojure.lang.MapEntry;
import clojure.lang.Murmur3;
import clojure.lang.RT;
import clojure.lang.Reversible;
import clojure.lang.Seqable;
import clojure.lang.Util;
import ham_fisted.ArrayLists;
import ham_fisted.ArraySection;
import ham_fisted.BitmapTrieCommon;
import ham_fisted.ChunkedList;
import ham_fisted.CljHash;
import ham_fisted.HashSet;
import ham_fisted.IMutList;
import ham_fisted.ImmutList;
import ham_fisted.ImmutValues;
import ham_fisted.MutList;
import ham_fisted.Reductions;
import ham_fisted.Transformables;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.RandomAccess;
import java.util.function.BiFunction;

public class ArrayImmutList
extends APersistentVector
implements IMutList,
RandomAccess,
Indexed,
IReduce,
IKVReduce,
IHashEq,
Seqable,
Reversible,
ChunkedList.ChunkedListOwner,
IPersistentVector,
IObj,
IEditableCollection,
ImmutValues,
ArrayLists.ArrayOwner {
    final Object[] data;
    public final int startidx;
    public final int nElems;
    public final IPersistentMap m;
    int _hash = 0;
    public static final ArrayImmutList EMPTY = new ArrayImmutList(new Object[0], 0, 0, null);

    public ArrayImmutList(Object[] objectArray, int n, int n2, IPersistentMap iPersistentMap) {
        this.data = objectArray;
        this.startidx = n;
        this.nElems = n2 - n;
        this.m = iPersistentMap;
    }

    public static ArrayImmutList create(boolean bl, Object[] objectArray, int n, int n2, IPersistentMap iPersistentMap) {
        objectArray = bl ? objectArray : (Object[])objectArray.clone();
        return new ArrayImmutList(objectArray, n, n2, iPersistentMap);
    }

    public static IPersistentVector create(boolean bl, IPersistentMap iPersistentMap, Object ... objectArray) {
        if (objectArray.length > 32) {
            return ImmutList.create(bl, iPersistentMap, objectArray);
        }
        return ArrayImmutList.create(bl, objectArray, 0, objectArray.length, iPersistentMap);
    }

    final int indexCheck(int n) {
        return ChunkedList.indexCheck(this.startidx, this.nElems, n);
    }

    final int wrapIndexCheck(int n) {
        return ChunkedList.wrapIndexCheck(this.startidx, this.nElems, n);
    }

    @Override
    public ChunkedList.ChunkedListSection getChunkedList() {
        return new ChunkedList.ChunkedListSection(ChunkedList.create((boolean)true, null, (Object[])this.data).data, this.startidx, this.startidx + this.nElems);
    }

    @Override
    public final int hashCode() {
        if (this._hash == 0) {
            int n = this.nElems;
            int n2 = this.startidx + n;
            int n3 = 1;
            Object[] objectArray = this.data;
            for (int i = this.startidx; i < n2; ++i) {
                n3 = 31 * n3 + Util.hasheq((Object)objectArray[i]);
            }
            this._hash = n3 = Murmur3.mixCollHash((int)n3, (int)n);
        }
        return this._hash;
    }

    @Override
    public final int hasheq() {
        return this.hashCode();
    }

    public final boolean equiv(BitmapTrieCommon.HashProvider hashProvider, Object object) {
        if (object == this) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (object instanceof ArrayImmutList) {
            int n = this.nElems;
            ArrayImmutList arrayImmutList = (ArrayImmutList)object;
            if (arrayImmutList.nElems != n) {
                return false;
            }
            int n2 = this.startidx;
            int n3 = arrayImmutList.startidx;
            Object[] objectArray = this.data;
            Object[] objectArray2 = arrayImmutList.data;
            for (int i = 0; i < n; ++i) {
                if (hashProvider.equals(objectArray[i + n2], objectArray2[i + n3])) continue;
                return false;
            }
            return true;
        }
        return CljHash.listEquiv(this, object);
    }

    @Override
    public final boolean equiv(Object object) {
        return this.equiv(BitmapTrieCommon.defaultHashProvider, object);
    }

    @Override
    public final boolean equals(Object object) {
        return this.equiv(object);
    }

    public final String toString() {
        return Transformables.sequenceToString(this);
    }

    @Override
    public final IPersistentMap meta() {
        return this.m;
    }

    @Override
    public final ArrayImmutList withMeta(IPersistentMap iPersistentMap) {
        return new ArrayImmutList(this.data, this.startidx, this.startidx + this.nElems, iPersistentMap);
    }

    @Override
    public void clear() {
        throw new RuntimeException("Unimplemented");
    }

    @Override
    public boolean remove(Object object) {
        throw new RuntimeException("Unimplemented");
    }

    @Override
    public Character remove(int n) {
        throw new RuntimeException("Unimplemented");
    }

    @Override
    public boolean add(Object object) {
        throw new RuntimeException("Unimplemented");
    }

    @Override
    public void add(int n, Object object) {
        throw new RuntimeException("Unimplemented");
    }

    @Override
    public boolean addAll(int n, Collection collection) {
        throw new RuntimeException("Unimplemented");
    }

    @Override
    public Character set(int n, Object object) {
        throw new RuntimeException("Unimplemented");
    }

    @Override
    public boolean retainAll(Collection collection) {
        throw new RuntimeException("Unimplemented");
    }

    @Override
    public boolean removeAll(Collection collection) {
        throw new RuntimeException("Unimplemented");
    }

    @Override
    public boolean addAll(Collection collection) {
        throw new RuntimeException("Unimplemented");
    }

    @Override
    public Object get(int n) {
        return this.data[ChunkedList.indexCheck(this.startidx, this.nElems, n)];
    }

    @Override
    public final int indexOf(Object object) {
        int n = this.nElems;
        int n2 = this.startidx;
        Object[] objectArray = this.data;
        for (int i = 0; i < n; ++i) {
            if (!Objects.equals(object, objectArray[i + n2])) continue;
            return i;
        }
        return -1;
    }

    @Override
    public final int lastIndexOf(Object object) {
        int n = this.nElems;
        int n2 = n - 1;
        int n3 = this.startidx;
        Object[] objectArray = this.data;
        for (int i = 0; i < n; ++i) {
            int n4 = n2 - i;
            if (!Objects.equals(object, objectArray[n4 + n3])) continue;
            return n4;
        }
        return -1;
    }

    @Override
    public final int size() {
        return this.nElems;
    }

    @Override
    public final int length() {
        return this.nElems;
    }

    @Override
    public final int count() {
        return this.nElems;
    }

    @Override
    public final boolean contains(Object object) {
        return this.indexOf(object) != -1;
    }

    @Override
    public final boolean containsAll(Collection collection) {
        Iterator iterator;
        Iterator iterator2;
        int n = this.nElems;
        if (n < collection.size()) {
            iterator2 = this.iterator();
            iterator = collection.iterator();
        } else {
            iterator = this.iterator();
            iterator2 = collection.iterator();
        }
        HashSet hashSet = new HashSet();
        while (iterator2.hasNext()) {
            hashSet.add(iterator2.next());
        }
        while (iterator.hasNext()) {
            if (hashSet.contains(iterator.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isEmpty() {
        return this.nElems == 0;
    }

    @Override
    public Object[] fillArray(Object[] objectArray) {
        System.arraycopy(this.data, this.startidx, objectArray, 0, this.nElems);
        return objectArray;
    }

    @Override
    public Object[] toArray() {
        return this.fillArray(new Object[this.nElems]);
    }

    @Override
    public Object[] toArray(Object[] objectArray) {
        return this.fillArray(Arrays.copyOf(objectArray, this.nElems));
    }

    @Override
    public ArrayImmutList subList(int n, int n2) {
        ChunkedList.sublistCheck(n, n2, this.nElems);
        return new ArrayImmutList(this.data, n + this.startidx, n2 + this.startidx, this.m);
    }

    @Override
    public final Iterator iterator() {
        return new Iter(this.data, this.startidx, this.nElems);
    }

    public final Iterator riterator() {
        return new RIter(this.data, this.startidx, this.nElems);
    }

    @Override
    public final Object nth(int n, Object object) {
        int n2 = this.nElems;
        if (n < 0) {
            n += n2;
        }
        if (n < 0 || n >= n2) {
            return object;
        }
        return this.data[n + this.startidx];
    }

    @Override
    public final Object nth(int n) {
        return this.data[ChunkedList.indexCheck(this.startidx, this.nElems, n < 0 ? n + this.nElems : n)];
    }

    @Override
    public final Object invoke(Object object) {
        if (Util.isInteger((Object)object)) {
            return this.nth(RT.intCast((Object)object));
        }
        return null;
    }

    @Override
    public final Object invoke(Object object, Object object2) {
        if (Util.isInteger((Object)object)) {
            return this.nth(RT.intCast((Object)object), object2);
        }
        return object2;
    }

    @Override
    public final Object valAt(Object object) {
        return this.invoke(object);
    }

    @Override
    public final Object valAt(Object object, Object object2) {
        return this.invoke(object, object2);
    }

    @Override
    public final IMapEntry entryAt(Object object) {
        int n;
        if (Util.isInteger((Object)object) && (n = RT.intCast((Object)object)) >= 0 && n < this.nElems) {
            return MapEntry.create((Object)n, (Object)this.get(n));
        }
        return null;
    }

    @Override
    public final boolean containsKey(Object object) {
        if (Util.isInteger((Object)object)) {
            int n = RT.intCast((Object)object);
            return n >= 0 && n < this.nElems;
        }
        return false;
    }

    @Override
    public final ArrayImmutList empty() {
        return EMPTY.withMeta(this.m);
    }

    @Override
    public final Object reduce(IFn iFn, Object object) {
        int n = this.startidx + this.nElems;
        Object[] objectArray = this.data;
        for (int i = this.startidx; i < n; ++i) {
            if (!RT.isReduced((Object)(object = iFn.invoke(object, objectArray[i])))) continue;
            return ((IDeref)object).deref();
        }
        return object;
    }

    @Override
    public final Object kvreduce(IFn iFn, Object object) {
        int n = this.startidx;
        Object[] objectArray = this.data;
        int n2 = this.nElems;
        for (int i = 0; i < n2 && !RT.isReduced((Object)object); ++i) {
            object = iFn.invoke(object, (Object)i, objectArray[n + i]);
        }
        return Reductions.unreduce(object);
    }

    @Override
    public final ISeq seq() {
        return RT.chunkIteratorSeq((Iterator)this.iterator());
    }

    @Override
    public final ISeq rseq() {
        return RT.chunkIteratorSeq((Iterator)this.riterator());
    }

    @Override
    public final IPersistentVector cons(Object object) {
        int n = this.nElems;
        switch (n) {
            case 0: {
                return new ArrayImmutList(new Object[]{object}, 0, 1, this.m);
            }
            case 1: {
                return new ArrayImmutList(new Object[]{this.data[this.startidx], object}, 0, 2, this.m);
            }
            case 2: {
                return new ArrayImmutList(new Object[]{this.data[this.startidx], this.data[this.startidx + 1], object}, 0, 3, this.m);
            }
            case 3: {
                return new ArrayImmutList(new Object[]{this.data[this.startidx], this.data[this.startidx + 1], this.data[this.startidx + 2], object}, 0, 4, this.m);
            }
        }
        int n2 = this.nElems + 1;
        Object[] objectArray = Arrays.copyOfRange(this.data, this.startidx, this.startidx + n2);
        objectArray[n] = object;
        if (n2 > 32) {
            return new ImmutList(0, n2, ChunkedList.create(true, this.m, objectArray));
        }
        return new ArrayImmutList(objectArray, 0, n2, this.m);
    }

    public final IPersistentVector assocN(int n, Object object) {
        int n2 = this.nElems;
        int n3 = this.startidx;
        if (n == n2) {
            return this.cons(object);
        }
        this.indexCheck(n);
        Object[] objectArray = Arrays.copyOfRange(this.data, n3, n3 + n2);
        objectArray[n] = object;
        return new ArrayImmutList(objectArray, 0, n2, this.m);
    }

    public final IPersistentVector assoc(Object object, Object object2) {
        if (!Util.isInteger((Object)object)) {
            throw new RuntimeException("Vector indexes must be integers: " + String.valueOf(object));
        }
        return this.assocN(RT.intCast((Object)object), object2);
    }

    public final ArrayImmutList pop() {
        int n = this.nElems;
        if (n == 0) {
            throw new RuntimeException("Attempt to pop empty vector");
        }
        Object[] objectArray = Arrays.copyOfRange(this.data, this.startidx, this.startidx + n - 1);
        return new ArrayImmutList(objectArray, 0, n - 1, this.m);
    }

    public final Object peek() {
        if (this.nElems == 0) {
            return null;
        }
        return this.get(this.nElems - 1);
    }

    public final MutList<Object> asTransient() {
        if (this.nElems == 0) {
            return new MutList<Object>();
        }
        return MutList.create(true, this.meta(), Arrays.copyOfRange(this.data, this.startidx, this.startidx + this.nElems));
    }

    @Override
    public final ArrayImmutList immutUpdateValue(Object object, IFn iFn) {
        int n = RT.intCast((Object)object);
        if (n < 0) {
            n = this.nElems + n;
        }
        if (n >= this.nElems) {
            throw new RuntimeException("Index out of range: " + String.valueOf(object));
        }
        Object[] objectArray = Arrays.copyOfRange(this.data, this.startidx, this.startidx + this.nElems);
        objectArray[n] = iFn.invoke(objectArray[n]);
        return new ArrayImmutList(objectArray, 0, this.nElems, this.m);
    }

    @Override
    public final ArrayImmutList immutUpdateValues(BiFunction biFunction) {
        int n = this.nElems;
        Object[] objectArray = Arrays.copyOfRange(this.data, this.startidx, this.startidx + this.nElems);
        for (int i = 0; i < n; ++i) {
            objectArray[i] = biFunction.apply(i, objectArray[i]);
        }
        return new ArrayImmutList(objectArray, 0, this.nElems, this.m);
    }

    @Override
    public ArraySection getArraySection() {
        return new ArraySection(this.data, this.startidx, this.startidx + this.nElems);
    }

    @Override
    public void fill(int n, int n2, Object object) {
        throw new RuntimeException("Unimplemented");
    }

    @Override
    public Object copyOfRange(int n, int n2) {
        return Arrays.copyOfRange(this.data, this.startidx + n, this.startidx + n2);
    }

    @Override
    public Object copyOf(int n) {
        return Arrays.copyOfRange(this.data, this.startidx + 0, this.startidx + n);
    }

    static class RIter
    implements Iterator {
        final Object[] data;
        final int nne;
        final int sidx;
        int idx;

        public RIter(Object[] objectArray, int n, int n2) {
            this.data = objectArray;
            this.nne = n2 - 1;
            this.sidx = n + this.nne;
            this.idx = 0;
        }

        @Override
        public final boolean hasNext() {
            return this.idx <= this.nne;
        }

        public final Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Object object = this.data[this.sidx - this.idx];
            ++this.idx;
            return object;
        }
    }

    static class Iter
    implements Iterator {
        final Object[] data;
        final int endidx;
        int idx;

        public Iter(Object[] objectArray, int n, int n2) {
            this.data = objectArray;
            this.idx = n;
            this.endidx = n + n2;
        }

        @Override
        public final boolean hasNext() {
            return this.idx < this.endidx;
        }

        public final Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Object object = this.data[this.idx];
            ++this.idx;
            return object;
        }
    }
}

