/*
 * Decompiled with CFR 0.152.
 */
package ham_fisted;

import clojure.lang.APersistentMap;
import clojure.lang.Counted;
import clojure.lang.IFn;
import clojure.lang.IHashEq;
import clojure.lang.IKVReduce;
import clojure.lang.ILookup;
import clojure.lang.IMapEntry;
import clojure.lang.IMapIterable;
import clojure.lang.IMeta;
import clojure.lang.IPersistentMap;
import clojure.lang.IReduceInit;
import clojure.lang.ISeq;
import clojure.lang.MapEntry;
import clojure.lang.MapEquivalence;
import clojure.lang.RT;
import clojure.lang.Reduced;
import clojure.lang.Seqable;
import ham_fisted.BitmapTrieCommon;
import ham_fisted.IFnDef;
import ham_fisted.ITypedReduce;
import ham_fisted.LeafNode;
import ham_fisted.MapData;
import ham_fisted.ParallelOptions;
import ham_fisted.Reductions;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Spliterator;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;

public abstract class APersistentMapBase
extends APersistentMap
implements Map,
ITypedReduce,
IHashEq,
ILookup,
Counted,
IMeta,
IMapIterable,
IKVReduce,
MapEquivalence,
Iterable,
Seqable {
    MapData ht;
    Set<Map.Entry> entrySet;
    Set keySet;

    public APersistentMapBase(MapData mapData) {
        this.ht = mapData;
    }

    @Override
    public int size() {
        return this.ht.size();
    }

    public int count() {
        return this.ht.size();
    }

    public String toString() {
        StringBuilder stringBuilder = (StringBuilder)this.ht.reduce(BitmapTrieCommon.identityIterFn, new IFnDef(){

            @Override
            public Object invoke(Object object, Object object2) {
                StringBuilder stringBuilder = (StringBuilder)object;
                LeafNode leafNode = (LeafNode)object2;
                if (stringBuilder.length() > 2) {
                    stringBuilder.append(",");
                }
                return stringBuilder.append(leafNode.k).append(" ").append(leafNode.v);
            }
        }, new StringBuilder().append("{"));
        return stringBuilder.append("}").toString();
    }

    public Object get(Object object) {
        return this.ht.get(object);
    }

    public Object getOrDefault(Object object, Object object2) {
        return this.ht.getOrDefault(object, object2);
    }

    @Override
    public boolean isEmpty() {
        return this.ht.isEmpty();
    }

    @Override
    public void clear() {
        this.ht.clear();
    }

    public void forEach(final BiConsumer biConsumer) {
        this.ht.reduce(BitmapTrieCommon.identityIterFn, new IFnDef(){

            @Override
            public Object invoke(Object object, Object object2) {
                BitmapTrieCommon.ILeaf iLeaf = (BitmapTrieCommon.ILeaf)object2;
                biConsumer.accept(iLeaf.key(), iLeaf.val());
                return biConsumer;
            }
        }, biConsumer);
    }

    @Override
    public boolean containsKey(Object object) {
        return this.ht.containsKey(object);
    }

    @Override
    public boolean containsValue(final Object object) {
        return (Boolean)this.ht.reduce(BitmapTrieCommon.valIterFn, new IFnDef(){

            @Override
            public Object invoke(Object object3, Object object2) {
                if (Objects.equals(object2, object)) {
                    return new Reduced((Object)true);
                }
                return false;
            }
        }, false);
    }

    public Set<Map.Entry> entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new EntrySet();
        }
        return this.entrySet;
    }

    public final Set keySet() {
        if (this.keySet == null) {
            this.keySet = new KeySet();
        }
        return this.keySet;
    }

    public Collection values() {
        return new ValueCollection();
    }

    Iterator iterator(Function<BitmapTrieCommon.ILeaf, Object> function) {
        return this.ht.iterator(function);
    }

    public Iterator iterator() {
        return this.entrySet().iterator();
    }

    public void forEach(Consumer consumer) {
        ITypedReduce.super.forEach(consumer);
    }

    public Iterator keyIterator() {
        return this.ht.iterator(BitmapTrieCommon.keyIterFn);
    }

    public Iterator valIterator() {
        return this.ht.iterator(BitmapTrieCommon.valIterFn);
    }

    Spliterator spliterator(Function<BitmapTrieCommon.ILeaf, Object> function) {
        return this.ht.spliterator(function);
    }

    Object reduce(Function<BitmapTrieCommon.ILeaf, Object> function, IFn iFn, Object object) {
        return this.ht.reduce(function, iFn, object);
    }

    public Object reduce(IFn iFn, Object object) {
        return ((IReduceInit)this.entrySet()).reduce(iFn, object);
    }

    @Override
    public Object parallelReduction(IFn iFn, IFn iFn2, IFn iFn3, ParallelOptions parallelOptions) {
        return Reductions.parallelCollectionReduction(iFn, iFn2, iFn3, this.entrySet(), parallelOptions);
    }

    public Object kvreduce(final IFn iFn, Object object) {
        return this.ht.reduce(BitmapTrieCommon.identityIterFn, new IFnDef(){

            @Override
            public Object invoke(Object object, Object object2) {
                BitmapTrieCommon.ILeaf iLeaf = (BitmapTrieCommon.ILeaf)object2;
                return iFn.invoke(object, iLeaf.key(), iLeaf.val());
            }
        }, object);
    }

    public final IMapEntry entryAt(Object object) {
        LeafNode leafNode = (LeafNode)this.ht.getNode(object);
        return leafNode == null ? null : new MapEntry(leafNode.key(), leafNode.val());
    }

    public Object valAt(Object object) {
        return this.get(object);
    }

    public Object valAt(Object object, Object object2) {
        return this.getOrDefault(object, object2);
    }

    public final Object invoke(Object object) {
        return this.get(object);
    }

    public final Object invoke(Object object, Object object2) {
        return this.getOrDefault(object, object2);
    }

    public ISeq seq() {
        return RT.chunkIteratorSeq((Iterator)this.iterator());
    }

    public IPersistentMap meta() {
        return this.ht.meta();
    }

    class ValueCollection
    extends AbstractCollection
    implements ITypedReduce {
        ValueCollection() {
        }

        @Override
        public final int size() {
            return APersistentMapBase.this.size();
        }

        @Override
        public final void clear() {
            APersistentMapBase.this.clear();
        }

        @Override
        public final Iterator iterator() {
            Iterator iterator = APersistentMapBase.this.iterator(BitmapTrieCommon.valIterFn);
            return iterator;
        }

        @Override
        public final Spliterator spliterator() {
            return APersistentMapBase.this.spliterator(BitmapTrieCommon.valIterFn);
        }

        public Object reduce(IFn iFn, Object object) {
            return APersistentMapBase.this.reduce(BitmapTrieCommon.valIterFn, iFn, object);
        }

        @Override
        public Object parallelReduction(IFn iFn, IFn iFn2, IFn iFn3, ParallelOptions parallelOptions) {
            return Reductions.parallelCollectionReduction(iFn, iFn2, iFn3, this, parallelOptions);
        }

        @Override
        public void forEach(final Consumer consumer) {
            this.reduce(new IFnDef(){

                @Override
                public Object invoke(Object object, Object object2) {
                    consumer.accept(object2);
                    return consumer;
                }
            }, consumer);
        }
    }

    class KeySet
    extends AbstractSet
    implements ITypedReduce {
        KeySet() {
        }

        @Override
        public final int size() {
            return APersistentMapBase.this.size();
        }

        @Override
        public final void clear() {
            APersistentMapBase.this.clear();
        }

        @Override
        public final Iterator iterator() {
            Iterator iterator = APersistentMapBase.this.iterator(BitmapTrieCommon.keyIterFn);
            return iterator;
        }

        @Override
        public final Spliterator spliterator() {
            return APersistentMapBase.this.spliterator(BitmapTrieCommon.keyIterFn);
        }

        @Override
        public final boolean contains(Object object) {
            return APersistentMapBase.this.ht.getNode(object) != null;
        }

        public Object reduce(IFn iFn, Object object) {
            return APersistentMapBase.this.reduce(BitmapTrieCommon.keyIterFn, iFn, object);
        }

        @Override
        public Object parallelReduction(IFn iFn, IFn iFn2, IFn iFn3, ParallelOptions parallelOptions) {
            return Reductions.parallelCollectionReduction(iFn, iFn2, iFn3, this, parallelOptions);
        }

        @Override
        public void forEach(final Consumer consumer) {
            this.reduce(new IFnDef(){

                @Override
                public Object invoke(Object object, Object object2) {
                    consumer.accept(object2);
                    return consumer;
                }
            }, consumer);
        }
    }

    class EntrySet
    extends AbstractSet<Map.Entry>
    implements ITypedReduce<Map.Entry> {
        EntrySet() {
        }

        @Override
        public final int size() {
            return APersistentMapBase.this.size();
        }

        @Override
        public final void clear() {
            APersistentMapBase.this.clear();
        }

        @Override
        public final Iterator<Map.Entry> iterator() {
            Iterator iterator = APersistentMapBase.this.iterator(BitmapTrieCommon.identityIterFn);
            return iterator;
        }

        @Override
        public final void forEach(Consumer consumer) {
            ITypedReduce.super.forEach(consumer);
        }

        @Override
        public final Spliterator<Map.Entry> spliterator() {
            return APersistentMapBase.this.spliterator(BitmapTrieCommon.identityIterFn);
        }

        @Override
        public final boolean contains(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            Object k = entry.getKey();
            BitmapTrieCommon.ILeaf iLeaf = APersistentMapBase.this.ht.getNode(k);
            return iLeaf != null && Objects.equals(iLeaf.key(), k) && Objects.equals(iLeaf.val(), entry.getValue());
        }

        public Object reduce(IFn iFn, Object object) {
            return APersistentMapBase.this.reduce(BitmapTrieCommon.identityIterFn, iFn, object);
        }

        @Override
        public Object parallelReduction(IFn iFn, IFn iFn2, IFn iFn3, ParallelOptions parallelOptions) {
            return Reductions.parallelCollectionReduction(iFn, iFn2, iFn3, this, parallelOptions);
        }
    }
}

