/*
 * Decompiled with CFR 0.152.
 */
package ham_fisted;

import clojure.java.api.Clojure;
import clojure.lang.Delay;
import clojure.lang.IDeref;
import clojure.lang.IFn;
import clojure.lang.IReduceInit;
import clojure.lang.RT;
import ham_fisted.ArrayImmutList;
import ham_fisted.ArrayLists;
import ham_fisted.Casts;
import ham_fisted.ForkJoinPatterns;
import ham_fisted.IFnDef;
import ham_fisted.ParallelOptions;
import ham_fisted.Reducible;
import ham_fisted.StringCollection;
import ham_fisted.Transformables;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.DoubleConsumer;
import java.util.function.LongConsumer;

public class Reductions {
    static final Delay collReducePtr = new Delay((IFn)new IFnDef(){

        @Override
        public Object invoke() {
            return ((IDeref)Clojure.var((Object)"clojure.core.protocols", (Object)"coll-reduce")).deref();
        }
    });
    public static Delay preducePtr = new Delay((IFn)new IFnDef(){

        @Override
        public Object invoke() {
            return ((IDeref)Clojure.var((Object)"ham-fisted.protocols", (Object)"preduce")).deref();
        }
    });

    public static Object unreduce(Object object) {
        return RT.isReduced((Object)object) ? ((IDeref)object).deref() : object;
    }

    public static Iterable toIterable(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Iterable) {
            return (Iterable)object;
        }
        if (object instanceof Map) {
            return ((Map)object).entrySet();
        }
        if (object.getClass().isArray()) {
            return ArrayLists.toList(object);
        }
        if (object instanceof String) {
            return new StringCollection((String)object);
        }
        return (Iterable)RT.seq((Object)object);
    }

    public static Object iterReduce(Object object, IFn iFn) {
        Object object2;
        if (object == null) {
            return iFn.invoke();
        }
        Iterator iterator = Reductions.toIterable(object).iterator();
        Object object3 = object2 = iterator.hasNext() ? (Object)iterator.next() : null;
        while (iterator.hasNext() && !RT.isReduced(object2)) {
            object2 = iFn.invoke(object2, iterator.next());
        }
        return Reductions.unreduce(object2);
    }

    public static Object iterReduce(Object object, Object object2, IFn iFn) {
        if (object == null) {
            return object2;
        }
        Iterator iterator = Reductions.toIterable(object).iterator();
        while (iterator.hasNext() && !RT.isReduced((Object)object2)) {
            object2 = iFn.invoke(object2, iterator.next());
        }
        return Reductions.unreduce(object2);
    }

    public static Reducible reduceReducibles(Iterable<Reducible> iterable) {
        Iterator<Reducible> iterator = iterable.iterator();
        Reducible reducible = iterator.hasNext() ? iterator.next() : null;
        return reducible.reduceIter(iterator);
    }

    public static Object serialReduction(IFn iFn, Object object, Object object2) {
        if (object2 == null) {
            return object;
        }
        if (object2 instanceof IReduceInit) {
            return ((IReduceInit)object2).reduce(iFn, object);
        }
        return ((IFn)collReducePtr.deref()).invoke(object2, (Object)iFn, object);
    }

    public static Object iterableMerge(ParallelOptions parallelOptions, IFn iFn, Iterable iterable) {
        Object object;
        if (parallelOptions.unmergedResult) {
            return iterable;
        }
        Iterator iterator = iterable.iterator();
        Object object2 = object = iterator.hasNext() ? (Object)iterator.next() : null;
        while (iterator.hasNext()) {
            object = iFn.invoke(object, iterator.next());
        }
        return object;
    }

    public static Object parallelIndexGroupReduce(IFn iFn, long l, IFn iFn2, ParallelOptions parallelOptions) {
        return Reductions.iterableMerge(parallelOptions, iFn2, ForkJoinPatterns.parallelIndexGroups(l, iFn, parallelOptions));
    }

    public static Object parallelRandAccessReduction(final IFn iFn, final IFn iFn2, IFn iFn3, final List list, ParallelOptions parallelOptions) {
        return Reductions.parallelIndexGroupReduce(new IFnDef.LLO(){

            public Object invokePrim(long l, long l2) {
                return Reductions.serialReduction(iFn2, iFn.invoke(), list.subList(RT.intCast((long)l), RT.intCast((long)l2)));
            }
        }, list.size(), iFn3, parallelOptions);
    }

    public static Object parallelCollectionReduction(IFn iFn, IFn iFn2, IFn iFn3, Collection collection, ParallelOptions parallelOptions) {
        if ((long)collection.size() <= parallelOptions.minN) {
            return Reductions.serialReduction(iFn2, iFn.invoke(), collection);
        }
        return ForkJoinPatterns.parallelSpliteratorReduce(iFn, iFn2, iFn3, collection.spliterator(), parallelOptions);
    }

    public static Object parallelReduction(IFn iFn, IFn iFn2, IFn iFn3, Object object, ParallelOptions parallelOptions) {
        if (object == null) {
            return parallelOptions.unmergedResult ? ArrayImmutList.create(true, null, iFn.invoke()) : iFn.invoke();
        }
        if (parallelOptions.parallelism < 2) {
            return Reductions.serialParallelReduction(iFn, iFn2, parallelOptions, object);
        }
        return ((IFn)preducePtr.deref()).invoke(object, (Object)iFn, (Object)iFn2, (Object)iFn3, (Object)parallelOptions);
    }

    public static Object serialParallelReduction(IFn iFn, IFn iFn2, ParallelOptions parallelOptions, Object object) {
        Object object2 = Reductions.serialReduction(iFn2, iFn.invoke(), object);
        return parallelOptions.unmergedResult ? ArrayImmutList.create(true, null, object2) : object2;
    }

    public static IFn longCompose(final int n, final Object[] objectArray) {
        return new IFnDef.OLO(){

            public Object invokePrim(Object object, long l) {
                Object[] objectArray2 = (Object[])object;
                for (int i = 0; i < n; ++i) {
                    objectArray2[i] = ((IFn.OLO)objectArray[i]).invokePrim(objectArray2[i], l);
                }
                return objectArray2;
            }
        };
    }

    public static IFn doubleCompose(final int n, final Object[] objectArray) {
        return new IFnDef.ODO(){

            public Object invokePrim(Object object, double d) {
                Object[] objectArray2 = (Object[])object;
                for (int i = 0; i < n; ++i) {
                    objectArray2[i] = ((IFn.ODO)objectArray[i]).invokePrim(objectArray2[i], d);
                }
                return objectArray2;
            }
        };
    }

    public static IFn objCompose(final int n, final Object[] objectArray) {
        return new IFnDef(){

            @Override
            public Object invoke(Object object, Object object2) {
                Object[] objectArray2 = (Object[])object;
                for (int i = 0; i < n; ++i) {
                    objectArray2[i] = ((IFn)objectArray[i]).invoke(objectArray2[i], object2);
                }
                return objectArray2;
            }
        };
    }

    public static IFn mergeCompose(final int n, final Object[] objectArray) {
        return new IFnDef(){

            @Override
            public Object invoke(Object object, Object object2) {
                Object[] objectArray3 = (Object[])object;
                Object[] objectArray2 = (Object[])object2;
                for (int i = 0; i < n; ++i) {
                    objectArray3[i] = ((IFn)objectArray[i]).invoke(objectArray3[i], objectArray2[i]);
                }
                return objectArray3;
            }
        };
    }

    public static Object longSamplerReduction(IFn iFn, Object object, IFn.LL lL, long l) {
        IFn.OLO oLO = Transformables.toLongReductionFn(iFn);
        for (long i = 0L; i < l; ++i) {
            if (!RT.isReduced((Object)(object = oLO.invokePrim(object, lL.invokePrim(i))))) continue;
            return ((IDeref)object).deref();
        }
        return object;
    }

    public static Object doubleSamplerReduction(IFn iFn, Object object, IFn.LD lD, long l) {
        IFn.ODO oDO = Transformables.toDoubleReductionFn(iFn);
        for (long i = 0L; i < l; ++i) {
            if (!RT.isReduced((Object)(object = oDO.invokePrim(object, lD.invokePrim(i))))) continue;
            return ((IDeref)object).deref();
        }
        return object;
    }

    public static Object samplerReduction(IFn iFn, Object object, IFn iFn2, long l) {
        for (long i = 0L; i < l; ++i) {
            if (!RT.isReduced((Object)(object = iFn.invoke(object, iFn2.invoke((Object)i))))) continue;
            return ((IDeref)object).deref();
        }
        return object;
    }

    public static class IndexedAccum
    implements IFnDef {
        long idx;
        final IFn.OLOO rfn;

        public IndexedAccum(long l, IFn.OLOO oLOO) {
            this.rfn = oLOO;
            this.idx = l;
        }

        public IndexedAccum(IFn.OLOO oLOO) {
            this(0L, oLOO);
        }

        @Override
        public Object invoke(Object object, Object object2) {
            return this.rfn.invokePrim(object, this.idx++, object2);
        }
    }

    public static class IndexedLongAccum
    implements IFnDef.OLO {
        long idx;
        final IFn.OLLO rfn;

        public IndexedLongAccum(long l, IFn.OLLO oLLO) {
            this.rfn = oLLO;
            this.idx = l;
        }

        public IndexedLongAccum(IFn.OLLO oLLO) {
            this(0L, oLLO);
        }

        public Object invokePrim(Object object, long l) {
            return this.rfn.invokePrim(object, this.idx++, l);
        }
    }

    public static class IndexedDoubleAccum
    implements IFnDef.ODO {
        long idx;
        final IFn.OLDO rfn;

        public IndexedDoubleAccum(long l, IFn.OLDO oLDO) {
            this.rfn = oLDO;
            this.idx = l;
        }

        public IndexedDoubleAccum(IFn.OLDO oLDO) {
            this(0L, oLDO);
        }

        public Object invokePrim(Object object, double d) {
            return this.rfn.invokePrim(object, this.idx++, d);
        }
    }

    public static class ReduceConsumer
    implements Consumer,
    IDeref {
        Object init;
        public final IFn rfn;

        public ReduceConsumer(Object object, IFn iFn) {
            this.init = object;
            this.rfn = iFn;
        }

        public void accept(Object object) {
            if (!this.isReduced()) {
                this.init = this.rfn.invoke(this.init, object);
            }
        }

        public boolean isReduced() {
            return RT.isReduced((Object)this.init);
        }

        public Object deref() {
            return this.init;
        }

        public static ReduceConsumer create(Object object, IFn iFn) {
            if (iFn instanceof IFn.ODO) {
                return new DoubleReduceConsumer(object, iFn);
            }
            if (iFn instanceof IFn.OLO) {
                return new LongReduceConsumer(object, iFn);
            }
            return new ReduceConsumer(object, iFn);
        }

        public static class LongReduceConsumer
        extends ReduceConsumer
        implements LongConsumer {
            public final IFn.OLO dfn;

            public LongReduceConsumer(Object object, IFn iFn) {
                super(object, iFn);
                this.dfn = (IFn.OLO)iFn;
            }

            @Override
            public void accept(Object object) {
                this.accept(Casts.longCast(object));
            }

            @Override
            public void accept(long l) {
                if (!this.isReduced()) {
                    this.init = this.dfn.invokePrim(this.init, l);
                }
            }
        }

        public static class DoubleReduceConsumer
        extends ReduceConsumer
        implements DoubleConsumer {
            public final IFn.ODO dfn;

            public DoubleReduceConsumer(Object object, IFn iFn) {
                super(object, iFn);
                this.dfn = (IFn.ODO)iFn;
            }

            @Override
            public void accept(Object object) {
                this.accept(Casts.doubleCast(object));
            }

            @Override
            public void accept(double d) {
                if (!this.isReduced()) {
                    this.init = this.dfn.invokePrim(this.init, d);
                }
            }
        }
    }

    public static interface LongAccum
    extends IFnDef.OLO {
    }

    public static interface DoubleAccum
    extends IFnDef.ODO {
    }
}

