/*
 * Decompiled with CFR 0.152.
 */
package ham_fisted;

import clojure.lang.IEditableCollection;
import clojure.lang.IFn;
import clojure.lang.IHashEq;
import clojure.lang.IKVReduce;
import clojure.lang.IMapEntry;
import clojure.lang.IObj;
import clojure.lang.IPersistentMap;
import clojure.lang.IPersistentVector;
import clojure.lang.IReduce;
import clojure.lang.ISeq;
import clojure.lang.ITransientVector;
import clojure.lang.Indexed;
import clojure.lang.MapEntry;
import clojure.lang.RT;
import clojure.lang.Reversible;
import clojure.lang.Seqable;
import clojure.lang.Util;
import ham_fisted.ArrayImmutList;
import ham_fisted.ChunkedList;
import ham_fisted.CljHash;
import ham_fisted.IFnDef;
import ham_fisted.ImmutValues;
import ham_fisted.MutList;
import ham_fisted.Transformables;
import ham_fisted.TransientList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.RandomAccess;
import java.util.function.BiFunction;

public class ImmutList
implements List,
RandomAccess,
Indexed,
IFnDef,
IReduce,
IKVReduce,
IHashEq,
Seqable,
Reversible,
ChunkedList.ChunkedListOwner,
IPersistentVector,
IObj,
IEditableCollection,
ImmutValues {
    public final int startidx;
    public final int nElems;
    final ChunkedList data;
    int _hash = 0;
    public static final ImmutList EMPTY = new ImmutList(0, 0, new ChunkedList());

    ImmutList(int n, int n2, ChunkedList chunkedList) {
        this.startidx = n;
        this.nElems = n2 - n;
        this.data = chunkedList;
    }

    public static IPersistentVector create(boolean bl, IPersistentMap iPersistentMap, Object ... objectArray) {
        if (objectArray.length <= 32) {
            return ArrayImmutList.create(bl, iPersistentMap, objectArray);
        }
        return new ImmutList(0, objectArray.length, ChunkedList.create(bl, iPersistentMap, objectArray));
    }

    final int indexCheck(int n) {
        return ChunkedList.indexCheck(this.startidx, this.nElems, n);
    }

    final int wrapIndexCheck(int n) {
        return ChunkedList.wrapIndexCheck(this.startidx, this.nElems, n);
    }

    @Override
    public ChunkedList.ChunkedListSection getChunkedList() {
        return new ChunkedList.ChunkedListSection(this.data.data, this.startidx, this.startidx + this.nElems);
    }

    @Override
    public final int hashCode() {
        if (this._hash == 0) {
            this._hash = this.data.hasheq(this.startidx, this.startidx + this.nElems);
        }
        return this._hash;
    }

    public final int hasheq() {
        return this.hashCode();
    }

    @Override
    public final boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        return this.equiv(object);
    }

    public final String toString() {
        return Transformables.sequenceToString(this);
    }

    public final boolean equiv(Object object) {
        return CljHash.listEquiv(this, object);
    }

    @Override
    public final int size() {
        return this.nElems;
    }

    public final int count() {
        return this.nElems;
    }

    public final int length() {
        return this.nElems;
    }

    @Override
    public final void clear() {
        throw new RuntimeException("Unimplemented");
    }

    @Override
    public final boolean add(Object object) {
        throw new RuntimeException("Unimplemented");
    }

    public final void add(int n, Object object) {
        throw new RuntimeException("Unimplemented");
    }

    @Override
    public final boolean addAll(Collection collection) {
        throw new RuntimeException("Unimplemented");
    }

    public final boolean addAll(int n, Collection collection) {
        throw new RuntimeException("Unimplemented");
    }

    public final Object remove(int n) {
        throw new RuntimeException("Unimplemented");
    }

    @Override
    public final boolean remove(Object object) {
        throw new RuntimeException("Unimplemented");
    }

    @Override
    public final boolean removeAll(Collection collection) {
        throw new RuntimeException("Unimplemented");
    }

    @Override
    public final boolean retainAll(Collection collection) {
        throw new RuntimeException("Unimplemented");
    }

    @Override
    public final boolean isEmpty() {
        return this.nElems == 0;
    }

    public final Object set(int n, Object object) {
        throw new RuntimeException("Unimplemented");
    }

    public final Object get(int n) {
        return this.data.getValue(this.indexCheck(n));
    }

    @Override
    public final int indexOf(Object object) {
        return this.data.indexOf(this.startidx, this.startidx + this.nElems, object);
    }

    @Override
    public final int lastIndexOf(Object object) {
        return this.data.lastIndexOf(this.startidx, this.startidx + this.nElems, object);
    }

    @Override
    public final boolean contains(Object object) {
        return this.data.contains(this.startidx, this.startidx + this.nElems, object);
    }

    @Override
    public final boolean containsAll(Collection collection) {
        return this.data.containsAll(this.startidx, this.startidx + this.nElems, collection);
    }

    @Override
    public final Iterator iterator() {
        return this.data.iterator(this.startidx, this.startidx + this.nElems);
    }

    public final ListIterator listIterator(int n) {
        throw new RuntimeException("unchecked");
    }

    public final ListIterator listIterator() {
        return this.listIterator(0);
    }

    public final List subList(int n, int n2) {
        if (n == 0 && n2 == this.startidx + this.nElems) {
            return this;
        }
        ChunkedList.checkIndexRange(this.startidx, this.nElems, n, n2);
        return new ImmutList(n + this.startidx, n2 + this.startidx, this.data);
    }

    @Override
    public final Object[] toArray() {
        return this.data.toArray(this.startidx, this.startidx + this.nElems);
    }

    @Override
    public final Object[] toArray(Object[] objectArray) {
        return this.data.fillArray(this.startidx, this.startidx + this.nElems, Arrays.copyOf(objectArray, this.nElems));
    }

    public IPersistentMap meta() {
        return this.data.meta();
    }

    public ImmutList withMeta(IPersistentMap iPersistentMap) {
        return new ImmutList(this.startidx, this.startidx + this.nElems, this.data.withMeta(iPersistentMap));
    }

    public final Object nth(int n) {
        return this.data.getValue(this.wrapIndexCheck(n));
    }

    public final Object nth(int n, Object object) {
        if (n < 0) {
            n += this.nElems;
        }
        return this.data.getValue(this.indexCheck(n));
    }

    @Override
    public final Object invoke(Object object) {
        return this.nth(RT.intCast((Object)object));
    }

    @Override
    public final Object invoke(Object object, Object object2) {
        return this.nth(RT.intCast((Object)object), object2);
    }

    public final Object reduce(IFn iFn) {
        return this.data.reduce(this.startidx, this.startidx + this.nElems, iFn);
    }

    public final Object reduce(IFn iFn, Object object) {
        return this.data.reduce(this.startidx, this.startidx + this.nElems, iFn, object);
    }

    public final Object kvreduce(IFn iFn, Object object) {
        return this.data.kvreduce(this.startidx, this.startidx + this.nElems, iFn, object);
    }

    public final ISeq seq() {
        return this.data.seq(this.startidx, this.startidx + this.nElems);
    }

    public final ISeq rseq() {
        return this.data.rseq(this.startidx, this.startidx + this.nElems);
    }

    public final ImmutList cons(Object object) {
        return new ImmutList(0, this.nElems + 1, this.data.conj(this.startidx, this.startidx + this.nElems, object));
    }

    public final ImmutList assocN(int n, Object object) {
        if (n == this.nElems) {
            return this.cons(object);
        }
        this.indexCheck(n);
        return new ImmutList(0, this.nElems, this.data.assoc(this.startidx, this.startidx + this.nElems, n, object));
    }

    public final ImmutList assoc(Object object, Object object2) {
        return this.assocN(RT.intCast((Object)object), object2);
    }

    public final IMapEntry entryAt(Object object) {
        if (Util.isInteger((Object)object)) {
            int n = RT.intCast((Object)object);
            return MapEntry.create((Object)n, (Object)this.data.getValue(n + this.startidx));
        }
        return null;
    }

    public final boolean containsKey(Object object) {
        if (Util.isInteger((Object)object)) {
            int n = RT.intCast((Object)object);
            return n >= 0 && n < this.nElems;
        }
        return false;
    }

    public final ImmutList empty() {
        return EMPTY.withMeta(this.meta());
    }

    public final Object valAt(Object object, Object object2) {
        int n;
        if (Util.isInteger((Object)object) && (n = RT.intCast((Object)object)) >= 0 && n < this.nElems) {
            return this.data.getValue(n + this.startidx);
        }
        return object2;
    }

    public final Object valAt(Object object) {
        return this.valAt(object, null);
    }

    public final ImmutList pop() {
        if (this.nElems == 0) {
            throw new RuntimeException("Can't pop empty vector");
        }
        if (this.nElems == 1) {
            return EMPTY.withMeta(this.meta());
        }
        return new ImmutList(0, this.nElems - 1, this.data.pop(this.startidx, this.startidx + this.nElems));
    }

    public final Object peek() {
        if (this.nElems == 0) {
            return null;
        }
        return this.get(this.nElems - 1);
    }

    @Override
    public ImmutList immutUpdateValues(BiFunction biFunction) {
        ChunkedList chunkedList = this.data.clone(this.startidx, this.startidx + this.nElems, 0, true);
        Object[][] objectArray = chunkedList.data;
        int n = this.nElems;
        int n2 = 0;
        while (n2 < n) {
            Object[] objectArray2 = objectArray[n2 / 32];
            int n3 = Math.min(n - n2, objectArray2.length);
            int n4 = 0;
            while (n4 < n3) {
                objectArray2[n4] = biFunction.apply(n2, objectArray2[n4]);
                ++n4;
                ++n2;
            }
        }
        return new ImmutList(0, n, chunkedList);
    }

    @Override
    public ImmutList immutUpdateValue(Object object, IFn iFn) {
        if (!Util.isInteger((Object)object)) {
            throw new RuntimeException("Vector indexes must be integers: " + String.valueOf(object));
        }
        int n = RT.intCast((Object)object);
        if (n == this.nElems) {
            return this.cons(iFn.invoke(null));
        }
        this.indexCheck(n);
        ChunkedList chunkedList = this.data.clone(this.startidx, this.startidx + this.nElems, 0, false);
        Object[][] objectArray = chunkedList.data;
        int n2 = n / 32;
        int n3 = n % 32;
        Object[] objectArray2 = (Object[])objectArray[n2].clone();
        objectArray[n2] = objectArray2;
        objectArray2[n3] = iFn.invoke(objectArray2[n3]);
        return new ImmutList(0, this.nElems, chunkedList);
    }

    public final ITransientVector asTransient() {
        if (this.nElems == 0) {
            return new MutList();
        }
        boolean bl = this.startidx % 32 != 0;
        return new TransientList(this.data.clone(this.startidx, this.startidx + this.nElems, 0, false), this.nElems, bl);
    }
}

