/*
 * Decompiled with CFR 0.152.
 */
package ham_fisted;

import clojure.lang.IDeref;
import clojure.lang.IFn;
import clojure.lang.IPersistentMap;
import clojure.lang.IReduceInit;
import clojure.lang.RT;
import ham_fisted.BitmapTrieCommon;
import ham_fisted.IntegerOps;
import ham_fisted.LeafNode;
import ham_fisted.MapData;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Spliterator;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;

public final class HashTable
implements BitmapTrieCommon.TrieBase,
MapData {
    final BitmapTrieCommon.HashProvider hp;
    int capacity;
    int mask;
    int length;
    int threshold;
    float loadFactor;
    LeafNode[] data;
    IPersistentMap meta;

    public HashTable(BitmapTrieCommon.HashProvider hashProvider, float f, int n, int n2, LeafNode[] leafNodeArray, IPersistentMap iPersistentMap) {
        this.hp = hashProvider;
        this.loadFactor = f;
        this.capacity = IntegerOps.nextPow2(Math.max(4, n));
        this.mask = this.capacity - 1;
        this.length = n2;
        this.data = leafNodeArray == null ? new LeafNode[this.capacity] : leafNodeArray;
        this.meta = iPersistentMap;
        this.threshold = (int)((float)this.capacity * f);
    }

    @Override
    public BitmapTrieCommon.HashProvider hashProvider() {
        return this.hp;
    }

    @Override
    public int hash(Object object) {
        return this.hp.hash(object);
    }

    @Override
    public boolean equals(Object object, Object object2) {
        return this.hp.equals(object, object2);
    }

    @Override
    public void inc() {
        ++this.length;
    }

    @Override
    public void dec() {
        --this.length;
    }

    @Override
    public int size() {
        return this.length;
    }

    @Override
    public boolean isEmpty() {
        return this.length == 0;
    }

    @Override
    public HashTable shallowClone() {
        return new HashTable(this.hp, this.loadFactor, this.capacity, this.length, (LeafNode[])this.data.clone(), this.meta);
    }

    @Override
    public HashTable clone() {
        HashTable hashTable = this.shallowClone();
        hashTable.length = 0;
        int n = hashTable.data.length;
        LeafNode[] leafNodeArray = hashTable.data;
        for (int i = 0; i < n; ++i) {
            LeafNode leafNode = leafNodeArray[i];
            if (leafNode == null) continue;
            leafNodeArray[i] = leafNode.clone(hashTable);
        }
        return hashTable;
    }

    Object checkResize(Object object) {
        if (this.length >= this.threshold) {
            int n = this.capacity * 2;
            LeafNode[] leafNodeArray = new LeafNode[n];
            LeafNode[] leafNodeArray2 = this.data;
            int n2 = leafNodeArray2.length;
            int n3 = n - 1;
            for (int i = 0; i < n2; ++i) {
                LeafNode leafNode = leafNodeArray2[i];
                if (leafNode == null) continue;
                leafNodeArray2[i] = null;
                if (leafNode.nextNode == null) {
                    leafNodeArray[leafNode.hashcode & n3] = leafNode;
                    continue;
                }
                LeafNode leafNode2 = null;
                LeafNode leafNode3 = null;
                LeafNode leafNode4 = null;
                LeafNode leafNode5 = null;
                while (leafNode != null) {
                    LeafNode leafNode6 = leafNode;
                    leafNode = leafNode.nextNode;
                    if ((leafNode6.hashcode & n2) == 0) {
                        if (leafNode3 == null) {
                            leafNode2 = leafNode6;
                        } else {
                            leafNode3.nextNode = leafNode6;
                        }
                        leafNode3 = leafNode6;
                        continue;
                    }
                    if (leafNode5 == null) {
                        leafNode4 = leafNode6;
                    } else {
                        leafNode5.nextNode = leafNode6;
                    }
                    leafNode5 = leafNode6;
                }
                if (leafNode2 != null) {
                    leafNode3.nextNode = null;
                    leafNodeArray[i] = leafNode2;
                }
                if (leafNode4 == null) continue;
                leafNode5.nextNode = null;
                leafNodeArray[i + n2] = leafNode4;
            }
            this.capacity = n;
            this.threshold = (int)((float)n * this.loadFactor);
            this.mask = n3;
            this.data = leafNodeArray;
        }
        return object;
    }

    @Override
    public LeafNode getOrCreate(Object object) {
        int n = this.hp.hash(object);
        int n2 = n & this.mask;
        BitmapTrieCommon.HashProvider hashProvider = this.hp;
        LeafNode leafNode = null;
        LeafNode leafNode2 = this.data[n2];
        while (leafNode2 != null) {
            leafNode = leafNode2;
            if (hashProvider.equals(leafNode2.k, object)) {
                return leafNode2;
            }
            leafNode2 = leafNode2.nextNode;
        }
        if (leafNode != null) {
            return (LeafNode)this.checkResize(leafNode.getOrCreate(object, n));
        }
        this.data[n2] = leafNode = new LeafNode(this, object, n, null, null);
        return (LeafNode)this.checkResize(leafNode);
    }

    @Override
    public LeafNode getNode(Object object) {
        int n = this.hp.hash(object);
        int n2 = n & this.mask;
        LeafNode leafNode = this.data[n2];
        return leafNode != null ? leafNode.get(object) : null;
    }

    @Override
    public Object getOrDefault(Object object, Object object2) {
        LeafNode leafNode = this.data[this.hp.hash(object) & this.mask];
        while (leafNode != null) {
            Object object3 = leafNode.k;
            if (object3 == object || this.hp.equals(object3, object)) {
                return leafNode.v;
            }
            leafNode = leafNode.nextNode;
        }
        return object2;
    }

    @Override
    public Object get(Object object) {
        LeafNode leafNode = this.data[this.hp.hash(object) & this.mask];
        while (leafNode != null) {
            Object object2 = leafNode.k;
            if (object2 == object || this.hp.equals(object2, object)) {
                return leafNode.v;
            }
            leafNode = leafNode.nextNode;
        }
        return null;
    }

    @Override
    public Object compute(Object object, BiFunction biFunction) {
        BitmapTrieCommon.HashProvider hashProvider = this.hp;
        int n = hashProvider.hash(object);
        LeafNode[] leafNodeArray = this.data;
        int n2 = n & this.mask;
        LeafNode leafNode = leafNodeArray[n2];
        LeafNode leafNode2 = null;
        while (leafNode != null && leafNode.k != object && !hashProvider.equals(leafNode.k, object)) {
            leafNode2 = leafNode;
            leafNode = leafNode.nextNode;
        }
        Object r = biFunction.apply(object, leafNode == null ? null : leafNode.v);
        if (leafNode != null) {
            if (r != null) {
                leafNode.v = r;
            } else {
                this.remove(object, null);
            }
        } else if (r != null) {
            LeafNode leafNode3 = new LeafNode(this, object, n, r, null);
            if (leafNode2 != null) {
                leafNode2.nextNode = leafNode3;
            } else {
                leafNodeArray[n2] = leafNode3;
            }
            this.checkResize(null);
        }
        return r;
    }

    @Override
    public Object computeIfAbsent(Object object, Function function) {
        BitmapTrieCommon.HashProvider hashProvider = this.hp;
        int n = hashProvider.hash(object);
        LeafNode[] leafNodeArray = this.data;
        int n2 = n & this.mask;
        LeafNode leafNode = leafNodeArray[n2];
        LeafNode leafNode2 = null;
        while (leafNode != null && leafNode.k != object && !hashProvider.equals(leafNode.k, object)) {
            leafNode2 = leafNode;
            leafNode = leafNode.nextNode;
        }
        if (leafNode != null) {
            return leafNode.v;
        }
        Object r = function.apply(object);
        if (r != null) {
            LeafNode leafNode3 = new LeafNode(this, object, n, r, null);
            if (leafNode2 != null) {
                leafNode2.nextNode = leafNode3;
            } else {
                leafNodeArray[n2] = leafNode3;
            }
            this.checkResize(null);
        }
        return r;
    }

    @Override
    public Object merge(Object object, Object object2, BiFunction biFunction) {
        Object object3;
        BitmapTrieCommon.HashProvider hashProvider = this.hp;
        int n = hashProvider.hash(object);
        LeafNode[] leafNodeArray = this.data;
        int n2 = n & this.mask;
        LeafNode leafNode = leafNodeArray[n2];
        LeafNode leafNode2 = null;
        while (leafNode != null && leafNode.k != object && !hashProvider.equals(leafNode.k, object)) {
            leafNode2 = leafNode;
            leafNode = leafNode.nextNode;
        }
        Object object4 = object3 = leafNode == null ? object2 : biFunction.apply(leafNode.v, object2);
        if (leafNode != null) {
            if (object3 != null) {
                leafNode.v = object3;
            } else {
                this.remove(object, null);
            }
        } else if (object3 != null) {
            LeafNode leafNode3 = new LeafNode(this, object, n, object3, null);
            if (leafNode2 != null) {
                leafNode2.nextNode = leafNode3;
            } else {
                leafNodeArray[n2] = leafNode3;
            }
            this.checkResize(null);
        }
        return object3;
    }

    @Override
    public void remove(Object object, BitmapTrieCommon.Box box) {
        int n = this.hp.hash(object);
        int n2 = n & this.mask;
        LeafNode leafNode = this.data[n2];
        if (leafNode != null) {
            this.data[n2] = leafNode.remove(object, box);
        }
    }

    @Override
    public void clear() {
        this.length = 0;
        Arrays.fill(this.data, null);
    }

    @Override
    public HashTable mutAssoc(Object object, Object object2) {
        int n = this.hp.hash(object);
        int n2 = n & this.mask;
        LeafNode leafNode = this.data[n2];
        LeafNode leafNode2 = leafNode != null ? leafNode.assoc(this, object, n, object2) : new LeafNode(this, object, n, object2, null);
        this.data[n2] = leafNode2;
        this.checkResize(null);
        return this;
    }

    @Override
    public void mutDissoc(Object object) {
        int n = this.hp.hash(object);
        int n2 = n & this.mask;
        LeafNode leafNode = this.data[n2];
        if (leafNode != null) {
            this.data[n2] = leafNode.dissoc(this, object);
        }
    }

    @Override
    public Object reduce(Function<BitmapTrieCommon.ILeaf, Object> function, IFn iFn, Object object) {
        for (LeafNode leafNode : this.data) {
            while (leafNode != null) {
                if (RT.isReduced((Object)(object = iFn.invoke(object, function.apply(leafNode))))) {
                    return ((IDeref)object).deref();
                }
                leafNode = leafNode.nextNode;
            }
        }
        return object;
    }

    @Override
    public void mutUpdateValues(BiFunction biFunction) {
        for (LeafNode leafNode : this.data) {
            var2_2[var4_4] = leafNode.immutUpdate(this, biFunction);
        }
    }

    @Override
    public HashTable mutUpdateValue(Object object, IFn iFn) {
        int n = this.hp.hash(object);
        int n2 = n & this.mask;
        LeafNode leafNode = this.data[n2];
        LeafNode leafNode2 = leafNode != null ? leafNode.immutUpdate(this, object, n, iFn) : new LeafNode(this, object, n, iFn.invoke(null));
        this.data[n2] = leafNode2;
        this.checkResize(null);
        return this;
    }

    @Override
    public Iterator iterator(Function<BitmapTrieCommon.ILeaf, Object> function) {
        return new HTIter(this.data, function);
    }

    @Override
    public Spliterator spliterator(Function<BitmapTrieCommon.ILeaf, Object> function) {
        return new HTSpliterator(this.data, this.length, function);
    }

    @Override
    public IPersistentMap meta() {
        return this.meta;
    }

    @Override
    public HashTable withMeta(IPersistentMap iPersistentMap) {
        HashTable hashTable = this.shallowClone();
        hashTable.meta = iPersistentMap;
        return hashTable;
    }

    static class HTSpliterator
    implements Spliterator,
    IReduceInit {
        final LeafNode[] d;
        final Function<BitmapTrieCommon.ILeaf, Object> fn;
        int sidx;
        int eidx;
        int estimateSize;
        LeafNode l;

        public HTSpliterator(LeafNode[] leafNodeArray, int n, Function<BitmapTrieCommon.ILeaf, Object> function) {
            this.d = leafNodeArray;
            this.fn = function;
            this.sidx = 0;
            this.eidx = leafNodeArray.length;
            this.estimateSize = n;
            this.l = null;
        }

        public HTSpliterator(LeafNode[] leafNodeArray, int n, int n2, int n3, Function<BitmapTrieCommon.ILeaf, Object> function) {
            this.d = leafNodeArray;
            this.fn = function;
            this.sidx = n;
            this.eidx = n2;
            this.estimateSize = n3;
            this.l = null;
        }

        public HTSpliterator trySplit() {
            int n = this.eidx - this.sidx;
            if (n > 4) {
                int n2 = n / 2;
                int n3 = this.eidx;
                this.eidx = this.sidx + n2;
                this.estimateSize /= 2;
                return new HTSpliterator(this.d, this.eidx, n3, this.estimateSize, this.fn);
            }
            return null;
        }

        @Override
        public int characteristics() {
            return 1089;
        }

        @Override
        public long estimateSize() {
            return this.estimateSize;
        }

        @Override
        public long getExactSizeIfKnown() {
            return this.estimateSize();
        }

        public boolean tryAdvance(Consumer consumer) {
            if (this.l != null) {
                consumer.accept(this.fn.apply(this.l));
                this.l = this.l.nextNode;
                return true;
            }
            while (this.sidx < this.eidx) {
                LeafNode leafNode = this.d[this.sidx];
                if (leafNode != null) {
                    consumer.accept(this.fn.apply(leafNode));
                    this.l = leafNode.nextNode;
                    return true;
                }
                ++this.sidx;
            }
            return false;
        }

        public Object reduce(IFn iFn, Object object) {
            LeafNode[] leafNodeArray = this.d;
            int n = this.eidx;
            Function<BitmapTrieCommon.ILeaf, Object> function = this.fn;
            for (int i = this.sidx; i < n; ++i) {
                LeafNode leafNode = leafNodeArray[i];
                while (leafNode != null) {
                    if (RT.isReduced((Object)(object = iFn.invoke(object, function.apply(leafNode))))) {
                        return ((IDeref)object).deref();
                    }
                    leafNode = leafNode.nextNode;
                }
            }
            return object;
        }
    }

    static class HTIter
    implements Iterator {
        final LeafNode[] d;
        final Function<BitmapTrieCommon.ILeaf, Object> fn;
        LeafNode l;
        int idx;
        final int dlen;

        HTIter(LeafNode[] leafNodeArray, Function<BitmapTrieCommon.ILeaf, Object> function) {
            this.d = leafNodeArray;
            this.fn = function;
            this.l = null;
            this.idx = 0;
            this.dlen = this.d.length;
            this.advance();
        }

        void advance() {
            if (this.l != null) {
                this.l = this.l.nextNode;
            }
            if (this.l == null) {
                while (this.idx < this.dlen && this.l == null) {
                    this.l = this.d[this.idx];
                    ++this.idx;
                }
            }
        }

        @Override
        public boolean hasNext() {
            return this.l != null;
        }

        public Object next() {
            LeafNode leafNode = this.l;
            this.advance();
            return this.fn.apply(leafNode);
        }
    }
}

