/*
 * Decompiled with CFR 0.152.
 */
package ham_fisted;

import clojure.lang.IFn;
import clojure.lang.IHashEq;
import clojure.lang.RT;
import clojure.lang.Util;
import ham_fisted.CljHash;
import ham_fisted.IntegerOps;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Objects;
import java.util.function.BiFunction;

public class BitmapTrieCommon {
    public static final HashProvider equalHashProvider = new HashProvider(){};
    public static final HashProvider equivHashProvider = new HashProvider(){

        @Override
        public int hash(Object object) {
            return Util.hasheq((Object)object);
        }

        @Override
        public boolean equals(Object object, Object object2) {
            return CljHash.equiv(object, object2);
        }
    };
    public static final HashProvider hybridHashProvider;
    public static final HashProvider defaultHashProvider;
    public static final BiFunction<Object, Object, Object> rhsWins;
    public static final BiFunction<Object, Object, Object> lhsWins;
    public static final BiFunction<Object, Object, Object> nonNilWins;
    public static final BiFunction<Long, Long, Long> sumBiFn;
    public static final BiFunction<Object, Long, Long> incBiFn;

    static final <V> V[] insert(V[] VArray, V v, int n, int n2, boolean bl) {
        int n3 = VArray.length;
        int n4 = IntegerOps.nextPow2(n2);
        boolean bl2 = bl | n4 > n3;
        V[] VArray2 = bl2 ? Arrays.copyOf(VArray, n4) : VArray;
        for (int i = n2 - 1; i > n; --i) {
            VArray2[i] = VArray[i - 1];
        }
        VArray2[n] = v;
        return VArray2;
    }

    static final <V> V[] remove(V[] VArray, int n, int n2, boolean bl) {
        V[] VArray2 = bl ? Arrays.copyOf(VArray, Math.max(4, IntegerOps.nextPow2(n2))) : VArray;
        for (int i = n; i < n2; ++i) {
            VArray2[i] = VArray[i + 1];
        }
        if (VArray2.length > n2) {
            VArray2[n2] = null;
        }
        return VArray2;
    }

    static {
        defaultHashProvider = hybridHashProvider = new HashProvider(){

            @Override
            public int hash(Object object) {
                if (object instanceof IHashEq) {
                    return ((IHashEq)object).hasheq();
                }
                if (object == null) {
                    return 0;
                }
                return IntegerOps.mixhash(object.hashCode());
            }

            @Override
            public boolean equals(Object object, Object object2) {
                return CljHash.equiv(object, object2);
            }
        };
        rhsWins = (object, object2) -> object2;
        lhsWins = (object, object2) -> object;
        nonNilWins = (object, object2) -> object == null ? object2 : object;
        sumBiFn = (l, l2) -> l + l2;
        incBiFn = (object, l) -> l == null ? 1L : 1L + l;
    }

    static interface INode {
        public INode clone(TrieBase var1);

        public INode valueClone(TrieBase var1, Iterator var2);

        public int countLeaves();

        public LeafNodeIterator iterator();

        public ILeaf get(Object var1, int var2);

        public INode dissoc(TrieBase var1, Object var2, int var3);

        public INode immutUpdate(TrieBase var1, BiFunction var2);

        public INode immutUpdate(TrieBase var1, Object var2, int var3, IFn var4);
    }

    public static interface MapSet {
        public MapSet intersection(MapSet var1, BiFunction var2);

        public MapSet union(MapSet var1, BiFunction var2);

        public MapSet difference(MapSet var1);
    }

    static interface LeafNodeIterator
    extends Iterator {
        public ILeaf nextLeaf();

        default public Object next() {
            return this.nextLeaf();
        }
    }

    public static interface ILeaf {
        public Object key();

        public Object val();

        public Object val(Object var1);
    }

    public static final class Box {
        public Object obj;

        public Box() {
            this.obj = null;
        }

        public Box(Object object) {
            this.obj = object;
        }

        public void inplaceUpdate(BiFunction biFunction, Object object) {
            this.obj = this.obj == null ? object : biFunction.apply(this.obj, object);
        }

        public Box inplaceReduce(IFn iFn, Object object) {
            this.obj = RT.isReduced((Object)this.obj) ? this.obj : iFn.invoke(this.obj, object);
            return this;
        }

        public Box inplaceMerge(IFn iFn, Box box) {
            this.obj = iFn.invoke(this.obj, box.obj);
            return this;
        }
    }

    static interface TrieBase
    extends HashProvider {
        public void inc();

        public void dec();
    }

    public static interface HashProvider {
        default public int hash(Object object) {
            if (object != null) {
                return IntegerOps.mixhash(object);
            }
            return 0;
        }

        default public boolean equals(Object object, Object object2) {
            return Objects.equals(object, object2);
        }
    }
}

