/*
 * Decompiled with CFR 0.152.
 */
package ham_fisted;

import clojure.lang.IFn;
import clojure.lang.RT;
import ham_fisted.ArrayLists;
import ham_fisted.Casts;
import ham_fisted.ChunkedList;
import ham_fisted.IFnDef;
import ham_fisted.IMutList;
import ham_fisted.Reductions;
import ham_fisted.Transformables;
import it.unimi.dsi.fastutil.ints.IntComparator;
import it.unimi.dsi.fastutil.longs.LongArrays;
import it.unimi.dsi.fastutil.longs.LongComparator;
import java.util.Comparator;
import java.util.List;
import java.util.Random;

public interface LongMutList
extends IMutList<Object> {
    @Override
    default public boolean add(Object object) {
        this.addLong(Casts.longCast(object));
        return true;
    }

    @Override
    default public void addLong(long l) {
        throw new RuntimeException("Object " + String.valueOf(this.getClass()) + " failed to define addLong method");
    }

    default public void addBoolean(boolean bl) {
        this.addLong(bl ? 1L : 0L);
    }

    @Override
    default public void addDouble(double d) {
        this.addLong(Casts.longCast(d));
    }

    @Override
    default public Object set(int n, Object object) {
        long l = this.getLong(n);
        this.setLong(n, Casts.longCast(object));
        return l;
    }

    default public void setBoolean(int n, boolean bl) {
        this.setLong(n, bl ? 1L : 0L);
    }

    @Override
    default public void setDouble(int n, double d) {
        this.setLong(n, Casts.longCast(d));
    }

    @Override
    default public Object get(int n) {
        return this.getLong(n);
    }

    @Override
    default public double getDouble(int n) {
        return this.getLong(n);
    }

    @Override
    default public void fillRange(long l, long l2, Object object) {
        ChunkedList.checkIndexRange(0L, (long)this.size(), l, l2);
        long l3 = Casts.longCast(object);
        int n = (int)l2;
        for (int i = (int)l; i < n; ++i) {
            this.setLong(i, l3);
        }
    }

    @Override
    default public IMutList<Object> subList(int n, int n2) {
        ChunkedList.sublistCheck(n, n2, this.size());
        return new LongSubList((IMutList)this, n, n2);
    }

    @Override
    default public void fillRange(long l, List list) {
        if (list.isEmpty()) {
            return;
        }
        final int n = (int)l;
        int n2 = this.size();
        int n3 = n + list.size();
        ArrayLists.checkIndexRange(this.size(), n, n3);
        Reductions.serialReduction(new Reductions.IndexedLongAccum(new IFnDef.OLLO(){

            public Object invokePrim(Object object, long l, long l2) {
                ((IMutList)object).setLong((int)l + n, l2);
                return object;
            }
        }), this, list);
    }

    default public void addRange(int n, int n2, Object object) {
        Long l = Casts.longCast(object);
        while (n < n2) {
            this.add(n, l);
            ++n;
        }
    }

    @Override
    default public boolean addAllReducible(Object object) {
        int n = this.size();
        Reductions.serialReduction(new IFnDef.OLO(){

            public Object invokePrim(Object object, long l) {
                ((IMutList)object).addLong(l);
                return object;
            }
        }, this, object);
        return n != this.size();
    }

    @Override
    default public IntComparator indexComparator() {
        return new IntComparator(){

            public int compare(int n, int n2) {
                return Long.compare(LongMutList.this.getLong(n), LongMutList.this.getLong(n2));
            }
        };
    }

    @Override
    default public void sort(Comparator<? super Object> comparator) {
        LongComparator longComparator = ArrayLists.LongArraySubList.asLongComparator(comparator);
        if (comparator == null || longComparator != null) {
            long[] lArray = this.toLongArray();
            if (comparator == null) {
                LongArrays.parallelQuickSort((long[])lArray);
            } else {
                LongArrays.parallelQuickSort((long[])lArray, (LongComparator)longComparator);
            }
            this.fillRange(0L, ArrayLists.toList(lArray));
        } else {
            IMutList.super.sort(comparator);
        }
    }

    @Override
    default public void shuffle(Random random) {
        this.fillRange(0L, this.immutShuffle(random));
    }

    @Override
    default public List immutShuffle(Random random) {
        long[] lArray = this.toLongArray();
        LongArrays.shuffle((long[])lArray, (Random)random);
        return ArrayLists.toList(lArray);
    }

    @Override
    default public Object reduce(IFn iFn, Object object) {
        return this.longReduction(Transformables.toLongReductionFn(iFn), object);
    }

    default public Object longReduction(IFn.OLO oLO, Object object) {
        int n = this.size();
        for (int i = 0; i < n && !RT.isReduced((Object)object); ++i) {
            object = oLO.invokePrim(object, this.getLong(i));
        }
        return object;
    }

    public static class LongSubList
    extends IMutList.MutSubList<Object>
    implements LongMutList {
        public LongSubList(IMutList iMutList, int n, int n2) {
            super(iMutList, n, n2);
        }

        @Override
        public Object reduce(IFn iFn, Object object) {
            return LongMutList.super.reduce(iFn, object);
        }
    }
}

