/*
 * Decompiled with CFR 0.152.
 */
package ham_fisted;

import clojure.lang.IFn;
import clojure.lang.RT;
import ham_fisted.ArrayLists;
import ham_fisted.Casts;
import ham_fisted.ChunkedList;
import ham_fisted.IFnDef;
import ham_fisted.IMutList;
import ham_fisted.Reductions;
import ham_fisted.Transformables;
import it.unimi.dsi.fastutil.doubles.DoubleArrays;
import it.unimi.dsi.fastutil.doubles.DoubleComparator;
import it.unimi.dsi.fastutil.ints.IntComparator;
import java.util.Comparator;
import java.util.List;
import java.util.Random;

public interface DoubleMutList
extends IMutList<Object> {
    @Override
    default public boolean add(Object object) {
        this.addDouble(Casts.doubleCast(object));
        return true;
    }

    @Override
    default public void addLong(long l) {
        this.addDouble(Casts.doubleCast(l));
    }

    @Override
    default public Object set(int n, Object object) {
        double d = this.getDouble(n);
        this.setDouble(n, Casts.doubleCast(object));
        return d;
    }

    default public void setBoolean(int n, boolean bl) {
        this.setDouble(n, bl ? 1.0 : 0.0);
    }

    @Override
    default public void setLong(int n, long l) {
        this.setDouble(n, l);
    }

    @Override
    default public Object get(int n) {
        return this.getDouble(n);
    }

    @Override
    default public long getLong(int n) {
        return (long)this.getDouble(n);
    }

    @Override
    default public IMutList<Object> subList(int n, int n2) {
        ChunkedList.sublistCheck(n, n2, this.size());
        return new DoubleSubList((IMutList)this, n, n2);
    }

    @Override
    default public boolean addAllReducible(Object object) {
        int n = this.size();
        Reductions.serialReduction(new IFnDef.ODO(){

            public Object invokePrim(Object object, double d) {
                ((IMutList)object).addDouble(d);
                return object;
            }
        }, this, object);
        return n != this.size();
    }

    @Override
    default public void fillRange(int n, int n2, Object object) {
        double d = Casts.doubleCast(object);
        while (n < n2) {
            this.setDouble(n, d);
            ++n;
        }
    }

    @Override
    default public void fillRange(final int n, List list) {
        if (list.isEmpty()) {
            return;
        }
        int n2 = this.size();
        int n3 = n + list.size();
        ArrayLists.checkIndexRange(this.size(), n, n3);
        Reductions.serialReduction(new Reductions.IndexedDoubleAccum(new IFnDef.OLDO(){

            public Object invokePrim(Object object, long l, double d) {
                ((IMutList)object).setDouble((int)l + n, d);
                return object;
            }
        }), this, list);
    }

    default public void addRange(int n, int n2, Object object) {
        Double d = Casts.doubleCast(object);
        while (n < n2) {
            this.add(n, d);
            ++n;
        }
    }

    @Override
    default public IntComparator indexComparator() {
        return new IntComparator(){

            public int compare(int n, int n2) {
                return Double.compare(DoubleMutList.this.getDouble(n), DoubleMutList.this.getDouble(n2));
            }
        };
    }

    @Override
    default public void sort(Comparator<? super Object> comparator) {
        DoubleComparator doubleComparator = ArrayLists.DoubleArraySubList.asDoubleComparator(comparator);
        if (comparator == null || doubleComparator != null) {
            double[] dArray = this.toDoubleArray();
            if (comparator == null) {
                DoubleArrays.parallelQuickSort((double[])dArray);
            } else {
                DoubleArrays.parallelQuickSort((double[])dArray, (DoubleComparator)doubleComparator);
            }
            this.fillRange(0, ArrayLists.toList(dArray));
        } else {
            IMutList.super.sort(comparator);
        }
    }

    @Override
    default public void shuffle(Random random) {
        this.fillRange(0, this.immutShuffle(random));
    }

    @Override
    default public List immutShuffle(Random random) {
        double[] dArray = this.toDoubleArray();
        DoubleArrays.shuffle((double[])dArray, (Random)random);
        return ArrayLists.toList(dArray);
    }

    @Override
    default public Object reduce(IFn iFn, Object object) {
        return this.doubleReduction(Transformables.toDoubleReductionFn(iFn), object);
    }

    default public Object doubleReduction(IFn.ODO oDO, Object object) {
        int n = this.size();
        for (int i = 0; i < n && !RT.isReduced((Object)object); ++i) {
            object = oDO.invokePrim(object, this.getDouble(i));
        }
        return object;
    }

    public static class DoubleSubList
    extends IMutList.MutSubList<Object>
    implements DoubleMutList {
        public DoubleSubList(IMutList iMutList, int n, int n2) {
            super(iMutList, n, n2);
        }

        @Override
        public Object reduce(IFn iFn, Object object) {
            return DoubleMutList.super.reduce(iFn, object);
        }
    }
}

