/*
 * Decompiled with CFR 0.152.
 */
package ham_fisted;

import clojure.lang.RT;
import clojure.lang.Util;

public class Casts {
    public static boolean booleanCast(Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        if (object instanceof Number) {
            Number number = (Number)object;
            return Util.isInteger((Object)object) ? number.longValue() != 0L : Casts.booleanCast(number.doubleValue());
        }
        if (object instanceof Character) {
            return ((Character)object).charValue() != '\u0000';
        }
        return true;
    }

    public static boolean booleanCast(long l) {
        return l != 0L;
    }

    public static boolean booleanCast(double d) {
        return Double.isNaN(d) ? false : d != 0.0;
    }

    public static boolean booleanCast(float f) {
        return Float.isNaN(f) ? false : f != 0.0f;
    }

    public static boolean booleanCast(boolean bl) {
        return bl;
    }

    public static char charCast(double d) {
        if (!Double.isFinite(d)) {
            throw new RuntimeException("Non-finite double cannot be casted to long: " + String.valueOf(d));
        }
        return RT.charCast((double)d);
    }

    public static char charCast(float f) {
        if (!Float.isFinite(f)) {
            throw new RuntimeException("Non-finite float cannot be casted to long: " + String.valueOf(f));
        }
        return RT.charCast((float)f);
    }

    public static char charCast(Object object) {
        if (object instanceof Boolean) {
            return (Boolean)object != false ? (char)'\u0001' : '\u0000';
        }
        if (object instanceof Number) {
            Number number = (Number)object;
            if (object instanceof Double) {
                return Casts.charCast(number.doubleValue());
            }
            if (object instanceof Float) {
                return Casts.charCast(number.floatValue());
            }
            return Casts.charCast(number.longValue());
        }
        return RT.charCast((Object)object);
    }

    public static long longCast(Object object) {
        if (object instanceof Boolean) {
            return (Boolean)object != false ? 1L : 0L;
        }
        if (object instanceof Double) {
            return Casts.longCast((Double)object);
        }
        if (object instanceof Float) {
            return Casts.longCast(((Float)object).floatValue());
        }
        if (object instanceof Number) {
            return RT.longCast((Object)object);
        }
        if (object instanceof Character) {
            return ((Character)object).charValue();
        }
        throw new RuntimeException("Object cannot be casted to long: " + object);
    }

    public static long longCast(long l) {
        return l;
    }

    public static long longCast(char c) {
        return c;
    }

    public static long longCast(double d) {
        if (!Double.isFinite(d)) {
            throw new RuntimeException("Non-finite double cannot be casted to long: " + String.valueOf(d));
        }
        return (long)d;
    }

    public static long longCast(float f) {
        if (!Float.isFinite(f)) {
            throw new RuntimeException("Non-finite float cannot be casted to long: " + String.valueOf(f));
        }
        return (long)f;
    }

    public static long longCast(boolean bl) {
        return bl ? 1L : 0L;
    }

    public static double doubleCast(Object object) {
        if (object == null) {
            return Double.NaN;
        }
        if (object instanceof Double) {
            return (Double)object;
        }
        if (object instanceof Long) {
            return ((Long)object).longValue();
        }
        if (object instanceof Boolean) {
            return (Boolean)object != false ? 1.0 : 0.0;
        }
        return RT.doubleCast((Object)object);
    }

    public static double doubleCast(long l) {
        return l;
    }

    public static double doubleCast(double d) {
        return d;
    }

    public static double doubleCast(float f) {
        return f;
    }

    public static double doubleCast(boolean bl) {
        return bl ? 1.0 : 0.0;
    }
}

