/*
 * Decompiled with CFR 0.152.
 */
package ham_fisted;

import clojure.lang.IFn;
import clojure.lang.IPersistentMap;
import clojure.lang.ISeq;
import clojure.lang.IteratorSeq;
import clojure.lang.Murmur3;
import clojure.lang.RT;
import clojure.lang.Util;
import ham_fisted.HashSet;
import ham_fisted.IntegerOps;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Objects;

public final class ChunkedList {
    Object[][] data;
    int capacity;
    int nElems;
    final IPersistentMap meta;

    static final int numChunks(int n) {
        return (n + 31) / 32;
    }

    static final int lastChunkSize(int n) {
        if (n == 0) {
            return 4;
        }
        int n2 = n % 32;
        if (n2 == 0) {
            return 32;
        }
        return Math.max(4, IntegerOps.nextPow2(n2));
    }

    public ChunkedList(int n) {
        n = Math.max(n, 16);
        int n2 = ChunkedList.numChunks(n);
        int n3 = ChunkedList.lastChunkSize(n);
        this.data = new Object[n2][];
        int n4 = n2 - 1;
        for (int i = 0; i < n2; ++i) {
            this.data[i] = new Object[i == n4 ? n3 : 32];
        }
        this.nElems = 0;
        this.capacity = 32 * (n2 - 1) + n3;
        this.meta = null;
    }

    public ChunkedList() {
        this(0);
    }

    ChunkedList(Object[][] objectArray, int n, int n2, IPersistentMap iPersistentMap) {
        this.data = objectArray;
        this.capacity = n;
        this.nElems = n2;
        this.meta = iPersistentMap;
    }

    ChunkedList(ChunkedList chunkedList, boolean bl) {
        if (bl) {
            this.data = chunkedList.data;
        } else {
            Object[][] objectArray = chunkedList.data;
            Object[][] objectArray2 = (Object[][])objectArray.clone();
            int n = objectArray2.length;
            for (int i = 0; i < n; ++i) {
                objectArray2[i] = (Object[])objectArray[i].clone();
            }
            this.data = objectArray2;
        }
        this.capacity = chunkedList.capacity;
        this.nElems = chunkedList.nElems;
        this.meta = chunkedList.meta;
    }

    static ChunkedList create(boolean bl, IPersistentMap iPersistentMap, Object ... objectArray) {
        int n;
        int n2 = objectArray.length;
        if (bl && n2 <= 32) {
            return new ChunkedList(new Object[][]{objectArray}, n2, n2, null);
        }
        int n3 = objectArray.length;
        int n4 = ChunkedList.numChunks(n3);
        Object[][] objectArray2 = new Object[n4][];
        for (int i = 0; i < n3; i += n) {
            n = Math.min(32, n3 - i);
            Object[] objectArray3 = new Object[n];
            System.arraycopy(objectArray, i, objectArray3, 0, n);
            objectArray2[i / 32] = objectArray3;
        }
        return new ChunkedList(objectArray2, n3, n3, iPersistentMap);
    }

    ChunkedList clone(int n, int n2, int n3, boolean bl) {
        int n4 = n2 - n;
        int n5 = n4 + n3;
        boolean bl2 = !bl && n % 32 == 0;
        Object[][] objectArray = this.data;
        if (bl2) {
            Object[][] objectArray2 = (Object[][])Arrays.copyOfRange(objectArray, n / 32, (n2 + n3 + 31) / 32);
            return new ChunkedList(objectArray2, n5, n5, this.meta);
        }
        int n6 = ChunkedList.numChunks(n5);
        int n7 = n6 - 1;
        Object[][] objectArray3 = new Object[n6][];
        int n8 = n;
        int n9 = 0;
        while (n < n2) {
            int n10 = n2 - n;
            Object[] objectArray4 = objectArray[n / 32];
            int n11 = n % 32;
            int n12 = (n - n8) % 32;
            int n13 = (n - n8) / 32;
            Object[] objectArray5 = objectArray3[n13];
            if (objectArray5 == null) {
                objectArray5 = n13 == n7 ? new Object[n5 % 32] : new Object[32];
                objectArray3[n13] = objectArray5;
                n9 += objectArray5.length;
            }
            int n14 = Math.min(n10, Math.min(objectArray4.length - n11, objectArray5.length - n12));
            System.arraycopy(objectArray4, n11, objectArray5, n12, n14);
            n += n14;
        }
        return new ChunkedList(objectArray3, n9, n5, this.meta);
    }

    ChunkedList clone(int n, int n2) {
        return this.clone(n, n2, 0, true);
    }

    void clear(int n, int n2) {
        if (n == 0 && n2 == this.nElems) {
            int n3;
            Object[][] objectArray = this.data;
            int n4 = this.data.length;
            int n5 = this.nElems;
            for (int i = 0; i < n5; i += 32 - n3) {
                Object[] objectArray2 = objectArray[i / 32];
                n3 = i % 32;
                Arrays.fill(objectArray2, n3, objectArray2.length - n3, null);
            }
            this.nElems = 0;
        } else {
            this.shorten(n, n + n2);
        }
    }

    void clear() {
        this.clear(0, this.nElems);
    }

    void enlarge(int n) {
        if (n <= this.capacity) {
            return;
        }
        int n2 = ChunkedList.numChunks(n);
        int n3 = n2 - 1;
        int n4 = ChunkedList.lastChunkSize(n);
        Object[][] objectArray = this.data;
        if (n2 != objectArray.length) {
            objectArray = (Object[][])Arrays.copyOf(objectArray, n2);
        }
        for (int i = 0; i < n2; ++i) {
            int n5;
            Object[] objectArray2 = objectArray[i];
            if (objectArray2 != null && objectArray2.length == 32) continue;
            int n6 = i == n3 ? n4 : 32;
            int n7 = n5 = objectArray2 == null ? 0 : objectArray2.length;
            if (n5 == n6) continue;
            objectArray[i] = objectArray2 == null ? new Object[n6] : Arrays.copyOf(objectArray2, n6);
        }
        this.data = objectArray;
        this.capacity = 32 * (n2 - 1) + n4;
    }

    final Object setValueRV(int n, Object object) {
        Object[] objectArray = this.data[n / 32];
        int n2 = n % 32;
        Object object2 = objectArray[n2];
        objectArray[n2] = object;
        return object2;
    }

    final void setValue(int n, Object object) {
        this.data[n / 32][n % 32] = object;
    }

    final Object getValue(int n) {
        return this.data[n / 32][n % 32];
    }

    public static final void sublistCheck(long l, long l2, long l3) {
        if (l < 0L || l > l3) {
            throw new IndexOutOfBoundsException("Start index out of range: start-index(" + String.valueOf(l) + "), n-elems(" + String.valueOf(l3) + ")");
        }
        if (l2 < 0L || l2 > l3) {
            throw new IndexOutOfBoundsException("End index out of range: end-index(" + String.valueOf(l2) + "), n-elems(" + String.valueOf(l3) + ")");
        }
        if (l2 < l) {
            throw new IndexOutOfBoundsException("End index underflow: end-index(" + String.valueOf(l2) + ") < start-index(" + String.valueOf(l) + ")");
        }
    }

    static final int indexCheck(int n, int n2, int n3) {
        if (n3 < 0) {
            throw new IndexOutOfBoundsException("Index underflow: " + String.valueOf(n3));
        }
        if (n3 >= n2) {
            throw new IndexOutOfBoundsException("Index out of range: " + String.valueOf(n3) + " : " + String.valueOf(n2));
        }
        return n3 + n;
    }

    static final int wrapIndexCheck(int n, int n2, int n3) {
        if (n3 < 0) {
            n3 = n2 + n3;
        }
        return ChunkedList.indexCheck(n, n2, n3);
    }

    static final void checkIndexRange(int n, int n2, int n3, int n4) {
        int n5 = n4 - n3;
        ChunkedList.indexCheck(n, n2, n3);
        if (n5 < 0) {
            throw new RuntimeException("Range end point: " + String.valueOf(n4) + " is less than start: " + String.valueOf(n3));
        }
        if (n4 > n2) {
            throw new RuntimeException("Range end point: " + String.valueOf(n4) + " is past end of valid range: " + String.valueOf(n2));
        }
    }

    final boolean add(Object object) {
        int n = this.nElems;
        int n2 = this.capacity;
        if (n >= n2) {
            this.enlarge(n2 + 1);
        }
        this.data[this.nElems / 32][this.nElems % 32] = object;
        this.nElems = n + 1;
        return true;
    }

    final void widen(int n, int n2) {
        int n3;
        int n4 = n2 - n;
        if (n4 == 0) {
            return;
        }
        int n5 = this.nElems;
        int n6 = this.capacity;
        this.enlarge(n5 + n4);
        Object[][] objectArray = this.data;
        for (int i = n5 - n; i > 0; i -= n3) {
            int n7 = n + i - 1;
            int n8 = n2 + i - 1;
            Object[] objectArray2 = objectArray[n7 / 32];
            Object[] objectArray3 = objectArray[n8 / 32];
            int n9 = n7 % 32;
            int n10 = n8 % 32;
            n3 = Math.min(i, Math.min(n9 + 1, n10 + 1));
            System.arraycopy(objectArray2, n9 - n3 + 1, objectArray3, n10 - n3 + 1, n3);
        }
        this.nElems = n5 + n4;
    }

    final void shorten(int n, int n2) {
        if (n == 0 && n2 == this.nElems) {
            this.clear();
            return;
        }
        int n3 = this.nElems;
        int n4 = n2 - n;
        int n5 = n3 - n2;
        Object[][] objectArray = this.data;
        while (n5 > 0) {
            Object[] objectArray2 = this.data[n / 32];
            Object[] objectArray3 = this.data[n2 / 32];
            int n6 = n % 32;
            int n7 = n2 % 32;
            int n8 = Math.min(n5, Math.min(objectArray2.length - n6, objectArray3.length - n7));
            System.arraycopy(objectArray3, n7, objectArray2, n6, n8);
            n5 -= n8;
            n += n8;
            n2 += n8;
        }
        this.clear(n, n4);
        this.nElems = n3 - n4;
    }

    final void add(Object object, int n) {
        int n2 = this.nElems;
        if (n > n2) {
            throw new RuntimeException("Index out of range: " + String.valueOf(n) + " > " + String.valueOf(n2));
        }
        if (n == n2) {
            this.add(object);
            return;
        }
        this.widen(n, n + 1);
        this.setValue(n, object);
    }

    final ChunkedList conj(int n, int n2, Object object) {
        ChunkedList chunkedList = this.clone(n, n2, 1, false);
        int n3 = n2 - n;
        Object[][] objectArray = chunkedList.data;
        int n4 = n3 / 32;
        Object[] objectArray2 = objectArray[n4];
        int n5 = n3 % 32;
        objectArray2 = objectArray2 == null ? new Object[1] : Arrays.copyOf(objectArray2, n5 + 1);
        objectArray[n4] = objectArray2;
        objectArray2[n5] = object;
        return chunkedList;
    }

    final ChunkedList assoc(int n, int n2, int n3, Object object) {
        int n4 = n2 - n;
        if (n3 == n4) {
            return this.conj(n, n2, object);
        }
        ChunkedList chunkedList = this.clone(n, n2, 0, false);
        int n5 = n3 / 32;
        int n6 = n3 % 32;
        Object[][] objectArray = chunkedList.data;
        Object[] objectArray2 = (Object[])objectArray[n5].clone();
        objectArray2[n6] = object;
        objectArray[n5] = objectArray2;
        return chunkedList;
    }

    final ChunkedList pop(int n, int n2) {
        int n3;
        Object[] objectArray;
        ChunkedList chunkedList = this.clone(n, n2 - 1, 0, false);
        Object[][] objectArray2 = chunkedList.data;
        int n4 = n2 - n;
        int n5 = n4 / 32;
        if (objectArray2.length > n5 && (objectArray = objectArray2[n5]).length > (n3 = n4 % 32)) {
            objectArray2[n5] = Arrays.copyOf(objectArray, n3);
        }
        return chunkedList;
    }

    final int size() {
        return this.nElems;
    }

    final void fillRange(int n, int n2, Object object) {
        Object[][] objectArray = this.data;
        while (n < n2) {
            objectArray[n / 32][n % 32] = object;
            ++n;
        }
    }

    final void fillRange(int n, List list) {
        Object[][] objectArray = this.data;
        int n2 = n + list.size();
        int n3 = 0;
        while (n < n2) {
            objectArray[n / 32][n % 32] = list.get(n3);
            ++n;
            ++n3;
        }
    }

    final void addRange(int n, int n2, Object object) {
        this.widen(n, n2);
        Object[][] objectArray = this.data;
        while (n < n2) {
            objectArray[n / 32][n % 32] = object;
            ++n;
        }
    }

    final Object[] fillArray(int n, int n2, Object[] objectArray) {
        int n3 = n2 / 32;
        int n4 = n2 % 32;
        int n5 = n % 32;
        Object[][] objectArray2 = this.data;
        int n6 = 0;
        for (int i = n / 32; i <= n3; ++i) {
            int n7 = i == n3 ? n4 - n5 : 32 - n5;
            System.arraycopy(objectArray2[i], n5, objectArray, n6, n7);
            n6 += n7;
            n5 = 0;
        }
        return objectArray;
    }

    final Object[] fillArray(Object[] objectArray) {
        return this.fillArray(0, this.nElems, objectArray);
    }

    final Object[] toArray(int n, int n2) {
        return this.fillArray(n, n2, new Object[n2 - n]);
    }

    final Object[] toArray() {
        return this.toArray(0, this.nElems);
    }

    public Iterator iterator(int n, int n2) {
        return new CLIter(n, n2, this.data);
    }

    public Iterator iterator() {
        return this.iterator(0, this.nElems);
    }

    public Iterator riterator(int n, int n2) {
        return new RIterator(n, n2, this.data);
    }

    <E> ListIterator<E> listIterator(int n, int n2, E e) {
        return new ListIter(n, n2, this.data);
    }

    Object reduce(int n, int n2, IFn iFn, Object object) {
        int n3;
        Object[][] objectArray = this.data;
        Object object2 = object;
        for (int i = n; i < n2 && !RT.isReduced((Object)object2); i += n3) {
            Object[] objectArray2 = objectArray[i / 32];
            int n4 = i % 32;
            n3 = Math.min(n2 - i, 32 - n4);
            int n5 = n3 + n4;
            for (int j = n4; j < n5 && !RT.isReduced((Object)object2); ++j) {
                object2 = iFn.invoke(object2, objectArray2[j]);
            }
        }
        return object2;
    }

    Object reduce(int n, int n2, IFn iFn) {
        if (n == n2) {
            return iFn.invoke();
        }
        return this.reduce(n + 1, n2, iFn, this.getValue(n));
    }

    Object kvreduce(int n, int n2, IFn iFn, Object object) {
        Object[][] objectArray = this.data;
        for (int i = n; i < n2 && !RT.isReduced((Object)object); ++i) {
            object = iFn.invoke(object, (Object)(i - n), objectArray[i / 32][i % 32]);
        }
        return object;
    }

    final ISeq seq(int n, int n2) {
        return IteratorSeq.create((Iterator)this.iterator(n, n2));
    }

    final ISeq rseq(int n, int n2) {
        return IteratorSeq.create((Iterator)this.riterator(n, n2));
    }

    final int hasheq(int n, int n2) {
        int n3 = 1;
        int n4 = n2 - n;
        Object[][] objectArray = this.data;
        while (n < n2) {
            n3 = 31 * n3 + Util.hasheq((Object)objectArray[n / 32][n % 32]);
            ++n;
        }
        n3 = Murmur3.mixCollHash((int)n3, (int)n4);
        return n3;
    }

    final IPersistentMap meta() {
        return this.meta;
    }

    final ChunkedList withMeta(IPersistentMap iPersistentMap) {
        return new ChunkedList(this.data, this.capacity, this.nElems, iPersistentMap);
    }

    final int indexOf(int n, int n2, Object object) {
        int n3 = n2 - n;
        Object[][] objectArray = this.data;
        for (int i = 0; i < n3; ++i) {
            if (!Objects.equals(object, objectArray[i / 32][i % 32])) continue;
            return i;
        }
        return -1;
    }

    final int lastIndexOf(int n, int n2, Object object) {
        int n3 = n2 - n;
        int n4 = n3 - 1;
        Object[][] objectArray = this.data;
        for (int i = 0; i < n3; ++i) {
            int n5 = n4 - i + n;
            if (!Objects.equals(object, objectArray[n5 / 32][n5 % 32])) continue;
            return n5;
        }
        return -1;
    }

    final boolean contains(int n, int n2, Object object) {
        return this.indexOf(n, n2, object) != -1;
    }

    final boolean containsAll(int n, int n2, Collection<?> collection) {
        Iterator<?> iterator;
        Iterator<?> iterator2;
        int n3 = n2 - n;
        if (n3 < collection.size()) {
            iterator2 = this.iterator(n, n2);
            iterator = collection.iterator();
        } else {
            iterator = this.iterator(n, n2);
            iterator2 = collection.iterator();
        }
        HashSet hashSet = new HashSet();
        while (iterator2.hasNext()) {
            hashSet.add(iterator2.next());
        }
        while (iterator.hasNext()) {
            if (hashSet.contains(iterator.next())) continue;
            return false;
        }
        return true;
    }

    static interface ChunkedListOwner {
        public ChunkedListSection getChunkedList();
    }

    static class ChunkedListSection {
        public final Object[][] data;
        public final int startidx;
        public final int endidx;

        public int size() {
            return this.endidx - this.startidx;
        }

        public ChunkedListSection(Object[][] objectArray, int n, int n2) {
            this.data = objectArray;
            this.startidx = n;
            this.endidx = n2;
        }
    }

    static class ListIter<E>
    implements ListIterator<E> {
        final int startidx;
        final int endidx;
        final Object[][] data;
        int idx;
        int prevIdx;

        ListIter(int n, int n2, Object[][] objectArray) {
            this.startidx = n;
            this.endidx = n2;
            this.data = objectArray;
            this.prevIdx = this.idx = n;
        }

        @Override
        public void add(E e) {
            throw new RuntimeException("Unimplemented.");
        }

        @Override
        public void remove() {
            throw new RuntimeException("Unimplemented.");
        }

        @Override
        public final boolean hasNext() {
            return this.idx < this.endidx;
        }

        @Override
        public final boolean hasPrevious() {
            return this.idx > this.startidx;
        }

        @Override
        public final E next() {
            if (this.idx == this.endidx) {
                throw new NoSuchElementException();
            }
            Object object = this.data[this.idx / 32][this.idx % 32];
            this.prevIdx = this.idx++;
            return (E)object;
        }

        @Override
        public final int nextIndex() {
            return this.idx - this.startidx;
        }

        @Override
        public final E previous() {
            --this.idx;
            if (this.idx < this.startidx) {
                throw new NoSuchElementException();
            }
            this.prevIdx = this.idx;
            return (E)this.data[this.idx / 32][this.idx % 32];
        }

        @Override
        public final int previousIndex() {
            return this.idx - this.startidx - 1;
        }

        @Override
        public final void set(E e) {
            this.data[this.prevIdx / 32][this.prevIdx % 32] = e;
        }
    }

    static class RIterator
    implements Iterator {
        final int startidx;
        final Object[][] data;
        int idx;

        public RIterator(int n, int n2, Object[][] objectArray) {
            this.startidx = n;
            this.idx = n2;
            this.data = objectArray;
            this.advance();
        }

        void advance() {
            --this.idx;
        }

        @Override
        public final boolean hasNext() {
            return this.idx >= this.startidx;
        }

        public final Object next() {
            if (this.idx < this.startidx) {
                throw new NoSuchElementException();
            }
            Object object = this.data[this.idx / 32][this.idx % 32];
            this.advance();
            return object;
        }
    }

    static class CLIter
    implements Iterator {
        final int finalCidx;
        final int finalEidx;
        final Object[][] data;
        int cidx;
        int eidx;
        Object[] chunk;

        public CLIter(int n, int n2, Object[][] objectArray) {
            this.finalCidx = n2 / 32;
            this.finalEidx = n2 % 32;
            this.cidx = n / 32;
            this.eidx = n % 32 - 1;
            this.data = objectArray;
            this.advance();
        }

        final void advance() {
            ++this.eidx;
            if (this.eidx == 32) {
                ++this.cidx;
                this.eidx = 0;
                this.chunk = null;
            }
        }

        @Override
        public final boolean hasNext() {
            if (this.cidx < this.finalCidx) {
                return true;
            }
            return this.eidx < this.finalEidx;
        }

        public final Object next() {
            if (this.cidx >= this.finalCidx && this.eidx >= this.finalEidx) {
                throw new NoSuchElementException();
            }
            if (this.chunk == null) {
                this.chunk = this.data[this.cidx];
            }
            Object object = this.chunk[this.eidx];
            this.advance();
            return object;
        }
    }
}

