/*
 * Decompiled with CFR 0.152.
 */
package ham_fisted;

import clojure.lang.AFn;
import clojure.lang.IMapEntry;
import clojure.lang.IObj;
import clojure.lang.IPersistentMap;
import clojure.lang.IPersistentVector;
import clojure.lang.ITransientAssociative2;
import clojure.lang.ITransientMap;
import clojure.lang.MapEntry;
import ham_fisted.BitmapTrie;
import ham_fisted.BitmapTrieCommon;
import ham_fisted.PersistentHashMap;
import java.util.Map;

public final class TransientHashMap
extends AFn
implements ITransientMap,
ITransientAssociative2,
IObj {
    final BitmapTrie hb;
    boolean editable = true;

    public TransientHashMap(BitmapTrie bitmapTrie) {
        this.hb = bitmapTrie;
    }

    public TransientHashMap() {
        this.hb = new BitmapTrie(BitmapTrieCommon.defaultHashProvider);
    }

    TransientHashMap(TransientHashMap transientHashMap) {
        this.hb = new BitmapTrie(transientHashMap.hb);
    }

    public final TransientHashMap clone() {
        return new TransientHashMap(this);
    }

    public final boolean containsKey(Object object) {
        return this.hb.get(object) != null;
    }

    public final IMapEntry entryAt(Object object) {
        BitmapTrie.LeafNode leafNode = (BitmapTrie.LeafNode)this.hb.get(object);
        return leafNode == null ? null : new MapEntry(leafNode.key(), leafNode.val());
    }

    final void ensureEditable() {
        if (!this.editable) {
            throw new RuntimeException("Transient map editted after persistent!");
        }
    }

    public final TransientHashMap assoc(Object object, Object object2) {
        this.ensureEditable();
        this.hb.assoc(object, object2);
        return this;
    }

    public final TransientHashMap conj(Object object) {
        this.ensureEditable();
        if (object instanceof IPersistentVector) {
            IPersistentVector iPersistentVector = (IPersistentVector)object;
            if (iPersistentVector.count() != 2) {
                throw new RuntimeException("Vector length != 2 during conj");
            }
            return this.assoc(iPersistentVector.nth(0), iPersistentVector.nth(1));
        }
        if (object instanceof Map.Entry) {
            Map.Entry entry = (Map.Entry)object;
            return this.assoc(entry.getKey(), entry.getValue());
        }
        for (Map.Entry entry : (Iterable)object) {
            this.hb.assoc(entry.getKey(), entry.getValue());
        }
        return this;
    }

    public final ITransientMap without(Object object) {
        this.ensureEditable();
        this.hb.dissoc(object);
        return this;
    }

    public final PersistentHashMap persistent() {
        this.editable = false;
        return new PersistentHashMap(this.hb);
    }

    public final Object valAt(Object object) {
        return this.hb.get(object);
    }

    public final Object valAt(Object object, Object object2) {
        return this.hb.getOrDefault(object, object2);
    }

    public final Object invoke(Object object) {
        return this.hb.get(object);
    }

    public final Object invoke(Object object, Object object2) {
        return this.hb.getOrDefault(object, object2);
    }

    public int count() {
        return this.hb.size();
    }

    public IPersistentMap meta() {
        return this.hb.meta;
    }

    public IObj withMeta(IPersistentMap iPersistentMap) {
        return new TransientHashMap(this.hb.shallowClone(iPersistentMap));
    }

    public void printNodes() {
        this.hb.printNodes();
    }
}

