/*
 * Decompiled with CFR 0.152.
 */
package ham_fisted;

import clojure.lang.IFn;
import clojure.lang.IReduceInit;
import ham_fisted.ArrayLists;
import ham_fisted.Casts;
import ham_fisted.Consumers;
import ham_fisted.IFnDef;
import ham_fisted.IndexedConsumer;
import ham_fisted.IndexedDoubleConsumer;
import ham_fisted.IndexedLongConsumer;
import ham_fisted.ParallelOptions;
import java.util.function.Consumer;
import java.util.function.DoubleConsumer;
import java.util.function.LongConsumer;

public interface ITypedReduce<E>
extends IReduceInit {
    default public Object doubleReduction(final IFn.ODO oDO, Object object) {
        return this.reduce(new IFnDef(){

            @Override
            public Object invoke(Object object, Object object2) {
                return oDO.invokePrim(object, Casts.doubleCast(object2));
            }
        }, object);
    }

    default public Object longReduction(final IFn.OLO oLO, Object object) {
        return this.reduce(new IFnDef(){

            @Override
            public Object invoke(Object object, Object object2) {
                return oLO.invokePrim(object, Casts.longCast(object2));
            }
        }, object);
    }

    default public Object indexedDoubleReduction(final IFn.OLDO oLDO, long l, Object object) {
        final LongIncrementor longIncrementor = new LongIncrementor(l);
        return this.reduce(new IFnDef(){

            @Override
            public Object invoke(Object object, Object object2) {
                return oLDO.invokePrim(object, longIncrementor.inc(), Casts.doubleCast(object2));
            }
        }, object);
    }

    default public Object indexedLongReduction(final IFn.OLLO oLLO, long l, Object object) {
        final LongIncrementor longIncrementor = new LongIncrementor(l);
        return this.reduce(new IFnDef(){

            @Override
            public Object invoke(Object object, Object object2) {
                return oLLO.invokePrim(object, longIncrementor.inc(), Casts.longCast(object2));
            }
        }, object);
    }

    default public Object indexedReduction(final IFn.OLOO oLOO, long l, Object object) {
        final LongIncrementor longIncrementor = new LongIncrementor(l);
        return this.reduce(new IFnDef(){

            @Override
            public Object invoke(Object object, Object object2) {
                return oLOO.invokePrim(object, longIncrementor.inc(), object2);
            }
        }, object);
    }

    default public Object genericReduction(Object object, Object object2) {
        if (object instanceof IFn.ODO) {
            return this.doubleReduction((IFn.ODO)object, object2);
        }
        if (object instanceof IFn.OLO) {
            return this.longReduction((IFn.OLO)object, object2);
        }
        if (!(object instanceof IFn)) {
            throw new RuntimeException("reducer must be an instance of clojure.lang.IFn, java.util.function.DoubleBinaryOperator or java.util.function.LongBinaryOperator.");
        }
        return this.reduce((IFn)object, object2);
    }

    default public Object genericIndexedReduction(Object object, long l, Object object2) {
        if (object instanceof IFn.OLDO) {
            return this.indexedDoubleReduction((IFn.OLDO)object, l, object2);
        }
        if (object instanceof IFn.OLLO) {
            return this.indexedLongReduction((IFn.OLLO)object, l, object2);
        }
        if (!(object instanceof IFn.OLOO)) {
            throw new RuntimeException("reducer must be a typehinted instance of clojure.lang.IFn.");
        }
        return this.indexedReduction((IFn.OLOO)object, l, object2);
    }

    default public Object parallelReduction(IFn iFn, IFn iFn2, IFn iFn3, ParallelOptions parallelOptions) {
        return this.genericReduction(iFn2, iFn.invoke());
    }

    default public void forEach(final Consumer<E> consumer) {
        this.reduce(new IFnDef(){

            @Override
            public Object invoke(Object object, Object object2) {
                consumer.accept(object2);
                return consumer;
            }
        }, consumer);
    }

    default public void doubleForEach(final DoubleConsumer doubleConsumer) {
        this.doubleReduction(new IFn.ODO(){

            public Object invokePrim(Object object, double d) {
                doubleConsumer.accept(d);
                return doubleConsumer;
            }
        }, doubleConsumer);
    }

    default public void longForEach(final LongConsumer longConsumer) {
        this.longReduction(new IFn.OLO(){

            public Object invokePrim(Object object, long l) {
                longConsumer.accept(l);
                return longConsumer;
            }
        }, longConsumer);
    }

    default public void genericForEach(Object object) {
        DoubleConsumer doubleConsumer = ArrayLists.asDoubleConsumer(object);
        if (doubleConsumer != null) {
            this.doubleForEach(doubleConsumer);
        } else {
            LongConsumer longConsumer = ArrayLists.asLongConsumer(object);
            if (longConsumer != null) {
                this.longForEach(longConsumer);
            } else {
                if (!(object instanceof Consumer)) {
                    throw new RuntimeException("Consumer must be an instance of java.util.function Consumer, DoubleConsumer, or LongConsumer.");
                }
                this.forEach((Consumer)object);
            }
        }
    }

    default public void genericIndexedForEach(long l, Object object) {
        IndexedDoubleConsumer indexedDoubleConsumer = Consumers.asIndexedDoubleConsumer(object);
        if (indexedDoubleConsumer != null) {
            this.doubleForEach(Consumers.toDoubleConsumer(l, indexedDoubleConsumer));
        } else {
            IndexedLongConsumer indexedLongConsumer = Consumers.asIndexedLongConsumer(object);
            if (indexedLongConsumer != null) {
                this.longForEach(Consumers.toLongConsumer(l, indexedLongConsumer));
            } else {
                IndexedConsumer indexedConsumer = Consumers.asIndexedConsumer(object);
                if (indexedConsumer == null) {
                    throw new RuntimeException("Consumer must be an instance of ham_fisted IndexedConsumer, IndexedDoubleConsumer, or IndexedLongConsumer.");
                }
                this.forEach(Consumers.toConsumer(l, indexedConsumer));
            }
        }
    }

    public static class LongIncrementor {
        long val;

        public LongIncrementor(long l) {
            this.val = l;
        }

        public final long inc() {
            return this.val++;
        }
    }
}

