/*
 * Decompiled with CFR 0.152.
 */
package ham_fisted;

import clojure.lang.APersistentMap;
import clojure.lang.IDeref;
import clojure.lang.IEditableCollection;
import clojure.lang.IFn;
import clojure.lang.IHashEq;
import clojure.lang.IKVReduce;
import clojure.lang.IMapEntry;
import clojure.lang.IMapIterable;
import clojure.lang.IObj;
import clojure.lang.IPersistentCollection;
import clojure.lang.IPersistentMap;
import clojure.lang.ISeq;
import clojure.lang.ITransientMap;
import clojure.lang.IteratorSeq;
import clojure.lang.MapEntry;
import clojure.lang.MapEquivalence;
import clojure.lang.RT;
import ham_fisted.BitmapTrie;
import ham_fisted.BitmapTrieCommon;
import ham_fisted.CljHash;
import ham_fisted.HashMap;
import ham_fisted.HashSet;
import ham_fisted.ImmutValues;
import ham_fisted.PersistentArrayMap;
import ham_fisted.PersistentHashSet;
import ham_fisted.TransientHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.Future;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;

public final class PersistentHashMap
extends APersistentMap
implements IObj,
IMapIterable,
IKVReduce,
IEditableCollection,
BitmapTrieCommon.MapSet,
BitmapTrie.BitmapTrieOwner,
IHashEq,
ImmutValues,
MapEquivalence {
    final BitmapTrie hb;
    int cachedHash = 0;
    public static PersistentHashMap EMPTY = new PersistentHashMap(new BitmapTrie(BitmapTrieCommon.defaultHashProvider));

    @Override
    public BitmapTrie bitmapTrie() {
        return this.hb;
    }

    public PersistentHashMap() {
        this.hb = new BitmapTrie(BitmapTrieCommon.defaultHashProvider);
    }

    public PersistentHashMap(BitmapTrieCommon.HashProvider hashProvider) {
        this.hb = new BitmapTrie(hashProvider);
    }

    public PersistentHashMap(BitmapTrie bitmapTrie) {
        this.hb = bitmapTrie;
    }

    public PersistentHashMap(BitmapTrieCommon.HashProvider hashProvider, boolean bl, Object ... objectArray) {
        HashMap hashMap = new HashMap(hashProvider, bl, objectArray);
        this.hb = hashMap.hb;
    }

    public PersistentHashMap(Object ... objectArray) {
        this(BitmapTrieCommon.defaultHashProvider, false, objectArray);
    }

    public final BitmapTrie unsafeGetBitmapTrie() {
        return this.hb;
    }

    public PersistentHashMap(boolean bl, Object ... objectArray) {
        this(BitmapTrieCommon.defaultHashProvider, bl, objectArray);
    }

    public final int hashCode() {
        if (this.cachedHash == 0) {
            this.cachedHash = CljHash.mapHashcode(this.hb);
            return this.cachedHash;
        }
        return this.cachedHash;
    }

    public final int hasheq() {
        return this.hashCode();
    }

    public final boolean equals(Object object) {
        return CljHash.mapEquiv(this.hb, object);
    }

    public final boolean equiv(Object object) {
        return this.equals(object);
    }

    public final boolean containsKey(Object object) {
        return this.hb.containsKey(object);
    }

    public final boolean containsValue(Object object) {
        return this.hb.containsValue(object);
    }

    public final int size() {
        return this.hb.size();
    }

    public final int count() {
        return this.hb.size();
    }

    public final Set keySet() {
        return new PersistentHashSet(this.hb);
    }

    public final Set entrySet() {
        return this.hb.entrySet(null, false);
    }

    public final Collection values() {
        return this.hb.values(null, false);
    }

    public final IMapEntry entryAt(Object object) {
        BitmapTrie.LeafNode leafNode = this.hb.getNode(object);
        return leafNode != null ? MapEntry.create((Object)object, (Object)leafNode.val()) : null;
    }

    public final ISeq seq() {
        return IteratorSeq.create((Iterator)this.iterator());
    }

    public final Object get(Object object) {
        return this.hb.get(object);
    }

    public final Object getOrDefault(Object object, Object object2) {
        return this.hb.getOrDefault(object, object2);
    }

    public final Object valAt(Object object, Object object2) {
        return this.hb.getOrDefault(object, object2);
    }

    public final Object valAt(Object object) {
        return this.hb.getOrDefault(object, null);
    }

    public final Iterator iterator() {
        return this.hb.iterator(BitmapTrie.entryIterFn);
    }

    public final Iterator keyIterator() {
        return this.hb.iterator(BitmapTrie.keyIterFn);
    }

    public final Iterator valIterator() {
        return this.hb.iterator(BitmapTrie.valIterFn);
    }

    public final PersistentHashMap[] splitMaps(int n) {
        BitmapTrie[] bitmapTrieArray = this.hb.splitBases(n);
        PersistentHashMap[] persistentHashMapArray = new PersistentHashMap[bitmapTrieArray.length];
        for (int i = 0; i < persistentHashMapArray.length; ++i) {
            persistentHashMapArray[i] = new PersistentHashMap(bitmapTrieArray[i]);
        }
        return persistentHashMapArray;
    }

    public final Iterator[] splitKeys(int n) {
        return this.hb.splitKeys(n);
    }

    public final Iterator[] splitValues(int n) {
        return this.hb.splitValues(n);
    }

    public final Iterator[] splitEntries(int n) {
        return this.hb.splitEntries(n);
    }

    public final IPersistentMap assoc(Object object, Object object2) {
        if (this.hb.size() == 0) {
            return new PersistentHashMap(new BitmapTrie(this.hb.hp, this.hb.meta, object, object2));
        }
        return new PersistentHashMap(this.hb.shallowClone().assoc(object, object2));
    }

    public final IPersistentMap assocEx(Object object, Object object2) {
        if (this.containsKey(object)) {
            throw new RuntimeException("Key already present");
        }
        return this.assoc(object, object2);
    }

    public final IPersistentMap without(Object object) {
        if (this.hb.size() == 0 || object == null && this.hb.nullEntry == null) {
            return this;
        }
        return new PersistentHashMap(this.hb.shallowClone().dissoc(object));
    }

    public final IPersistentCollection empty() {
        return (IPersistentCollection)EMPTY.withMeta(this.hb.meta);
    }

    public final IPersistentMap meta() {
        return this.hb.meta;
    }

    public final IObj withMeta(IPersistentMap iPersistentMap) {
        return new PersistentHashMap(this.hb.shallowClone(iPersistentMap));
    }

    public final Object kvreduce(IFn iFn, Object object) {
        BitmapTrieCommon.LeafNodeIterator leafNodeIterator = this.hb.iterator(BitmapTrie.identityIterFn);
        while (leafNodeIterator.hasNext()) {
            BitmapTrieCommon.ILeaf iLeaf = leafNodeIterator.nextLeaf();
            if (!RT.isReduced((Object)(object = iFn.invoke(object, iLeaf.key(), iLeaf.val())))) continue;
            return ((IDeref)object).deref();
        }
        return object;
    }

    public final ITransientMap asTransient() {
        if (this.size() == 0) {
            return new HashMap(new BitmapTrie(this.hb.hp, this.hb.meta));
        }
        return new TransientHashMap(this.hb.shallowClone());
    }

    public void forEach(BiConsumer biConsumer) {
        this.hb.forEach(biConsumer);
    }

    public void parallelForEach(BiConsumer biConsumer, ExecutorService executorService, int n) throws Exception {
        this.hb.parallelForEach(biConsumer, executorService, n);
    }

    public void parallelForEach(BiConsumer biConsumer) throws Exception {
        this.hb.parallelForEach(biConsumer);
    }

    @Override
    public final PersistentHashMap union(BitmapTrieCommon.MapSet mapSet, BiFunction biFunction) {
        return new PersistentHashMap(this.hb.union(((BitmapTrie.BitmapTrieOwner)((Object)mapSet)).bitmapTrie(), biFunction));
    }

    @Override
    public final PersistentHashMap difference(BitmapTrieCommon.MapSet mapSet) {
        return new PersistentHashMap(this.hb.difference(((BitmapTrie.BitmapTrieOwner)((Object)mapSet)).bitmapTrie()));
    }

    @Override
    public final PersistentHashMap intersection(BitmapTrieCommon.MapSet mapSet, BiFunction biFunction) {
        return new PersistentHashMap(this.hb.intersection(((BitmapTrie.BitmapTrieOwner)((Object)mapSet)).bitmapTrie(), biFunction));
    }

    @Override
    public final PersistentHashMap immutUpdateValues(BiFunction biFunction) {
        return new PersistentHashMap(this.hb.immutUpdate(biFunction));
    }

    @Override
    public final PersistentHashMap immutUpdateValue(Object object, Function function) {
        return new PersistentHashMap(this.hb.immutUpdate(object, function));
    }

    public <K, V> HashMap<K, V> unsafeAsHashMap(K k, V v) {
        return new HashMap(this.hb, true);
    }

    public <K, V> HashMap<K, V> copyToHashMap(K k, V v) {
        return new HashMap(this.hb);
    }

    static final BitmapTrie unpackFromObject(Object object) {
        if (object instanceof BitmapTrie) {
            return (BitmapTrie)object;
        }
        if (object instanceof BitmapTrie.BitmapTrieOwner) {
            return ((BitmapTrie.BitmapTrieOwner)object).bitmapTrie();
        }
        throw new RuntimeException("Cannot get bitmap trie from object: " + String.valueOf(object));
    }

    public static final PersistentHashMap unionReduce(BiFunction biFunction, Iterable iterable) {
        Iterator iterator = iterable.iterator();
        if (!iterator.hasNext()) {
            return null;
        }
        BitmapTrie bitmapTrie = PersistentHashMap.unpackFromObject(iterator.next());
        if (!iterator.hasNext()) {
            return new PersistentHashMap(bitmapTrie);
        }
        bitmapTrie = bitmapTrie.shallowClone(null);
        while (iterator.hasNext()) {
            bitmapTrie = bitmapTrie.union(PersistentHashMap.unpackFromObject(iterator.next()), biFunction, true);
        }
        return new PersistentHashMap(bitmapTrie);
    }

    public static final PersistentHashMap parallelUnionReduce(final BiFunction biFunction, Iterable iterable, ExecutorService executorService, int n) throws Exception {
        int n2;
        Object object2;
        if (ForkJoinTask.inForkJoinPool() && executorService == ForkJoinPool.commonPool() || n == 1) {
            return PersistentHashMap.unionReduce(biFunction, iterable);
        }
        final ArrayList<BitmapTrie> arrayList = new ArrayList<BitmapTrie>();
        for (final Object object2 : iterable) {
            arrayList.add(object2 instanceof BitmapTrie ? (BitmapTrie)object2 : ((BitmapTrie.BitmapTrieOwner)object2).bitmapTrie());
        }
        final int n3 = arrayList.size();
        if (n3 == 0) {
            return null;
        }
        if (n3 == 1) {
            return new PersistentHashMap((BitmapTrie)arrayList.get(0));
        }
        object2 = (BitmapTrie)arrayList.get(0);
        final int n4 = n = Math.min(1024, n);
        Future[] futureArray = new Future[n];
        for (int i = 0; i < n; ++i) {
            n2 = i;
            futureArray[i] = executorService.submit(new Callable<BitmapTrie>(){

                @Override
                public BitmapTrie call() {
                    BitmapTrie bitmapTrie = object2.keyspaceSplit(n2, n4).shallowClone(null);
                    for (int i = 1; i < n3; ++i) {
                        bitmapTrie = bitmapTrie.union(((BitmapTrie)arrayList.get(i)).keyspaceSplit(n2, n4), biFunction, true);
                    }
                    bitmapTrie.size();
                    return bitmapTrie;
                }
            });
        }
        BitmapTrie bitmapTrie = (BitmapTrie)futureArray[0].get();
        n2 = bitmapTrie.size();
        for (int i = 1; i < n; ++i) {
            BitmapTrie bitmapTrie2 = (BitmapTrie)futureArray[i].get();
            n2 += bitmapTrie2.size();
            bitmapTrie = bitmapTrie.union(bitmapTrie2, biFunction);
        }
        bitmapTrie.count = n2;
        return new PersistentHashMap(bitmapTrie);
    }

    public static final PersistentHashMap parallelUnionReduce(BiFunction biFunction, Iterable iterable) throws Exception {
        return PersistentHashMap.parallelUnionReduce(biFunction, iterable, ForkJoinPool.commonPool(), ForkJoinPool.getCommonPoolParallelism());
    }

    public void printNodes() {
        this.hb.printNodes();
    }

    static final void ensureDifferent(BitmapTrieCommon.HashProvider hashProvider, Object[] objectArray) {
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            for (int j = i + 1; j < n; ++j) {
                if (!hashProvider.equals(objectArray[i], objectArray[j])) continue;
                throw new RuntimeException("Duplicate keys provided: " + String.valueOf(objectArray[i]));
            }
        }
    }

    public static final Function<Object[], IPersistentMap> makeFactory(BitmapTrieCommon.HashProvider hashProvider, Object[] objectArray3) {
        switch (objectArray3.length) {
            case 0: {
                PersistentArrayMap persistentArrayMap = new PersistentArrayMap(hashProvider);
                return objectArray -> persistentArrayMap;
            }
            case 1: {
                return objectArray2 -> new PersistentArrayMap(hashProvider, objectArray3[0], objectArray2[0], null);
            }
            case 2: {
                PersistentHashMap.ensureDifferent(hashProvider, objectArray3);
                return objectArray2 -> new PersistentArrayMap(hashProvider, objectArray3[0], objectArray2[0], objectArray3[1], objectArray2[1], null);
            }
            case 3: {
                PersistentHashMap.ensureDifferent(hashProvider, objectArray3);
                return objectArray2 -> new PersistentArrayMap(hashProvider, objectArray3[0], objectArray2[0], objectArray3[1], objectArray2[1], objectArray3[2], objectArray2[2], null);
            }
            case 4: {
                PersistentHashMap.ensureDifferent(hashProvider, objectArray3);
                return objectArray2 -> new PersistentArrayMap(hashProvider, objectArray3[0], objectArray2[0], objectArray3[1], objectArray2[1], objectArray3[2], objectArray2[2], objectArray3[3], objectArray2[3], null);
            }
            case 5: {
                PersistentHashMap.ensureDifferent(hashProvider, objectArray3);
                return objectArray2 -> new PersistentArrayMap(hashProvider, objectArray3[0], objectArray2[0], objectArray3[1], objectArray2[1], objectArray3[2], objectArray2[2], objectArray3[3], objectArray2[3], objectArray3[4], objectArray2[4], null);
            }
            case 6: {
                PersistentHashMap.ensureDifferent(hashProvider, objectArray3);
                return objectArray2 -> new PersistentArrayMap(hashProvider, objectArray3[0], objectArray2[0], objectArray3[1], objectArray2[1], objectArray3[2], objectArray2[2], objectArray3[3], objectArray2[3], objectArray3[4], objectArray2[4], objectArray3[5], objectArray2[5], null);
            }
            case 7: {
                PersistentHashMap.ensureDifferent(hashProvider, objectArray3);
                return objectArray2 -> new PersistentArrayMap(hashProvider, objectArray3[0], objectArray2[0], objectArray3[1], objectArray2[1], objectArray3[2], objectArray2[2], objectArray3[3], objectArray2[3], objectArray3[4], objectArray2[4], objectArray3[5], objectArray2[5], objectArray3[6], objectArray2[6], null);
            }
            case 8: {
                PersistentHashMap.ensureDifferent(hashProvider, objectArray3);
                return objectArray2 -> new PersistentArrayMap(hashProvider, objectArray3[0], objectArray2[0], objectArray3[1], objectArray2[1], objectArray3[2], objectArray2[2], objectArray3[3], objectArray2[3], objectArray3[4], objectArray2[4], objectArray3[5], objectArray2[5], objectArray3[6], objectArray2[6], objectArray3[7], objectArray2[7], null);
            }
        }
        Function<Object[], BitmapTrie> function = BitmapTrie.makeFactory(hashProvider, objectArray3);
        return objectArray -> new PersistentHashMap((BitmapTrie)function.apply((Object[])objectArray));
    }

    public static final IPersistentMap create(BitmapTrieCommon.HashProvider hashProvider, boolean bl, Object ... objectArray) {
        if (objectArray == null || objectArray.length == 0) {
            return new PersistentArrayMap(hashProvider);
        }
        int n = objectArray.length;
        if (n % 2 != 0) {
            throw new RuntimeException("Number of elements not divisible by 2");
        }
        int n2 = n / 2;
        return PersistentHashMap.createN(hashProvider, bl, n2, objectArray);
    }

    public static final IPersistentMap createN(BitmapTrieCommon.HashProvider hashProvider, boolean bl, int n, Object[] objectArray) {
        int n2;
        IObj iObj;
        if (n == 0) {
            return new PersistentArrayMap(hashProvider);
        }
        IKVReduce iKVReduce = null;
        switch (n) {
            case 1: {
                iKVReduce = new PersistentArrayMap(hashProvider, objectArray[0], objectArray[1], null);
                break;
            }
            case 2: {
                if (!PersistentArrayMap.different(hashProvider, objectArray[0], objectArray[2])) break;
                iKVReduce = new PersistentArrayMap(hashProvider, objectArray[0], objectArray[1], objectArray[2], objectArray[3], null);
                break;
            }
            case 3: {
                if (!PersistentArrayMap.different(hashProvider, objectArray[0], objectArray[2], objectArray[4])) break;
                iKVReduce = new PersistentArrayMap(hashProvider, objectArray[0], objectArray[1], objectArray[2], objectArray[3], objectArray[4], objectArray[5], null);
                break;
            }
            case 4: {
                if (!PersistentArrayMap.different(hashProvider, objectArray[0], objectArray[2], objectArray[4], objectArray[6])) break;
                iKVReduce = new PersistentArrayMap(hashProvider, objectArray[0], objectArray[1], objectArray[2], objectArray[3], objectArray[4], objectArray[5], objectArray[6], objectArray[7], null);
                break;
            }
            case 5: {
                if (!PersistentArrayMap.different(hashProvider, objectArray[0], objectArray[2], objectArray[4], objectArray[6], objectArray[8])) break;
                iKVReduce = new PersistentArrayMap(hashProvider, objectArray[0], objectArray[1], objectArray[2], objectArray[3], objectArray[4], objectArray[5], objectArray[6], objectArray[7], objectArray[8], objectArray[9], null);
                break;
            }
            case 6: {
                if (!PersistentArrayMap.different(hashProvider, objectArray[0], objectArray[2], objectArray[4], objectArray[6], objectArray[8], objectArray[10])) break;
                iKVReduce = new PersistentArrayMap(hashProvider, objectArray[0], objectArray[1], objectArray[2], objectArray[3], objectArray[4], objectArray[5], objectArray[6], objectArray[7], objectArray[8], objectArray[9], objectArray[10], objectArray[11], null);
                break;
            }
            case 7: {
                if (!PersistentArrayMap.different(hashProvider, objectArray[0], objectArray[2], objectArray[4], objectArray[6], objectArray[8], objectArray[10], objectArray[12])) break;
                iKVReduce = new PersistentArrayMap(hashProvider, objectArray[0], objectArray[1], objectArray[2], objectArray[3], objectArray[4], objectArray[5], objectArray[6], objectArray[7], objectArray[8], objectArray[9], objectArray[10], objectArray[11], objectArray[12], objectArray[13], null);
                break;
            }
            case 8: {
                if (!PersistentArrayMap.different(hashProvider, objectArray[0], objectArray[2], objectArray[4], objectArray[6], objectArray[8], objectArray[10], objectArray[12], objectArray[14])) break;
                iKVReduce = new PersistentArrayMap(hashProvider, objectArray[0], objectArray[1], objectArray[2], objectArray[3], objectArray[4], objectArray[5], objectArray[6], objectArray[7], objectArray[8], objectArray[9], objectArray[10], objectArray[11], objectArray[12], objectArray[13], objectArray[14], objectArray[15], null);
            }
        }
        if (iKVReduce == null) {
            iObj = new HashMap(hashProvider);
            int n3 = n * 2;
            for (n2 = 0; n2 < n3; n2 += 2) {
                iObj.put(objectArray[n2], objectArray[n2 + 1]);
            }
            iKVReduce = iObj.persistent();
        }
        if (bl && iKVReduce.count() != n) {
            iObj = new HashSet(hashProvider);
            ArrayList<Object> arrayList = new ArrayList<Object>();
            for (n2 = 0; n2 < n; ++n2) {
                Object object = objectArray[n2 * 2];
                if (iObj.contains(object)) {
                    arrayList.add(object);
                }
                iObj.add(object);
            }
            throw new RuntimeException("Map contains duplicate keys: " + String.valueOf(arrayList));
        }
        return iKVReduce;
    }
}

