/*
 * Decompiled with CFR 0.152.
 */
package ham_fisted;

import clojure.lang.IFn;
import clojure.lang.IReduceInit;
import ham_fisted.ArrayLists;
import ham_fisted.Casts;
import ham_fisted.Consumers;
import ham_fisted.IFnDef;
import ham_fisted.IndexedConsumer;
import ham_fisted.IndexedDoubleConsumer;
import ham_fisted.IndexedLongConsumer;
import java.util.function.Consumer;
import java.util.function.DoubleBinaryOperator;
import java.util.function.DoubleConsumer;
import java.util.function.LongBinaryOperator;
import java.util.function.LongConsumer;

public interface ITypedReduce<E>
extends IReduceInit {
    default public double doubleReduction(final DoubleBinaryOperator doubleBinaryOperator, double d) {
        return Casts.doubleCast(this.reduce(new IFnDef(){

            @Override
            public Object invoke(Object object, Object object2) {
                return doubleBinaryOperator.applyAsDouble(Casts.doubleCast(object), Casts.doubleCast(object2));
            }
        }, d));
    }

    default public long longReduction(final LongBinaryOperator longBinaryOperator, long l) {
        return Casts.longCast(this.reduce(new IFnDef(){

            @Override
            public Object invoke(Object object, Object object2) {
                return longBinaryOperator.applyAsLong(Casts.longCast(object), Casts.longCast(object2));
            }
        }, l));
    }

    default public void forEach(final Consumer<E> consumer) {
        this.reduce(new IFnDef(){

            @Override
            public Object invoke(Object object, Object object2) {
                consumer.accept(object2);
                return consumer;
            }
        }, consumer);
    }

    default public Object genericReduction(Object object, Object object2) {
        if (object instanceof DoubleBinaryOperator) {
            return this.doubleReduction((DoubleBinaryOperator)object, Casts.doubleCast(object2));
        }
        if (object instanceof LongBinaryOperator) {
            return this.longReduction((LongBinaryOperator)object, Casts.longCast(object2));
        }
        if (!(object instanceof IFn)) {
            throw new RuntimeException("reducer must be an instance of clojure.lang.IFn, java.util.function.DoubleBinaryOperator or java.util.function.LongBinaryOperator.");
        }
        return this.reduce((IFn)object, object2);
    }

    default public void doubleForEach(final DoubleConsumer doubleConsumer) {
        this.forEach(new Consumer(){

            public void accept(Object object) {
                doubleConsumer.accept(Casts.doubleCast(object));
            }
        });
    }

    default public void longForEach(final LongConsumer longConsumer) {
        this.forEach(new Consumer(){

            public void accept(Object object) {
                longConsumer.accept(Casts.longCast(object));
            }
        });
    }

    default public void genericForEach(Object object) {
        DoubleConsumer doubleConsumer = ArrayLists.asDoubleConsumer(object);
        if (doubleConsumer != null) {
            this.doubleForEach(doubleConsumer);
        } else {
            LongConsumer longConsumer = ArrayLists.asLongConsumer(object);
            if (longConsumer != null) {
                this.longForEach(longConsumer);
            } else {
                if (!(object instanceof Consumer)) {
                    throw new RuntimeException("Consumer must be an instance of java.util.function Consumer, DoubleConsumer, or LongConsumer.");
                }
                this.forEach((Consumer)object);
            }
        }
    }

    default public void genericIndexedForEach(long l, Object object) {
        IndexedDoubleConsumer indexedDoubleConsumer = Consumers.asIndexedDoubleConsumer(object);
        if (indexedDoubleConsumer != null) {
            this.doubleForEach(Consumers.toDoubleConsumer(l, indexedDoubleConsumer));
        } else {
            IndexedLongConsumer indexedLongConsumer = Consumers.asIndexedLongConsumer(object);
            if (indexedLongConsumer != null) {
                this.longForEach(Consumers.toLongConsumer(l, indexedLongConsumer));
            } else {
                IndexedConsumer indexedConsumer = Consumers.asIndexedConsumer(object);
                if (indexedConsumer == null) {
                    throw new RuntimeException("Consumer must be an instance of ham_fisted IndexedConsumer, IndexedDoubleConsumer, or IndexedLongConsumer.");
                }
                this.forEach(Consumers.toConsumer(l, indexedConsumer));
            }
        }
    }
}

