/*
 * Decompiled with CFR 0.152.
 */
package ham_fisted;

import clojure.lang.IPersistentMap;
import ham_fisted.IMutList;
import ham_fisted.TypedList;
import it.unimi.dsi.fastutil.ints.IntComparator;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;

public class ReindexList
implements IMutList,
TypedList {
    final int[] indexes;
    final List data;
    final IPersistentMap meta;

    static int checkIndex(int n, int n2) {
        if (n < 0 || n >= n2) {
            throw new RuntimeException("Index out of range: " + String.valueOf(n));
        }
        return n;
    }

    public static ReindexList create(int[] nArray, List list, IPersistentMap iPersistentMap) {
        if (list instanceof IMutList) {
            return new MutReindexList(nArray, (IMutList)list, iPersistentMap);
        }
        return new ReindexList(nArray, list, iPersistentMap);
    }

    public ReindexList(int[] nArray, List list, IPersistentMap iPersistentMap) {
        this.indexes = nArray;
        this.data = list;
        this.meta = iPersistentMap;
    }

    @Override
    public Class containedType() {
        return this.data instanceof TypedList ? ((TypedList)((Object)this.data)).containedType() : null;
    }

    @Override
    public int size() {
        return this.indexes.length;
    }

    @Override
    public Object get(int n) {
        ReindexList.checkIndex(n, this.indexes.length);
        return this.data.get(this.indexes[n]);
    }

    @Override
    public Object set(int n, Object object) {
        ReindexList.checkIndex(n, this.indexes.length);
        return this.data.set(this.indexes[n], object);
    }

    public ReindexList subList(int n, int n2) {
        return ReindexList.create(Arrays.copyOfRange(this.indexes, n, n2), this.data, this.meta);
    }

    @Override
    public IntComparator indexComparator() {
        if (this.data instanceof IMutList) {
            IMutList iMutList = (IMutList)this.data;
            final IntComparator intComparator = iMutList.indexComparator();
            return new IntComparator(){

                public int compare(int n, int n2) {
                    return intComparator.compare(ReindexList.this.indexes[n], ReindexList.this.indexes[n2]);
                }
            };
        }
        return new IntComparator(){

            public int compare(int n, int n2) {
                return ((Comparable)ReindexList.this.data.get(ReindexList.this.indexes[n])).compareTo(ReindexList.this.data.get(ReindexList.this.indexes[n2]));
            }
        };
    }

    @Override
    public IntComparator indexComparator(final Comparator comparator) {
        if (comparator == null) {
            return this.indexComparator();
        }
        if (this.data instanceof IMutList) {
            IMutList iMutList = (IMutList)this.data;
            final IntComparator intComparator = iMutList.indexComparator(comparator);
            return new IntComparator(){

                public int compare(int n, int n2) {
                    return intComparator.compare(ReindexList.this.indexes[n], ReindexList.this.indexes[n2]);
                }
            };
        }
        return new IntComparator(){

            public int compare(int n, int n2) {
                return comparator.compare(ReindexList.this.data.get(ReindexList.this.indexes[n]), ReindexList.this.data.get(ReindexList.this.indexes[n2]));
            }
        };
    }

    @Override
    public IPersistentMap meta() {
        return this.meta;
    }

    @Override
    public ReindexList withMeta(IPersistentMap iPersistentMap) {
        return ReindexList.create(this.indexes, this.data, iPersistentMap);
    }

    @Override
    public List reindex(int[] nArray) {
        int n = nArray.length;
        int[] nArray2 = new int[n];
        boolean bl = true;
        for (int i = 0; i < n; ++i) {
            int n2 = this.indexes[nArray[i]];
            bl = bl && n2 == i;
            nArray2[i] = n2;
        }
        if (bl) {
            if (n == this.data.size()) {
                return this.data;
            }
            return this.data.subList(0, n);
        }
        return ReindexList.create(nArray2, this.data, this.meta);
    }

    public static class MutReindexList
    extends ReindexList {
        IMutList mlist;

        public MutReindexList(int[] nArray, IMutList iMutList, IPersistentMap iPersistentMap) {
            super(nArray, iMutList, iPersistentMap);
            this.mlist = iMutList;
        }

        @Override
        public long getLong(int n) {
            MutReindexList.checkIndex(n, this.indexes.length);
            return this.mlist.getLong(this.indexes[n]);
        }

        @Override
        public void setLong(int n, long l) {
            MutReindexList.checkIndex(n, this.indexes.length);
            this.mlist.setLong(this.indexes[n], l);
        }

        @Override
        public double getDouble(int n) {
            MutReindexList.checkIndex(n, this.indexes.length);
            return this.mlist.getDouble(this.indexes[n]);
        }

        @Override
        public void setDouble(int n, double d) {
            MutReindexList.checkIndex(n, this.indexes.length);
            this.mlist.setDouble(this.indexes[n], d);
        }

        @Override
        public boolean getBoolean(int n) {
            MutReindexList.checkIndex(n, this.indexes.length);
            return this.mlist.getBoolean(this.indexes[n]);
        }

        @Override
        public void setBoolean(int n, boolean bl) {
            MutReindexList.checkIndex(n, this.indexes.length);
            this.mlist.setBoolean(this.indexes[n], bl);
        }
    }
}

