/*
 * Decompiled with CFR 0.152.
 */
package ham_fisted;

import clojure.lang.IDeref;
import java.util.function.Consumer;
import java.util.function.DoubleConsumer;
import java.util.function.DoublePredicate;
import java.util.function.DoubleUnaryOperator;
import java.util.function.Function;
import java.util.function.LongConsumer;
import java.util.function.LongPredicate;
import java.util.function.LongUnaryOperator;
import java.util.function.Predicate;

public class Consumers {
    public static DoubleConsumer map(final DoubleUnaryOperator doubleUnaryOperator, final DoubleConsumer doubleConsumer) {
        return new IDerefDoubleConsumer(){

            @Override
            public void accept(double d) {
                doubleConsumer.accept(doubleUnaryOperator.applyAsDouble(d));
            }

            public Object deref() {
                return ((IDeref)doubleConsumer).deref();
            }
        };
    }

    public static LongConsumer map(final LongUnaryOperator longUnaryOperator, final LongConsumer longConsumer) {
        return new IDerefLongConsumer(){

            @Override
            public void accept(long l) {
                longConsumer.accept(longUnaryOperator.applyAsLong(l));
            }

            public Object deref() {
                return ((IDeref)longConsumer).deref();
            }
        };
    }

    public static Consumer map(final Function function, final Consumer consumer) {
        return new IDerefConsumer(){

            public void accept(Object object) {
                consumer.accept(function.apply(object));
            }

            public Object deref() {
                return ((IDeref)consumer).deref();
            }
        };
    }

    public static DoubleConsumer filter(final DoublePredicate doublePredicate, final DoubleConsumer doubleConsumer) {
        return new IDerefDoubleConsumer(){

            @Override
            public void accept(double d) {
                if (doublePredicate.test(d)) {
                    doubleConsumer.accept(d);
                }
            }

            public Object deref() {
                return ((IDeref)doubleConsumer).deref();
            }
        };
    }

    public static LongConsumer filter(final LongPredicate longPredicate, final LongConsumer longConsumer) {
        return new IDerefLongConsumer(){

            @Override
            public void accept(long l) {
                if (longPredicate.test(l)) {
                    longConsumer.accept(l);
                }
            }

            public Object deref() {
                return ((IDeref)longConsumer).deref();
            }
        };
    }

    public static Consumer filter(final Predicate predicate, final Consumer consumer) {
        return new IDerefConsumer(){

            public void accept(Object object) {
                if (predicate.test(object)) {
                    consumer.accept(object);
                }
            }

            public Object deref() {
                return ((IDeref)consumer).deref();
            }
        };
    }

    public static interface IDerefConsumer
    extends IDeref,
    Consumer {
    }

    public static interface IDerefLongConsumer
    extends IDeref,
    LongConsumer {
    }

    public static interface IDerefDoubleConsumer
    extends IDeref,
    DoubleConsumer {
    }
}

