/*
 * Decompiled with CFR 0.152.
 */
package ham_fisted;

import clojure.lang.IPersistentMap;
import clojure.lang.RT;
import ham_fisted.Casts;
import ham_fisted.DoubleMutList;
import ham_fisted.IMutList;
import ham_fisted.LongMutList;
import ham_fisted.TypedList;
import it.unimi.dsi.fastutil.ints.IntComparator;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Random;

public class ConstList
implements IMutList<Object>,
TypedList {
    public final int nElems;
    public final Object value;
    public final IPersistentMap meta;

    public ConstList(int n, Object object, IPersistentMap iPersistentMap) {
        this.nElems = n;
        this.value = object;
        this.meta = iPersistentMap;
    }

    @Override
    public IMutList cloneList() {
        return this;
    }

    @Override
    public Class containedType() {
        return this.value != null ? this.value.getClass() : Object.class;
    }

    public static ConstList create(int n, Object object, IPersistentMap iPersistentMap) {
        if (object instanceof Long || object instanceof Integer || object instanceof Short || object instanceof Byte || object instanceof Character) {
            return new LongConstList(n, Casts.longCast(object), iPersistentMap);
        }
        if (object instanceof Double || object instanceof Float) {
            return new DoubleConstList(n, Casts.doubleCast(object), iPersistentMap);
        }
        return new ConstList(n, object, iPersistentMap);
    }

    @Override
    public int size() {
        return this.nElems;
    }

    @Override
    public Object get(int n) {
        return this.value;
    }

    public ConstList subList(int n, int n2) {
        if (n < 0 || n >= this.nElems) {
            throw new RuntimeException("Start index out of range.");
        }
        if (n2 < n || n2 > this.nElems) {
            throw new RuntimeException("End index out of range.");
        }
        return ConstList.create(n2 - n, this.value, this.meta);
    }

    public ConstList sort(Comparable comparable) {
        return this;
    }

    public ConstList immutSort(Comparable comparable) {
        return this;
    }

    public ConstList ImmutSort() {
        return this;
    }

    @Override
    public ConstList reverse() {
        return this;
    }

    public int[] sortIndirect() {
        return new int[this.nElems];
    }

    @Override
    public Object[] toArray() {
        Object[] objectArray = new Object[this.nElems];
        Arrays.fill(objectArray, this.value);
        return objectArray;
    }

    @Override
    public int[] toIntArray() {
        int n = RT.intCast((long)Casts.longCast(this.value));
        int[] nArray = new int[this.nElems];
        Arrays.fill(nArray, n);
        return nArray;
    }

    @Override
    public long[] toLongArray() {
        long l = Casts.longCast(this.value);
        long[] lArray = new long[this.nElems];
        Arrays.fill(lArray, l);
        return lArray;
    }

    @Override
    public double[] toDoubleArray() {
        double d = Casts.doubleCast(this.value);
        double[] dArray = new double[this.nElems];
        Arrays.fill(dArray, d);
        return dArray;
    }

    @Override
    public ConstList reindex(int[] nArray) {
        return ConstList.create(nArray.length, this.value, this.meta);
    }

    @Override
    public List immutShuffle(Random random) {
        return this;
    }

    @Override
    public IntComparator indexComparator(Comparator comparator) {
        return new IntComparator(){

            public int compare(int n, int n2) {
                return 0;
            }
        };
    }

    @Override
    public IPersistentMap meta() {
        return this.meta;
    }

    @Override
    public ConstList withMeta(IPersistentMap iPersistentMap) {
        return ConstList.create(this.nElems, this.value, iPersistentMap);
    }

    public static class DoubleConstList
    extends ConstList
    implements DoubleMutList {
        double lval;

        public DoubleConstList(int n, double d, IPersistentMap iPersistentMap) {
            super(n, d, iPersistentMap);
            this.lval = d;
        }

        @Override
        public Class containedType() {
            return Double.TYPE;
        }

        @Override
        public double getDouble(int n) {
            return this.lval;
        }
    }

    public static class LongConstList
    extends ConstList
    implements LongMutList {
        long lval;

        public LongConstList(int n, long l, IPersistentMap iPersistentMap) {
            super(n, l, iPersistentMap);
            this.lval = l;
        }

        @Override
        public Class containedType() {
            return Long.TYPE;
        }

        @Override
        public long getLong(int n) {
            return this.lval;
        }
    }
}

