/*
 * Decompiled with CFR 0.152.
 */
package charred;

import java.io.IOException;
import java.io.Reader;

public class LineNumberReader {
    final char[] buffer;
    final Reader reader;
    int position = 0;
    int len = 0;
    int line = 1;
    int column = 1;
    int lastColumn = 0;

    public LineNumberReader(Reader reader, int n) {
        this.reader = reader;
        this.buffer = new char[n];
    }

    public LineNumberReader(Reader reader) {
        this(reader, 2056);
    }

    public int getLineNumber() {
        return this.line;
    }

    public int getColumnNumber() {
        return this.column;
    }

    public char update(char c) {
        if (c == '\n') {
            ++this.line;
            this.lastColumn = this.column;
            this.column = 1;
        } else {
            ++this.column;
        }
        return c;
    }

    public int read() throws IOException {
        char[] cArray = this.buffer();
        if (cArray == null) {
            return -1;
        }
        return this.update(this.buffer[this.position++]);
    }

    public void unread() {
        if (this.len == -1) {
            return;
        }
        if (this.position == 0 || this.len == 0) {
            throw new RuntimeException("Too many unread ops.");
        }
        --this.position;
        if (this.buffer[this.position] == '\n') {
            --this.line;
            this.column = this.lastColumn;
        } else {
            --this.column;
        }
    }

    public void unread(int n) {
        if (this.len == -1) {
            return;
        }
        this.unread();
        this.buffer[this.position] = (char)n;
    }

    public char[] buffer() throws IOException {
        if (this.len == -1) {
            return null;
        }
        if (this.position == this.len) {
            int n;
            this.len = this.reader.read(this.buffer, 0, this.buffer.length - 1);
            if (this.len == -1) {
                return null;
            }
            int n2 = 0;
            boolean bl = false;
            int n3 = this.len;
            block4: for (n = 0; n < n3; ++n) {
                char c = this.buffer[n];
                switch (c) {
                    case '\r': {
                        bl = true;
                        continue block4;
                    }
                    case '\n': {
                        bl = false;
                        this.buffer[n2++] = c;
                        continue block4;
                    }
                    default: {
                        if (bl) {
                            this.buffer[n2++] = 10;
                            bl = false;
                        }
                        this.buffer[n2++] = c;
                    }
                }
            }
            if (bl) {
                this.buffer[n2++] = 10;
                n = this.reader.read();
                if (n != 10 && n != -1) {
                    this.buffer[n2++] = (char)n;
                }
            }
            this.len = n2;
            this.position = 0;
        }
        return this.buffer;
    }

    public int position() {
        return this.position;
    }

    public void setPosition(int n) {
        this.position = n;
    }

    public int len() {
        return this.len;
    }
}

